/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.plugin.Plugin;
import org.kingdoms.gui.GUIConfig;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.objects.GUIObject;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.LanguageEntry;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.placeholders.StandardKingdomsPlaceholder;
import org.kingdoms.locale.messenger.DefinedMessenger;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.locale.provider.MessageProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.config.adapters.YamlFiledDefaults;
import org.kingdoms.utils.config.adapters.YamlResource;
import org.kingdoms.utils.config.adapters.YamlWithDefaults;
import org.kingdoms.utils.internal.nonnull.NonNullMap;
import org.kingdoms.utils.string.StringUtils;

public enum SupportedLanguage {
    EN(Locale.ENGLISH, "English", "US", "UK"),
    HU("Magyar", "Magyar nyelv", "Hungarian"),
    RU("\u0420\u0443\u0441\u0441\u043a\u0438\u0439", "Russian", "P\u0443\u0441\u0441\u043a\u0438\u0439 \u044f\u0437\u044b\u043a", "Russia"),
    ES("Espa\u00f1ol", "Spanish", "Espanol", "Castilian", "Castellano"),
    DE(Locale.GERMAN, "Deutsch", "German", "Schwiizerdutsch", "\u00d6sterreichisches", "bar_AT", "gsw_CH", "deu_DE"),
    PL("Polski", "Polish", "Poland"),
    TR("T\u00fcrk\u00e7e", "T\u00fcrk dili", "Turkish", "Turkey"),
    ZH(Locale.CHINESE, "\u6c49\u8bed", "\u6f22\u8a9e", "\u4e2d\u6587", "Zh\u014dngw\u00e9n", "Chinese", "China"),
    CS("\u010ce\u0161tina", "Bohemian", "Czech");

    public static final SupportedLanguage[] VALUES;
    protected Map<LanguageEntry, MessageProvider> messages;
    public static final String MACROS_ENTRY = "variables";
    private final String nativeName;
    private final Locale locale;
    private YamlWithDefaults adapter;
    private Map<String, GUIObject> guis;
    private String installedCommitSHA;

    private SupportedLanguage(String ... names) {
        this((Locale)null, names);
    }

    private SupportedLanguage(Locale locale, String ... names) {
        Locale locale2 = this.locale = locale == null ? new Locale(this.name().toLowerCase(Locale.ENGLISH)) : locale;
        if (this.name().equals("EN")) {
            this.initialize();
        }
        this.nativeName = names[0];
        String lowerName = this.getLowerCaseName();
        NameContainer.NAMES.put(lowerName, this);
        Stream.of(names).forEach(x -> NameContainer.NAMES.put(x.toLowerCase(), this));
    }

    public void initialize() {
        if (this.name().equals("EN")) {
            this.installedCommitSHA = Kingdoms.get().getCompileCommitSHA();
        }
        if (this.messages == null) {
            this.messages = new NonNullMap<LanguageEntry, MessageProvider>(KingdomsLang.VALUES.length);
        }
        if (this.guis == null) {
            this.guis = new NonNullMap<String, GUIObject>(KingdomsGUI.SIZE);
        }
        if (this.adapter == null) {
            if (this.name().equals("EN")) {
                this.adapter = new YamlResource((Plugin)Kingdoms.get(), this.getMainLanguageFile().toFile(), null);
                this.installedCommitSHA = Kingdoms.get().getCompileCommitSHA();
            } else {
                this.adapter = new YamlFiledDefaults(this.getMainLanguageFile().toFile(), this.getRepoPath().resolve(this.getLowerCaseName() + ".yml").toFile());
            }
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public static List<SupportedLanguage> getInstalled() {
        return Arrays.stream(VALUES).filter(SupportedLanguage::isInstalled).collect(Collectors.toList());
    }

    public static Collection<String> getRegisteredGUINames() {
        return EN.getGUIs().keySet();
    }

    public Path getRepoPath() {
        return LanguageManager.LANGUAGES_REPO_FOLDER.resolve(this.getLowerCaseName());
    }

    protected void uninstall() {
        if (this == EN) {
            throw new IllegalStateException("Cannot uninstall default English translation");
        }
        this.installedCommitSHA = null;
        this.messages = null;
        this.guis = null;
        this.adapter = null;
    }

    public boolean isInstalled() {
        return this.installedCommitSHA != null;
    }

    public Path getMainLanguageFile() {
        return Kingdoms.getPath("languages").resolve(this.getLowerCaseName() + ".yml");
    }

    public Path getGUIFolder() {
        return GUIConfig.getFolder().resolve(this.getLowerCaseName());
    }

    public @Nullable GUIObject getGUIOrDefault(String name) {
        GUIObject raw = this.getGUI(name);
        if (this == EN && raw == null) {
            throw new IllegalStateException("GUI named " + name + " is null for English");
        }
        return raw != null ? raw : EN.getGUI(name);
    }

    public void addMessage(DefinedMessenger messenger, MessageProvider provider) {
        this.messages.put(messenger.getLanguageEntry(), provider);
    }

    public Map<LanguageEntry, MessageProvider> getMessages() {
        return this.messages;
    }

    public GUIObject getGUI(String name) {
        return this.guis != null ? this.guis.get(name) : null;
    }

    public Map<String, GUIObject> getGUIs() {
        this.ensureInstalled();
        return this.guis;
    }

    public void ensureInstalled() {
        if (!this.isInstalled()) {
            throw new IllegalStateException("This language isn't marked as installed: " + this.name());
        }
    }

    public String getInstalledCommitSHA() {
        return this.installedCommitSHA;
    }

    public void setInstalledCommitSHA(String installedCommitSHA) {
        this.installedCommitSHA = installedCommitSHA;
    }

    public String getLowerCaseName() {
        return StringUtils.toLatinLowerCase(this.name());
    }

    public YamlWithDefaults getAdapter() {
        this.ensureInstalled();
        return this.adapter;
    }

    public String getNativeName() {
        return this.nativeName;
    }

    public static SupportedLanguage fromName(String name) {
        int iso3 = name.indexOf(95);
        if (iso3 != -1) {
            name = name.substring(0, iso3);
        }
        return (SupportedLanguage)((Object)NameContainer.NAMES.get(name.toLowerCase()));
    }

    public MessageProvider getMessage(LanguageEntry lang, boolean error) {
        MessageProvider current;
        MessageProvider messageProvider = current = this.messages == null ? null : this.messages.get(lang);
        if (this == EN && current == null) {
            if (error) {
                throw new IllegalStateException("Language entry " + lang + " is null for English");
            }
            return null;
        }
        return current == null ? EN.getMessage(lang, error) : current;
    }

    public MessageObject getMessage(String ... path) {
        MessageProvider current;
        LanguageEntry entry = new LanguageEntry(path);
        MessageProvider messageProvider = current = this.messages == null ? null : this.messages.get(entry);
        if (current == null) {
            current = SupportedLanguage.EN.messages.get(entry);
        }
        return current.getMessage();
    }

    public MessageObject getVariableRaw(String name) {
        LanguageEntry entry = new LanguageEntry(new String[]{MACROS_ENTRY, name});
        MessageProvider variable = this.messages.get(entry);
        return variable == null ? null : variable.getMessage();
    }

    public MessageObject getVariable(MessageBuilder settings, String name) {
        MessageProvider current;
        LanguageEntry entry = new LanguageEntry(new String[]{MACROS_ENTRY, name});
        MessageProvider messageProvider = current = this.messages == null ? null : this.messages.get(entry);
        if (current == null) {
            current = SupportedLanguage.EN.messages.get(entry);
        }
        if (current != null) {
            return current.getMessage();
        }
        return StandardKingdomsPlaceholder.getMacro(name, settings);
    }

    static {
        VALUES = SupportedLanguage.values();
    }

    private static final class NameContainer {
        private static final Map<String, SupportedLanguage> NAMES = new HashMap<String, SupportedLanguage>(30);

        private NameContainer() {
        }
    }
}

