/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.main;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginLoader;
import org.bukkit.plugin.java.JavaPlugin;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;

abstract class KingdomsBootloaderDelegator
implements Plugin {
    protected final JavaPlugin loader;

    public KingdomsBootloaderDelegator(JavaPlugin loader) {
        this.loader = loader;
    }

    @NotNull
    public File getDataFolder() {
        return this.loader.getDataFolder();
    }

    @NotNull
    public PluginDescriptionFile getDescription() {
        return this.loader.getDescription();
    }

    @NotNull
    public FileConfiguration getConfig() {
        return this.loader.getConfig();
    }

    @Nullable
    public InputStream getResource(@NotNull String filename) {
        try {
            URL url = this.getClass().getClassLoader().getResource(filename);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public void saveConfig() {
        this.loader.saveConfig();
    }

    public void saveDefaultConfig() {
        this.loader.saveDefaultConfig();
    }

    public void saveResource(@NotNull String s, boolean b) {
        this.loader.saveResource(s, b);
    }

    public void reloadConfig() {
        this.loader.reloadConfig();
    }

    @NotNull
    public PluginLoader getPluginLoader() {
        return this.loader.getPluginLoader();
    }

    @NotNull
    public Server getServer() {
        return this.loader.getServer();
    }

    public boolean isEnabled() {
        return this.loader.isEnabled();
    }

    public boolean isNaggable() {
        return this.loader.isNaggable();
    }

    public void setNaggable(boolean b) {
        this.loader.setNaggable(b);
    }

    @Nullable
    public ChunkGenerator getDefaultWorldGenerator(@NotNull String s, @Nullable String s1) {
        return this.loader.getDefaultWorldGenerator(s, s1);
    }

    @Nullable
    public BiomeProvider getDefaultBiomeProvider(@NotNull String s, @Nullable String s1) {
        return this.loader.getDefaultBiomeProvider(s, s1);
    }

    @NotNull
    public Logger getLogger() {
        return this.loader.getLogger();
    }

    @NotNull
    public String getName() {
        return this.loader.getName();
    }

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] strings) {
        return this.loader.onCommand(commandSender, command, s, strings);
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] strings) {
        return this.loader.onTabComplete(commandSender, command, s, strings);
    }
}

