/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomItemStyle;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretRegistry;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.libs.xseries.ReflectionUtils;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.managers.structures.StructureManager;
import org.kingdoms.managers.turrets.TurretManager;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.nbt.ItemNBT;
import org.kingdoms.utils.nbt.NBTType;
import org.kingdoms.utils.nbt.NBTWrappers;

public final class KingdomItemManager
implements Listener {
    private static final MethodHandle SET_SHOOT_CONSUMABLE_ITEM;

    private static boolean shouldNotProtectAgainstInventory(Inventory inv) {
        switch (inv.getType()) {
            case PLAYER: 
            case CHEST: 
            case ENDER_CHEST: 
            case HOPPER: 
            case DROPPER: 
            case DISPENSER: {
                return true;
            }
        }
        return XMaterial.supports(11) && inv.getType() == InventoryType.SHULKER_BOX;
    }

    public static boolean isKingdomItem(ItemStack item) {
        NBTWrappers.NBTTagCompound nbt = ItemNBT.getTag(item);
        return nbt.has("Kingdoms");
    }

    @EventHandler(ignoreCancelled=true)
    public void onDropItem(PlayerDropItemEvent event) {
        Item dropped = event.getItemDrop();
        ItemStack item = dropped.getItemStack();
        NBTWrappers.NBTTagCompound nbt = ItemNBT.getTag(item);
        if ((nbt = nbt.getCompound("Kingdoms")) == null) {
            return;
        }
        String tag = nbt.get("Structure", NBTType.STRING);
        KingdomItemStyle kingdomItem = null;
        if (tag != null) {
            kingdomItem = StructureRegistry.getStyle(tag);
        } else {
            tag = nbt.get("Turret", NBTType.STRING);
            if (tag != null) {
                kingdomItem = TurretRegistry.getStyle(tag);
            }
        }
        if (kingdomItem != null) {
            kingdomItem.droppedItemName(dropped);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onClaim(ClaimLandEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        Player player = event.getPlayer().getPlayer();
        if (player == null) {
            return;
        }
        Kingdom kingdom = event.getKingdom();
        for (Land land : event.getLands()) {
            List<Turret> removedTurrets;
            MessageBuilder settings = new MessageBuilder().withContext(kingdom).parse("chunk", KingdomsLang.LOCATIONS_CHUNK.parse(LocationUtils.getChunkEdits(land.getLocation())));
            List<Structure> removedStructures = StructureManager.breakExtraStructures(kingdom, land);
            if (!removedStructures.isEmpty()) {
                KingdomsLang.STRUCTURES_LIMIT_ON_CLAIM.sendError((CommandSender)player, settings);
            }
            if ((removedTurrets = TurretManager.breakExtraTurrets(kingdom, land)).isEmpty()) continue;
            KingdomsLang.TURRETS_LIMIT_ON_CLAIM.sendError((CommandSender)player, settings);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemPickup(PlayerPickupItemEvent event) {
        Player player = event.getPlayer();
        if (!PlayerUtils.invulnerableGameMode(player)) {
            return;
        }
        if (KingdomsPluginPermission.CREATIVE_PICKUP.hasPermission((CommandSender)player, true)) {
            return;
        }
        ItemStack item = event.getItem().getItemStack();
        if (KingdomItemManager.isKingdomItem(item)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryUse(InventoryClickEvent event) {
        Inventory inv = event.getClickedInventory();
        if (inv == null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!PlayerUtils.invulnerableGameMode(player)) {
            return;
        }
        if (KingdomsPluginPermission.INVENTORY_BYPASS.hasPermission((CommandSender)player, true)) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (KingdomItemManager.isKingdomItem(item)) {
            KingdomsLang.KINGDOM_ITEM_INVENTORY.sendError((CommandSender)player, new Object[0]);
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onKingdomItemShoot(EntityShootBowEvent event) {
        if (!ReflectionUtils.supports(13)) {
            return;
        }
        ItemStack itemBeingShot = event.getConsumable();
        if (itemBeingShot == null) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (!ItemNBT.isKingdomsItem(itemBeingShot)) {
            return;
        }
        Player shooter = (Player)event.getEntity();
        if (shooter.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        for (ItemStack item : shooter.getInventory().getStorageContents()) {
            if (item == null || !item.getType().name().contains("ARROW") || ItemNBT.isKingdomsItem(item)) continue;
            event.setConsumeItem(false);
            try {
                SET_SHOOT_CONSUMABLE_ITEM.invoke(event, item);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return;
        }
        event.setConsumeItem(false);
        event.setCancelled(true);
        KingdomsLang.KINGDOM_ITEM_SHOOT.sendError((CommandSender)shooter, new Object[0]);
    }

    @EventHandler(ignoreCancelled=true)
    public void onUseKingdomItemForCrafting(CraftItemEvent event) {
        boolean result = true;
        for (ItemStack item : event.getInventory().getContents()) {
            if (result) {
                result = false;
                continue;
            }
            if (item.getType() == Material.AIR || !ItemNBT.isKingdomsItem(item)) continue;
            KingdomsLang.KINGDOM_ITEM_CRAFT.sendError((CommandSender)event.getWhoClicked(), new Object[0]);
            event.setCancelled(true);
            return;
        }
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle shootSetter = null;
        try {
            if (ReflectionUtils.supports(14)) {
                Field field = EntityShootBowEvent.class.getDeclaredField("consumable");
                field.setAccessible(true);
                shootSetter = lookup.unreflectSetter(field);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        SET_SHOOT_CONSUMABLE_ITEM = shootSetter;
    }
}

