/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import com.google.common.base.Enums;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.ReflectionUtils;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.Masswar;
import org.kingdoms.managers.land.LandProtectionManager;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.services.managers.SoftService;
import org.kingdoms.services.worldguard.ServiceWorldGuard;

public final class PvPManager
implements Listener {
    private static final String TRIDENT_LIGHTNING_SHOOTER = "TRIDENT_LIGHTNING_SHOOTER";
    private static final PvPType PVP_TYPE;

    public PvPManager() {
        if (ReflectionUtils.supports(13)) {
            Bukkit.getPluginManager().registerEvents((Listener)new v1_13(), (Plugin)Kingdoms.get());
        }
    }

    public static LivingEntity getKiller(EntityDeathEvent event) {
        EntityDamageEvent entityDamageEvent = event.getEntity().getLastDamageCause();
        if (entityDamageEvent instanceof EntityDamageByEntityEvent) {
            ProjectileSource shooter;
            Entity damager = ((EntityDamageByEntityEvent)entityDamageEvent).getDamager();
            if (damager instanceof Projectile && (shooter = ((Projectile)damager).getShooter()) instanceof LivingEntity) {
                LivingEntity entityShooter = (LivingEntity)shooter;
                UUID owner = ServiceHandler.getPetOwner((Entity)entityShooter);
                if (owner != null) {
                    return Bukkit.getPlayer((UUID)owner);
                }
                return entityShooter;
            }
            if (damager instanceof LivingEntity) {
                UUID owner = ServiceHandler.getPetOwner(damager);
                if (owner != null) {
                    return Bukkit.getPlayer((UUID)owner);
                }
                return (LivingEntity)damager;
            }
        }
        return event.getEntity().getKiller();
    }

    public static boolean isPvPType(PvPType PvPType2) {
        return PVP_TYPE == PvPType2;
    }

    public static PvPType getPvpType() {
        return PVP_TYPE;
    }

    public static Player getDamager(Entity entity) {
        UUID owner;
        Object shooter;
        if (entity instanceof Projectile && (shooter = ((Projectile)entity).getShooter()) instanceof Player) {
            Player entityShooter = (Player)shooter;
            UUID owner2 = ServiceHandler.getPetOwner((Entity)entityShooter);
            if (owner2 != null) {
                return Bukkit.getPlayer((UUID)owner2);
            }
            return entityShooter;
        }
        if (entity instanceof LivingEntity && (owner = ServiceHandler.getPetOwner(entity)) != null) {
            return Bukkit.getPlayer((UUID)owner);
        }
        if (entity instanceof LightningStrike && !(shooter = entity.getMetadata(TRIDENT_LIGHTNING_SHOOTER)).isEmpty()) {
            return (Player)((MetadataValue)shooter.get(0)).value();
        }
        if (entity instanceof Player) {
            return (Player)entity;
        }
        return null;
    }

    public static boolean canFight(@NonNull Player damager, @NonNull Player victim) {
        Land victimLand;
        boolean unclaimed;
        ServiceWorldGuard service;
        if (PVP_TYPE == PvPType.DISABLED) {
            return true;
        }
        if (PVP_TYPE == PvPType.DISALLOWED) {
            return false;
        }
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)damager)) {
            return true;
        }
        boolean normal = PVP_TYPE == PvPType.NORMAL;
        KingdomPlayer damagerKp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)damager);
        if (damagerKp.isAdmin()) {
            return true;
        }
        KingdomPlayer victimKp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)victim);
        if (damagerKp.isPvp() && victimKp.isPvp()) {
            return true;
        }
        if (SoftService.WORLD_GUARD.isAvailable() && (service = ServiceHandler.getWorldGuardService()).hasFriendlyFireFlag(damager) && service.hasFriendlyFireFlag(victim)) {
            return true;
        }
        Kingdom damagerKingdom = damagerKp.getKingdom();
        Kingdom victimKingdom = victimKp.getKingdom();
        PvPType pvpType = (damagerKingdom == null || victimKingdom == null ? KingdomRelation.NEUTRAL : damagerKingdom.getRelationWith(victimKingdom)).getPvPType();
        if (pvpType == PvPType.DISABLED) {
            return true;
        }
        if (pvpType == PvPType.DISALLOWED) {
            return false;
        }
        if ((damagerKingdom != null && damagerKingdom.isPacifist() || victimKingdom != null && victimKingdom.isPacifist()) && KingdomsConfig.Invasions.PACIFISM_DISABLE_PVP.getManager().getBoolean()) {
            return false;
        }
        if ((damagerKingdom != null && damagerKingdom.hasShield() || victimKingdom != null && victimKingdom.hasShield()) && KingdomsConfig.Invasions.SHIELDS_DISABLE_PVP.getManager().getBoolean()) {
            return false;
        }
        if (damagerKingdom != null && victimKingdom != null && StandardRelationAttribute.CEASEFIRE.hasAttribute(victimKingdom, damagerKingdom)) {
            return false;
        }
        if (damagerKp.isInvading() || victimKp.isInvading()) {
            return true;
        }
        if (normal || pvpType == PvPType.MASSWAR && Masswar.isRunning()) {
            return true;
        }
        SimpleChunkLocation damagerChunk = SimpleChunkLocation.of(damager.getLocation());
        SimpleChunkLocation victimChunk = SimpleChunkLocation.of(victim.getLocation());
        Land damagerLand = damagerChunk.getLand();
        boolean bl = unclaimed = damagerLand == null || !damagerLand.isClaimed();
        if (pvpType == PvPType.TERRITORY) {
            if (damagerKingdom == null && victimKingdom == null) {
                return true;
            }
            if (!unclaimed && StandardRelationAttribute.CEASEFIRE.hasAttribute(damagerKingdom, damagerLand.getKingdom())) {
                return false;
            }
            Land victimLand2 = victimChunk.getLand();
            return victimLand2 == null || !victimLand2.isClaimed() || !StandardRelationAttribute.CEASEFIRE.hasAttribute(victimKingdom, victimLand2.getKingdom());
        }
        if (!damagerChunk.equalsIgnoreWorld(victimChunk) && unclaimed != ((victimLand = victimChunk.getLand()) == null || !victimLand.isClaimed())) {
            return false;
        }
        return pvpType == (unclaimed ? PvPType.UNCLAIMED : PvPType.CLAIMED);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onFriendlyFire(EntityDamageByEntityEvent event) {
        UUID owner;
        Player victim;
        Player damager = PvPManager.getDamager(event.getDamager());
        if (damager == null) {
            return;
        }
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)damager)) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            victim = (Player)entity;
        } else if (entity instanceof LivingEntity && (owner = ServiceHandler.getPetOwner(entity)) != null) {
            victim = Bukkit.getPlayer((UUID)owner);
        } else {
            if (LandProtectionManager.onEntityBreak(event, damager)) {
                return;
            }
            return;
        }
        if (!PvPManager.canFight(damager, victim)) {
            event.setCancelled(true);
        }
    }

    static {
        String pvp = KingdomsConfig.Relations.PVP.getManager().getString().toUpperCase(Locale.ENGLISH);
        PVP_TYPE = (PvPType)((Object)Enums.getIfPresent(PvPType.class, (String)pvp).or((Object)PvPType.NORMAL));
    }

    public static final class v1_13
    implements Listener {
        @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
        public void onLightning(LightningStrikeEvent event) {
            if (event.getCause() != LightningStrikeEvent.Cause.TRIDENT) {
                return;
            }
            for (Entity entity : event.getLightning().getNearbyEntities(2.0, 2.0, 2.0)) {
                Trident trident;
                if (!(entity instanceof Trident) || !((trident = (Trident)entity).getShooter() instanceof Player)) continue;
                event.getLightning().setMetadata(PvPManager.TRIDENT_LIGHTNING_SHOOTER, (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.get(), (Object)trident.getShooter()));
                break;
            }
        }
    }

    public static enum PvPType {
        DISABLED,
        DISALLOWED,
        NORMAL,
        CLAIMED,
        UNCLAIMED,
        MASSWAR,
        TERRITORY,
        RELATIONAL;

    }
}

