/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.kingdoms.libs.xseries.ReflectionUtils;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;

public final class ReloadProtection
implements Listener {
    private static final Set<String> KNOWN_RELOAD_COMMANDS = new HashSet<String>(40);

    public static void ensureLoadOnce() {
        URI uri = null;
        try {
            uri = Kingdoms.class.getResource("/config.yml").toURI();
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
        }
        try {
            FileSystems.getFileSystem(uri);
            ReloadProtection.warn();
            return;
        }
        catch (FileSystemNotFoundException ex) {
            Class<?> CraftServerClass = ReflectionUtils.getCraftClass("CraftServer");
            if (CraftServerClass != null) {
                int reloadCount = 0;
                try {
                    reloadCount = (Integer)CraftServerClass.getDeclaredField("reloadCount").get(Bukkit.getServer());
                }
                catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    // empty catch block
                }
                if (reloadCount > 0) {
                    ReloadProtection.warn();
                }
            }
            return;
        }
    }

    private static void warn() {
        KLogger.error("You've reloaded the plugin using an external service. In order to enable the plugin again, you need to restart your server. During this period all kingdoms will remain unprotected.");
        new Timer(true).scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                KLogger.error("The plugin is disabled and all your kingdoms are unprotected. Restart the server to fix this issue.");
            }
        }, 0L, 5000L);
        throw new IllegalStateException("Cannot enable the plugin again.");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onReloadPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (ReloadProtection.handleReloadCommand((CommandSender)event.getPlayer(), event.getMessage().substring(1))) {
            event.setCancelled(true);
        }
    }

    static boolean handleReloadCommand(CommandSender sender, String cmd) {
        if (!(cmd = cmd.toLowerCase()).startsWith("reload") && !KNOWN_RELOAD_COMMANDS.contains(cmd)) {
            return false;
        }
        MessageCompiler.compile("\n&8-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-\n\n &4&lDo not reload plugins with&e /reload &4&lor external plugins.&r\n &4&lUse their respective commands instead. E.g. &2 &l/k reload&4 &linstead.&r\n &2If you want to reload Kingdoms, you won't even need to reload in most cases since the plugin\n automatically reloads most configs.\n This action has been blocked by KingdomsX plugin.\n\n&8-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-\n").getExtraProvider().withSound(XSound.parse("BLOCK_NOTE_BLOCK_PLING")).send(sender, new MessageBuilder());
        return true;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onReloadCommand(ServerCommandEvent event) {
        if (ReloadProtection.handleReloadCommand(event.getSender(), event.getCommand())) {
            event.setCancelled(true);
        }
    }

    static {
        for (String mainCmd : Arrays.asList("plugman", "plugmanx")) {
            for (String subCmd : Arrays.asList("reload", "enable", "unload", "load", "disable")) {
                for (String name : Arrays.asList("kingdom", "kingdoms", "kingdomx", "kingdomsx")) {
                    KNOWN_RELOAD_COMMANDS.add(mainCmd + ' ' + subCmd + ' ' + name);
                }
            }
        }
    }
}

