/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.chat;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.chat.KingdomsChatProcessor;
import org.kingdoms.utils.string.StringUtils;

public final class KingdomChatChannelListener
implements Listener {
    private static final MethodHandle FORMAT;
    private static final EventExecutor CHAT_EXECUTOR;

    public KingdomChatChannelListener(Kingdoms plugin) {
        String priorityName = KingdomsConfig.Chat.PRIORITY.getManager().getString();
        Optional priority = Enums.getIfPresent(EventPriority.class, (String)priorityName.toUpperCase(Locale.ENGLISH));
        if (!priority.isPresent()) {
            throw new IllegalArgumentException("Unknown chat priority: " + priorityName);
        }
        Bukkit.getPluginManager().registerEvent(AsyncPlayerChatEvent.class, (Listener)this, (EventPriority)priority.get(), CHAT_EXECUTOR, (Plugin)plugin, true);
    }

    protected static void setFormatReflect(AsyncPlayerChatEvent event, String format) {
        try {
            FORMAT.invoke(event, format);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected static String escapeStringFormatter(String string) {
        return StringUtils.replace(string, "%", "%%");
    }

    protected static void setFormat(AsyncPlayerChatEvent event, String format) {
        event.setFormat(format);
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle format = null;
        try {
            Field formatField = AsyncPlayerChatEvent.class.getDeclaredField("format");
            formatField.setAccessible(true);
            format = lookup.unreflectSetter(formatField);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        FORMAT = format;
        CHAT_EXECUTOR = new EventExecutor(){

            public void execute(@NonNull Listener listener, @NonNull Event event) {
                AsyncPlayerChatEvent asyncPlayerChatEvent = (AsyncPlayerChatEvent)event;
                if (asyncPlayerChatEvent.isCancelled()) {
                    return;
                }
                new KingdomsChatProcessor(asyncPlayerChatEvent).process();
            }
        };
    }
}

