/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.chunkrestoration;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.libs.xseries.XBlock;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.managers.chunkrestoration.ChunkLocationIterator;
import org.kingdoms.utils.versionsupport.VersionSupport;

final class ChunkSnapshot {
    public static final byte LATEST_VERSION = 1;
    private final SimpleChunkLocation location;
    private final byte version;
    private final Map<SimpleLocation.WorldlessWrapper, BlockData> blocks;
    private ChunkLocationIterator restorer;
    private static final Collection<String> IGNORED_BLOCKS = KingdomsConfig.Claims.RESTORATION_IGNORED_BLOCKS.getManager().getStringList();

    public static ChunkSnapshot generateFor(SimpleChunkLocation location) {
        return new ChunkSnapshot(location, 1, ChunkSnapshot.parseBlocksOf(location));
    }

    public ChunkSnapshot(SimpleChunkLocation location, byte version, Map<SimpleLocation.WorldlessWrapper, BlockData> blocks) {
        this.location = location;
        this.version = version;
        this.blocks = blocks;
    }

    private static Map<SimpleLocation.WorldlessWrapper, BlockData> parseBlocksOf(SimpleChunkLocation location) {
        HashMap<SimpleLocation.WorldlessWrapper, BlockData> blocks = new HashMap<SimpleLocation.WorldlessWrapper, BlockData>(1000);
        World world = location.getBukkitWorld();
        int minHeight = VersionSupport.getMinWorldHeight(world);
        int maxHeight = world.getMaxHeight();
        ChunkLocationIterator iterator = new ChunkLocationIterator(minHeight, maxHeight);
        while (iterator.hasNext()) {
            SimpleLocation.WorldlessWrapper loc = iterator.next();
            Block block = location.getSimpleLocation(loc.getX(), loc.getY(), loc.getZ()).getBlock();
            if (XBlock.isAir(block.getType())) continue;
            blocks.put(loc, block.getBlockData());
        }
        return blocks;
    }

    public boolean restoreNextBlock() {
        boolean noMore;
        World world = this.location.getBukkitWorld();
        if (!world.isChunkLoaded(this.location.getX(), this.location.getZ())) {
            return true;
        }
        if (this.restorer == null) {
            this.restorer = new ChunkLocationIterator(VersionSupport.getMinWorldHeight(world), world.getMaxHeight());
        }
        SimpleLocation.WorldlessWrapper blockLocation = this.restorer.next();
        Block block = this.location.getSimpleLocation(blockLocation.getX(), blockLocation.getY(), blockLocation.getZ()).getBlock();
        BlockData blockData = this.blocks.get(blockLocation);
        if (blockData == null) {
            block.setType(Material.AIR, false);
        } else {
            Material bukkitMaterial = blockData.getMaterial();
            if (!XMaterial.matchXMaterial(bukkitMaterial).isOneOf(IGNORED_BLOCKS)) {
                block.setType(bukkitMaterial, false);
                block.setBlockData(blockData);
            } else {
                block.setType(Material.AIR, false);
            }
        }
        boolean bl = noMore = !this.restorer.hasNext();
        if (noMore) {
            this.restorer = null;
        }
        return noMore;
    }

    public byte getVersion() {
        return this.version;
    }

    public Map<SimpleLocation.WorldlessWrapper, BlockData> getBlocks() {
        return this.blocks;
    }

    public SimpleChunkLocation getLocation() {
        return this.location;
    }

    public String toString() {
        return "ChunkSnapshot{location=" + this.location + ", version=" + this.version + ", blocks=" + this.blocks.size() + '}';
    }
}

