/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.daily;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.events.general.GroupDisband;
import org.kingdoms.events.general.KingdomKingChangeEvent;
import org.kingdoms.events.members.LeaveReason;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.ConditionProcessor;
import org.kingdoms.utils.compilers.ConditionalCompiler;

public final class InactivityManager {
    protected static boolean disband(Kingdom kingdom) {
        ConditionalCompiler.LogicalOperand kingdomExcludeCond = KingdomsConfig.INACTIVITY_KINGDOM_EXCLUDE_CONDITION.getManager().getCondition();
        boolean result = (Boolean)kingdomExcludeCond.eval(new ConditionProcessor(new PlaceholderContextBuilder().withContext(kingdom)));
        if (!result) {
            return false;
        }
        AtomicBoolean disbanded = new AtomicBoolean(false);
        Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> {
            disbanded.set(!kingdom.disband(GroupDisband.Reason.INACTIVITY).isCancelled());
            if (disbanded.get() && KingdomsConfig.INACTIVITY_KINGDOM_ANNOUNCE.getBoolean()) {
                KingdomsLang.INACTIVITY_ANNOUNCE_KINGDOM.sendEveryoneMessage("kingdom", kingdom.getName());
            }
        });
        return disbanded.get();
    }

    protected static void handleInactiveMember(Kingdom kingdom, OfflinePlayer member) {
        KingdomPlayer kp;
        ConditionalCompiler.LogicalOperand kingdomExcludeCond = KingdomsConfig.INACTIVITY_MEMBER_EXCLUDE_CONDITION.getManager().getCondition();
        boolean result = (Boolean)kingdomExcludeCond.eval(new ConditionProcessor(new PlaceholderContextBuilder().withContext(member)));
        if (!result) {
            return;
        }
        if (member.getUniqueId().equals(kingdom.getKingId())) {
            if (KingdomsConfig.INACTIVITY_MEMBER_DISBAND_KINGDOM_IF_KING.getBoolean()) {
                InactivityManager.disband(kingdom);
            } else if (kingdom.getMembers().size() > 1) {
                KingdomPlayer highestAfterKing = Rank.determineNextKing((ArrayList)kingdom.getKingdomPlayers(), null);
                if (kingdom.setKing(highestAfterKing, KingdomKingChangeEvent.Reason.INACTIVITY).isCancelled()) {
                    return;
                }
            } else {
                InactivityManager.disband(kingdom);
            }
        }
        if (!(kp = KingdomPlayer.getKingdomPlayer(member)).hasKingdom()) {
            MessageHandler.sendConsolePluginMessage("&4Unknown kingdom for player &e" + member.getName() + " &4while kicking them due to inactivity &e" + kingdom.getName() + " &4kingdom. Removing them...");
            kingdom.getMembers().remove(member.getUniqueId());
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> kp.leaveKingdom(LeaveReason.INACTIVITY));
        if (KingdomsConfig.INACTIVITY_MEMBER_ANNOUNCE.getBoolean()) {
            KingdomsLang.INACTIVITY_ANNOUNCE_PLAYER.sendEveryoneMessage("player", member.getName());
        }
    }
}

