/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.daily;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.data.Pair;
import org.kingdoms.events.general.GroupDisband;
import org.kingdoms.events.general.GroupServerTaxPayEvent;
import org.kingdoms.events.members.LeaveReason;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.logger.KingdomsLogger;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.string.StringUtils;

public final class TaxManager {
    public static boolean needsToPayTaxes(Kingdom kingdom) {
        if (kingdom.isPermanent()) {
            return false;
        }
        Long kingdomsTaxAge = KingdomsConfig.TAX_KINGDOMS_AGE.getTimeMillis(TimeUnit.DAYS);
        if (kingdomsTaxAge == null) {
            return true;
        }
        return System.currentTimeMillis() - kingdom.getSince() > kingdomsTaxAge;
    }

    public static void handleNationTaxes(Collection<Nation> nations) {
        if (!KingdomsConfig.TAX_NATIONS_ENABLED.getBoolean()) {
            return;
        }
        Long nationAge = KingdomsConfig.TAX_NATIONS_AGE.getTimeMillis(TimeUnit.DAYS);
        long now = System.currentTimeMillis();
        boolean useRpNation = KingdomsConfig.TAX_NATIONS_USE_RESOURCE_POINTS.getBoolean();
        for (Nation nation : nations) {
            if (nationAge != null && now - nation.getSince() < nationAge) {
                for (Player member : nation.getOnlineMembers()) {
                    KingdomsLang.TAX_NATION_AGE.sendMessage((CommandSender)member);
                }
                continue;
            }
            double tax = MathUtils.eval(KingdomsConfig.TAX_NATIONS_SCALING.getString(), nation, new Object[0]);
            String fancyTaxNumber = StringUtils.toFancyNumber(tax);
            GroupServerTaxPayEvent event = new GroupServerTaxPayEvent(nation, tax);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            tax = event.getAmount();
            if (nation.hasMoney(tax)) {
                if (tax == 0.0) continue;
                if (useRpNation) {
                    nation.addResourcePoints((long)(-tax));
                } else {
                    nation.addBank(-tax);
                }
                for (Player player : nation.getOnlineMembers()) {
                    KingdomsLang.TAX_NATION_PAID.sendMessage((CommandSender)player, "tax", fancyTaxNumber);
                }
                continue;
            }
            if (!KingdomsConfig.TAX_NATIONS_DISBAND_IF_CANT_PAY.getBoolean()) continue;
            KingdomsLogger.getMain().log(nation.getName() + " nation was disbanded due to not being able to pay taxes: " + StringUtils.toFancyNumber(useRpNation ? (double)nation.getResourcePoints() : nation.getBank()) + " < " + fancyTaxNumber);
            Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> {
                if (!nation.disband(GroupDisband.Reason.TAXES).isCancelled()) {
                    for (Player player : nation.getOnlineMembers()) {
                        KingdomsLang.TAX_NATION_DISBANDED.sendError((CommandSender)player, "tax", fancyTaxNumber);
                    }
                    KingdomsLang.TAX_NATION_DISBANDED_ANNOUNCE.sendConsoleMessage("nation", nation.getName(), "tax", fancyTaxNumber);
                }
            });
        }
    }

    public static void kingdomPayNationTax(Nation nation, Kingdom kingdom) {
        Pair<Boolean, Double> success = nation.payTaxes(kingdom);
        double paid = success.getValue();
        String fancyTaxNumber = StringUtils.toFancyNumber(paid);
        boolean useRpNationMember = KingdomsConfig.TAX_NATIONS_MEMBERS_USE_RESOURCE_POINTS.getBoolean();
        MessageBuilder settings = new MessageBuilder().withContext(kingdom).raw("tax", fancyTaxNumber);
        if (success.getKey().booleanValue()) {
            if (paid != 0.0) {
                for (Player player : kingdom.getOnlineMembers()) {
                    KingdomsLang.TAX_KINGDOM_PAID_NATION.sendMessage((CommandSender)player, settings);
                }
            }
        } else if (KingdomsConfig.TAX_NATIONS_MEMBERS_KICK_IF_CANT_PAY.getBoolean() && !nation.getCapitalId().equals(kingdom.getId())) {
            KingdomsLogger.getMain().log(kingdom.getName() + " kingdom was kicked out of " + nation.getName() + " nation due to not being able to pay taxes: " + StringUtils.toFancyNumber(useRpNationMember ? (double)kingdom.getResourcePoints() : kingdom.getBank()) + " < " + fancyTaxNumber);
            for (Player player : nation.getOnlineMembers()) {
                KingdomsLang.TAX_KINGDOM_KICKED.sendMessage((CommandSender)player, settings);
            }
            KingdomsLang.TAX_KINGDOM_KICKED_ANNOUNCE.sendMessage((CommandSender)Bukkit.getConsoleSender(), settings);
            Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> kingdom.leaveNation(LeaveReason.TAX));
        }
    }
}

