/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.invasions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.config.ConfigAccessor;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.upgradable.champion.ChampionAbility;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.NamespacedMetadataContainer;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.events.general.GroupDisband;
import org.kingdoms.events.invasion.KingdomInvadeEndEvent;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.events.lands.UnclaimLandEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.XParticle;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.entity.KingdomEntityRegistry;
import org.kingdoms.managers.entity.types.KingdomChampionEntity;
import org.kingdoms.managers.entity.types.KingdomEntity;
import org.kingdoms.managers.invasions.InvasionFactory;
import org.kingdoms.managers.land.claiming.UnclaimProcessor;
import org.kingdoms.managers.land.protection.MiscUpgradeManager;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.TracedObject;
import org.kingdoms.utils.Validate;
import org.kingdoms.utils.bossbars.BossBarSession;
import org.kingdoms.utils.cooldown.BiCooldown;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.internal.nonnull.NonNullMap;
import org.kingdoms.utils.string.StringUtils;
import org.kingdoms.utils.time.TimeFormatter;

public class Invasion
implements NamespacedMetadataContainer {
    public static final String METADATA = "INVASION";
    private static final Cooldown<UUID> CAPITAL_PROTECTION = new Cooldown();
    private static final BiCooldown<UUID, UUID> SUCCESSFUL = new BiCooldown();
    private static final BiCooldown<UUID, UUID> FAILED = new BiCooldown();
    protected final boolean ransackMode;
    protected final Set<SimpleChunkLocation> affectedLands;
    protected final Land originLand;
    protected final Kingdom defender;
    protected final Kingdom attacker;
    protected Location startLocation;
    protected Creature champion;
    protected final long start;
    protected BossBarSession attackerProgress;
    protected BossBarSession defenderProgress;
    protected BossBarSession timeLimitProgress;
    protected final KingdomPlayer invader;
    protected final Player invaderPlayer;
    protected boolean showBossBarToAllPlayers;
    protected boolean reverseProgress;
    protected long duration;
    protected BukkitTask task;
    protected double attackerScore;
    protected double defenderScore;
    protected TracedObject<Result> result;
    protected BukkitTask preparationTask;
    private final Map<Namespace, Object> metadata = new NonNullMap<Namespace, Object>();
    protected int invaderDeathLimit;
    protected int defenderDeathLimit;

    public Invasion(KingdomPlayer invader, Land originLand, Set<SimpleChunkLocation> affectedLands, Location startLocation, boolean ransackMode) {
        this.invader = Objects.requireNonNull(invader);
        this.attacker = invader.getKingdom();
        this.invaderPlayer = invader.getPlayer();
        this.originLand = Objects.requireNonNull(originLand);
        this.defender = originLand.getKingdom();
        this.affectedLands = Collections.unmodifiableSet(Objects.requireNonNull(affectedLands));
        this.startLocation = startLocation;
        this.start = System.currentTimeMillis();
        this.duration = this.getDefaultDuration();
        this.ransackMode = ransackMode;
        Validate.isTrue(affectedLands.contains(originLand.getLocation()), "The origin land is not affected by this invasion");
        this.invaderDeathLimit = (int)MathUtils.eval(KingdomsConfig.Invasions.PLAYER_DEATHS_DEFENDER.getManager().getString(), this.defender, new Object[0]);
        this.defenderDeathLimit = (int)MathUtils.eval(KingdomsConfig.Invasions.PLAYER_DEATHS_ATTACKER.getManager().getString(), this.attacker, new Object[0]);
    }

    public void finalizePreparation() {
        this.preparationTask = null;
        if (!KingdomsConfig.Invasions.INITIAL_LOCATION.getManager().getBoolean()) {
            this.startLocation = this.invaderPlayer.getLocation();
        }
        Invasion.performCommands(this.invaderPlayer);
    }

    public void setPreparationTask(BukkitTask preparationTask) {
        if (this.preparationTask != null) {
            throw new IllegalStateException("Preparation task was already set");
        }
        this.preparationTask = preparationTask;
    }

    public void spawnChampion(Location spawnLocation) {
        if (KingdomsConfig.Invasions.NATIONS_USE_CAPITAL_CHAMPION.getManager().getBoolean()) {
            Nation nation = this.defender.getNation();
            if (nation != null) {
                Kingdom capital = nation.getCapital();
                this.champion = capital.spawnChampion(spawnLocation);
            } else {
                this.champion = this.defender.spawnChampion(spawnLocation);
            }
        } else {
            this.champion = this.defender.spawnChampion(spawnLocation);
        }
        this.champion.setMetadata(METADATA, (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.get(), (Object)this));
        KingdomEntityRegistry.addMob(new KingdomChampionEntity((Entity)this.champion, this, (LivingEntity)this.invaderPlayer));
        XParticle.meguminExplosion((Plugin)Kingdoms.get(), 3.0, ParticleDisplay.simple(spawnLocation.clone().add(0.0, 0.3, 0.0), Particle.FLAME));
    }

    public void setupBossBars() {
        ConfigAccessor progressSection = KingdomsConfig.INVASIONS.accessor().gotoSection("bossbar");
        this.attackerProgress = BossBarSession.from(progressSection.getSection());
        this.reverseProgress = progressSection.getBoolean("reverse-progress");
        ConfigAccessor timeBossbarSection = KingdomsConfig.INVASIONS.accessor().gotoSection("time-limit", "bossbar");
        this.timeLimitProgress = this.duration != 0L ? BossBarSession.from(timeBossbarSection.getSection()) : null;
    }

    public boolean isRansackMode() {
        return this.ransackMode;
    }

    public void start() {
        this.finalizePreparation();
        this.setupBossBars();
        this.useStandardTask();
    }

    public static void forAllRelatedRangedBossBarInvasions(Kingdom kingdom, Consumer<Invasion> action) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> {
            kingdom.getInvasions().values().stream().filter(invasion -> invasion.showBossBarToAllPlayers).forEach(action);
            kingdom.getLandsUnderAttack().stream().map(x -> x.getInvasions().values()).flatMap(Collection::stream).filter(invasion -> invasion.showBossBarToAllPlayers).forEach(action);
        });
    }

    protected static void performCommands(Player player) {
        StringUtils.performCommands((OfflinePlayer)player, KingdomsConfig.Invasions.COMMANDS_EXECUTE_BEFORE.getManager().getStringList());
    }

    public static Cooldown<UUID> getCapitalProtection() {
        return CAPITAL_PROTECTION;
    }

    public static Pair<Long, Boolean> getCooldown(Kingdom attacker, Kingdom defender) {
        long successful = SUCCESSFUL.getTimeLeft(attacker.getId(), defender.getId());
        long failed = FAILED.getTimeLeft(attacker.getId(), defender.getId());
        if (successful == 0L && failed == 0L) {
            return null;
        }
        return Pair.of(successful == 0L ? failed : successful, failed == 0L);
    }

    public static @Nullable Invasion getInvasion(@NonNull LivingEntity entity) {
        Objects.requireNonNull(entity, "Cannot get land invasion session from null entity");
        if (!entity.hasMetadata(METADATA)) {
            return null;
        }
        if (entity instanceof Player) {
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)((Player)entity));
            Invasion invasion = kp.getInvasion();
            if (!kp.isInvading() || invasion == null) {
                throw new IllegalStateException("Attempted to get invasion session of a land that is not under attack from player: '" + entity.getName() + '\'');
            }
            return invasion;
        }
        return Invasion.getInvasionFromChampion(entity);
    }

    public static Invasion getInvasionFromChampion(@NonNull LivingEntity entity) {
        KingdomEntity championEntity = KingdomEntityRegistry.getKingdomEntity((Entity)entity);
        if (championEntity == null) {
            throw new IllegalStateException("Attempted to get invasion session of a land that is not under attack from champion: '" + entity.getName() + '\'');
        }
        if (!(championEntity instanceof KingdomChampionEntity)) {
            throw new AssertionError((Object)("Attempted to get invasion session of a land from an entity that is not KingdomChampionEntity: '" + entity.getName() + "' - " + championEntity));
        }
        return ((KingdomChampionEntity)championEntity).getInvasion();
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void updateTimeLimitBossBar(long timePassed, Kingdom kingdom, Supplier<Double> progressSupplier, Object[] edits) {
        Double prog;
        if (this.timeLimitProgress == null) {
            return;
        }
        double percent = -1.0;
        if (progressSupplier != null && (prog = progressSupplier.get()) != null) {
            percent = prog;
        }
        if (percent == -1.0) {
            percent = this.reverseProgress ? (double)(1.0f - (float)timePassed / (float)this.duration) : (double)((float)timePassed / (float)this.duration);
        }
        this.timeLimitProgress.setProgress(percent);
        this.timeLimitProgress.updateTitle(new MessageBuilder().withContext(kingdom).raws(edits));
    }

    public MessageBuilder getInvasionEdits() {
        MessageBuilder builder = new MessageBuilder().withContext(this.invaderPlayer).other(this.defender).parse("invasion_champion", this.champion == null ? null : this.champion.getCustomName()).raw("invasion_total_lands", this.affectedLands).raw("attacker_score", this.attackerScore).raw("defender_score", this.defenderScore).raw("attacker_death_limit", this.invaderDeathLimit).raw("invasion_result", (Object)this.getResult()).raw("defender_death_limit", this.defenderDeathLimit).raw("invasion_start", TimeFormatter.of(this.start)).raw("invasion_duration", TimeFormatter.of(this.duration)).raw("invasion_time_passed", TimeFormatter.of(this.getTimePassed()));
        builder.raw("start_location", KingdomsLang.LOCATIONS_NORMAL.parse(LocationUtils.getLocationEdits(builder, SimpleLocation.of(this.startLocation), "")));
        if (this.champion != null) {
            builder.raw("champion_location", KingdomsLang.LOCATIONS_NORMAL.parse(LocationUtils.getLocationEdits(builder, SimpleLocation.of(this.champion.getLocation()), "")));
        }
        return builder;
    }

    public void updateProgress(BossBarSession bossBar, double progress, Object[] edits) {
        bossBar.updateTitle(new MessageBuilder().withContext(this.defender).raws(edits));
        bossBar.setProgress(progress);
    }

    public void addBossBarToAllMembers() {
        @NonNull List<Player> players = this.defender.getOnlineMembers();
        players.addAll(this.attacker.getOnlineMembers());
        for (Player player : players) {
            this.addPlayerToBossBar(player);
        }
    }

    void addPlayerToBossBar(Player player) {
        if (this.defenderProgress != null) {
            if (this.defender.isMember((OfflinePlayer)player)) {
                this.defenderProgress.addPlayer(player);
            } else if (this.attackerProgress != null) {
                this.attackerProgress.addPlayer(player);
            }
        } else if (this.attackerProgress != null) {
            this.attackerProgress.addPlayer(player);
        }
        if (this.timeLimitProgress != null) {
            this.timeLimitProgress.addPlayer(player);
        }
    }

    static void discardPlayers(BossBarSession bossBar, Set<Player> keptPlayers) {
        if (bossBar != null) {
            bossBar.getPlayers().stream().filter(x -> !keptPlayers.contains(x)).forEach(bossBar::removePlayer);
        }
    }

    public void updateRangedBossBar(double range, Location location) {
        Collection nearBy = location == null ? this.champion.getNearbyEntities(range, range, range) : location.getWorld().getNearbyEntities(location, range, range, range);
        HashSet<Player> keep = new HashSet<Player>(nearBy.size());
        for (Entity entity : nearBy) {
            if (!(entity instanceof Player)) continue;
            keep.add((Player)entity);
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> {
            Invasion.discardPlayers(this.attackerProgress, keep);
            Invasion.discardPlayers(this.defenderProgress, keep);
            Invasion.discardPlayers(this.timeLimitProgress, keep);
            for (Player player : keep) {
                this.addPlayerToBossBar(player);
            }
        });
    }

    public void setTask(BukkitTask task) {
        this.task = task;
    }

    public boolean showBossBarToAllPlayers() {
        return this.showBossBarToAllPlayers;
    }

    public void removeBossBar(Player player) {
        if (this.attackerProgress != null) {
            this.attackerProgress.removePlayer(player);
        }
        if (this.timeLimitProgress != null) {
            this.timeLimitProgress.removePlayer(player);
        }
        if (this.defenderProgress != null) {
            this.defenderProgress.removePlayer(player);
        }
    }

    public void addBossBar(Player player, boolean attacker) {
        if (attacker) {
            if (this.attackerProgress != null) {
                this.attackerProgress.addPlayer(player);
            }
        } else if (this.defenderProgress != null) {
            this.defenderProgress.addPlayer(player);
        }
        if (this.timeLimitProgress != null) {
            this.timeLimitProgress.addPlayer(player);
        }
    }

    public BossBarSession getDefenderProgress() {
        return this.defenderProgress;
    }

    public void championAbilitiesTick() {
        for (ChampionAbility ability : ChampionAbility.getAbilities().values()) {
            if (!ability.canTriggerInstantly() || !ability.canUse(this.defender) || ability.isInCooldown(this)) continue;
            Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> ability.trigger(this));
        }
    }

    public BukkitTask useStandardTask() {
        ConfigAccessor progressSection = KingdomsConfig.INVASIONS.accessor().gotoSection("bossbar");
        String[] stringArray = new String[]{"range"};
        final double range = progressSection.getDouble(stringArray);
        if (range <= 0.0) {
            this.addBossBarToAllMembers();
            this.showBossBarToAllPlayers = true;
        }
        this.task = new BukkitRunnable(){
            int nearbyCheck = 100;

            public void run() {
                long timePassed = Invasion.this.getTimePassed();
                if (Invasion.this.duration != 0L && timePassed >= Invasion.this.duration) {
                    Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> Invasion.this.end(Result.TIMES_UP));
                    this.cancel();
                    return;
                }
                Invasion.this.championAbilitiesTick();
                if (Invasion.this.attackerProgress != null || Invasion.this.timeLimitProgress != null) {
                    double health = MathUtils.roundToDigits(Invasion.this.champion.getHealth(), 2);
                    double maxHealth = MathUtils.roundToDigits(Invasion.this.champion.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue(), 2);
                    Object[] edits = new Object[]{"time", TimeFormatter.of(Invasion.this.duration - timePassed), "health", health, "max_health", maxHealth};
                    if (Invasion.this.attackerProgress != null) {
                        double percent = (Invasion.this.reverseProgress ? health : maxHealth - health) / maxHealth;
                        Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> Invasion.this.updateProgress(Invasion.this.attackerProgress, percent, edits));
                    }
                    Invasion.this.updateTimeLimitBossBar(timePassed, Invasion.this.defender, null, edits);
                    if (range > 0.0 && this.nearbyCheck++ == 100) {
                        this.nearbyCheck = 0;
                        Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> Invasion.this.updateRangedBossBar(range, null));
                    }
                }
            }
        }.runTaskTimerAsynchronously((Plugin)Kingdoms.get(), 0L, 1L);
        return this.task;
    }

    public long getDefaultDuration() {
        KingdomsConfig.Invasions timeLimit = this.originLand.isNexusLand() ? KingdomsConfig.Invasions.TIME_LIMIT_NEXUS : KingdomsConfig.Invasions.TIME_LIMIT_DEFAULT;
        Long limitOpt = timeLimit.getManager().getTimeMillis(TimeUnit.MINUTES);
        return limitOpt == null ? 0L : limitOpt;
    }

    public BossBarSession getAttackerProgress() {
        return this.attackerProgress;
    }

    public BossBarSession getTimeLimitProgress() {
        return this.timeLimitProgress;
    }

    public Result getResult() {
        return this.result == null ? null : this.result.getObject();
    }

    public void end(Result result) {
        if (Bukkit.isPrimaryThread()) {
            this.end0(result);
        } else {
            Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> this.end0(result));
        }
    }

    protected void cleanup() {
        this.invaderPlayer.removeMetadata(METADATA, (Plugin)Kingdoms.get());
        this.invader.setInvasion(null);
        this.affectedLands.stream().map(SimpleChunkLocation::getLand).forEach(x -> x.removeInvasion(this.attacker));
        if (this.champion != null) {
            this.champion.removeMetadata(METADATA, (Plugin)Kingdoms.get());
            KingdomEntityRegistry.removeMob((LivingEntity)this.champion);
            this.champion.remove();
        }
        if (this.attackerProgress != null) {
            this.attackerProgress.removeAll();
        }
        if (this.defenderProgress != null) {
            this.defenderProgress.removeAll();
        }
        if (this.timeLimitProgress != null) {
            this.timeLimitProgress.removeAll();
        }
    }

    public boolean hasEnded() {
        return this.result != null;
    }

    private void end0(Result result) {
        Objects.requireNonNull(result, "Invasion result cannot be null");
        if (this.result != null) {
            throw this.result.getException();
        }
        this.result = new TracedObject<Result>(result, new IllegalStateException("This invasions has already ended"));
        KLogger logger = new KLogger(KingdomsDebug.INVASION_END);
        logger.log(() -> "Invasion ended result=" + (Object)((Object)result) + ", attacker=" + this.attacker.getName() + ", defender=" + this.defender.getName() + ", player=" + this.invaderPlayer.getName() + ", class=" + this.getClass().getName() + ", ransack=" + this.ransackMode + ", champion=" + this.champion + ", scores=" + this.attackerScore + '-' + this.defenderScore + ", deathlimits=" + this.invaderDeathLimit + '-' + this.defenderDeathLimit + ", task=" + this.task + ", preparationTask=" + this.preparationTask + ", affectedLands=" + this.affectedLands);
        if (this.task != null) {
            this.task.cancel();
        }
        KingdomInvadeEndEvent invadeEvent = new KingdomInvadeEndEvent(this);
        Bukkit.getPluginManager().callEvent((Event)invadeEvent);
        this.cleanup();
        if (result == Result.ATTACKER_SURRENDERED) {
            boolean refundRp = KingdomsConfig.Invasions.SURRENDER_REFUND_RESOURCE_POINTS.getManager().getBoolean();
            boolean refundMoney = KingdomsConfig.Invasions.SURRENDER_REFUND_MOENY.getManager().getBoolean();
            if (refundRp || refundMoney) {
                Pair<Long, Double> pair = InvasionFactory.getInvasionCosts(this.invaderPlayer, this.ransackMode);
                if (refundRp) {
                    this.attacker.addResourcePoints(pair.getKey());
                }
                if (refundMoney) {
                    this.attacker.addBank(pair.getValue());
                }
            }
        }
        Object[] invaderEdits = new Object[]{"kingdom", this.defender.getName(), "invader", this.invaderPlayer.getName()};
        for (Player player : this.attacker.getOnlineMembers()) {
            KingdomsLang.valueOf("INVASION_END_ATTACKERS_" + result.name()).sendMessage((CommandSender)player, invaderEdits);
        }
        Object[] defenderEdits = new Object[]{"kingdom", this.attacker.getName(), "invader", this.invaderPlayer.getName()};
        for (Player member : this.defender.getOnlineMembers()) {
            KingdomsLang.valueOf("INVASION_END_DEFENDERS_" + result.name()).sendMessage((CommandSender)member, defenderEdits);
        }
        if (this.preparationTask != null) {
            this.preparationTask.cancel();
            this.preparationTask = null;
            return;
        }
        MiscUpgradeManager.invaded(this.attacker);
        ServiceHandler.announce(result.isSuccessful() ? KingdomsConfig.Chat.DISCORDSRV_ANNOUNCEMENTS_INVASION_END_SUCCESS : KingdomsConfig.Chat.DISCORDSRV_ANNOUNCEMENTS_INVASION_END_FAIL, (com.google.common.base.Supplier<MessageBuilder>)((com.google.common.base.Supplier)() -> this.getInvasionEdits().ignoreColors()));
        long l = (result.isSuccessful() ? KingdomsConfig.Invasions.COOLDOWNS_SUCCESSFUL : KingdomsConfig.Invasions.COOLDOWNS_FAILED).getManager().getTimeMillis(TimeUnit.MINUTES);
        if (l > 0L) {
            (result.isSuccessful() ? SUCCESSFUL : FAILED).add(this.attacker.getId(), this.defender.getId(), l);
        }
        logger.log("Invasion Cooldown: " + l);
        StringUtils.performCommands((OfflinePlayer)this.invaderPlayer, (result.isSuccessful() ? KingdomsConfig.Invasions.COMMANDS_EXECUTE_AFTER_SUCCESSFUL : KingdomsConfig.Invasions.COMMANDS_EXECUTE_AFTER_FAIL).getManager().getStringList());
        if (!result.isSuccessful()) {
            return;
        }
        Optional<Structure> nexus = this.affectedLands.stream().map(x -> Land.getLand(x).getStructure(struct -> ((StructureType)((StructureStyle)struct.getStyle()).getType()).isNexus())).filter(Objects::nonNull).findFirst();
        nexus.ifPresent(structure -> logger.log("A nexus chunk which is at: " + structure.getLocation() + " - " + ((StructureStyle)structure.getStyle()).getName()));
        long rp = (long)MathUtils.eval((nexus.isPresent() ? KingdomsConfig.Invasions.ON_NEXUS_LOSS_RESOURCE_POINTS : KingdomsConfig.Invasions.BONUS_RESOURCE_POINTS).getManager().getString(), this.defender, "ransack", this.ransackMode);
        double bank = MathUtils.eval((nexus.isPresent() ? KingdomsConfig.Invasions.ON_NEXUS_LOSS_RESOURCE_POINTS : KingdomsConfig.Invasions.BONUS_BANK).getManager().getString(), this.defender, "ransack", this.ransackMode);
        if (!this.defender.hasResourcePoints(rp)) {
            rp = this.defender.getResourcePoints();
        }
        if (!this.defender.hasMoney(bank)) {
            bank = this.defender.getBank();
        }
        this.defender.addResourcePoints(-rp);
        this.defender.addBank(-bank);
        this.attacker.addResourcePoints(rp);
        this.attacker.addBank(bank);
        logger.log("Money bonus: " + bank + ", rp bonus: " + rp);
        boolean disbanded = false;
        if (!this.ransackMode && nexus.isPresent()) {
            CAPITAL_PROTECTION.add(this.defender.getId(), KingdomsConfig.Invasions.NATIONS_CAPITAL_PROTECTION_NEXUS_INVASION_COOLDOWN.getManager().getTimeMillis());
            final Location loc = nexus.get().getLocation().toBukkitLocation();
            final World world = loc.getWorld();
            for (int i = 0; i < 4; ++i) {
                world.strikeLightningEffect(loc);
            }
            if (KingdomsConfig.Invasions.ON_NEXUS_LOSS_DROP_NEXUS_CHEST_ITEMS.getManager().getBoolean()) {
                for (ItemStack item : this.defender.getNexusChest().getContents()) {
                    if (item == null) continue;
                    world.dropItemNaturally(loc, item);
                }
                this.defender.getNexusChest().clear();
            }
            new BukkitRunnable(){
                final int amount = KingdomsConfig.Invasions.ON_NEXUS_LOSS_LIGHTNING_AMOUNT.getManager().getInt();
                int times = KingdomsConfig.Invasions.ON_NEXUS_LOSS_LIGHTNING_TIMES.getManager().getInt();

                public void run() {
                    for (int i = 0; i < this.amount; ++i) {
                        world.strikeLightningEffect(loc);
                    }
                    if (--this.times <= 0) {
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)Kingdoms.get(), 0L, (long)KingdomsConfig.Invasions.ON_NEXUS_LOSS_LIGHTNING_INTERVAL.getManager().getInt());
            if (KingdomsConfig.Invasions.ON_NEXUS_LOSS_DISBAND.getManager().getBoolean()) {
                disbanded = true;
                this.defender.disband(GroupDisband.Reason.INVASION);
            }
        }
        if (disbanded) {
            logger.log("The defender is marked to be disbanded");
        }
        if (!this.ransackMode) {
            for (SimpleChunkLocation chunk : this.affectedLands) {
                Land land = Land.getLand(chunk);
                if (land.isHomeLand()) {
                    SimpleChunkLocation farthest;
                    if (KingdomsConfig.Invasions.HOME_REMOVE.getManager().getBoolean()) {
                        this.defender.setHome(null, null);
                    } else if (KingdomsConfig.Invasions.HOME_MOVE.getManager().getBoolean() && (farthest = land.getLocation().findFarthestChunk(this.defender.getLandLocations(), false)) != null) {
                        Location newHome = farthest.getCenterLocation();
                        this.defender.setHome(newHome, null);
                        this.defender.getOnlineMembers().forEach(x -> KingdomsLang.INVASION_HOME_MOVED.sendError((CommandSender)x, "new-home", LocationUtils.parseLocation(newHome)));
                    }
                }
                boolean unclaimed = true;
                if (!disbanded) {
                    boolean bl = unclaimed = !land.unclaim(this.invader, UnclaimLandEvent.Reason.INVASION).isCancelled();
                }
                if (unclaimed && !this.attacker.claim(land.getLocation(), this.invader, ClaimLandEvent.Reason.INVASION).isCancelled()) {
                    Long cd = KingdomsConfig.Invasions.UNCLAIM_COOLDOWN.getManager().getTimeMillis();
                    if (cd != null && cd > 0L) {
                        UnclaimProcessor.getUnclaimCooldown().add(land.getLocation(), cd);
                    }
                    logger.log(() -> "Claimed land for attacker: " + land.getLocation() + " with unclaim cd of " + TimeFormatter.of(cd));
                    continue;
                }
                logger.log("Unclaiming not successful for: " + land.getLocation());
            }
        }
        logger.end();
    }

    public KingdomPlayer getInvader() {
        return this.invader;
    }

    public Land getOriginLand() {
        return this.originLand;
    }

    public List<LivingEntity> getEntitiesInArea() {
        ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>(this.affectedLands.size() * 10);
        for (SimpleChunkLocation chunk : this.affectedLands) {
            for (Entity entity : chunk.toChunk().getEntities()) {
                if (!(entity instanceof LivingEntity)) continue;
                entities.add((LivingEntity)entity);
            }
        }
        return entities;
    }

    public boolean isAffected(SimpleChunkLocation chunk) {
        return this.affectedLands.contains(chunk);
    }

    public Kingdom getDefender() {
        return this.defender;
    }

    public @Nullable Creature getChampion() {
        return this.champion;
    }

    public long getStart() {
        return this.start;
    }

    public long getTimePassed() {
        return System.currentTimeMillis() - this.start;
    }

    public Location getStartLocation() {
        return this.startLocation;
    }

    public double getDefenderScore() {
        return this.defenderScore;
    }

    public Set<SimpleChunkLocation> getAffectedLands() {
        return this.affectedLands;
    }

    public void setDefenderScore(double defenderScore) {
        this.defenderScore = defenderScore;
    }

    public double getAttackerScore() {
        return this.attackerScore;
    }

    public void setAttackerScore(double attackerScore) {
        this.attackerScore = attackerScore;
    }

    public void addDefenderScore(double amount) {
        this.defenderScore += amount;
        int limit = this.invaderDeathLimit;
        if (limit > 0 && this.defenderScore >= (double)limit) {
            this.end(Result.ATTACKER_DEATH_LIMIT);
        }
    }

    public void addAttackerScore(double amount) {
        this.attackerScore += amount;
        int limit = this.defenderDeathLimit;
        if (limit > 0 && this.attackerScore >= (double)limit) {
            this.end(Result.DEFENDER_DEATH_LIMIT);
        }
    }

    public boolean isPreparing() {
        return this.preparationTask != null;
    }

    public Player getInvaderPlayer() {
        return this.invaderPlayer;
    }

    public Kingdom getAttacker() {
        return this.attacker;
    }

    public int getInvaderDeathLimit() {
        return this.invaderDeathLimit;
    }

    public void setInvaderDeathLimit(int invaderDeathLimit) {
        this.invaderDeathLimit = invaderDeathLimit;
    }

    public int getDefenderDeathLimit() {
        return this.defenderDeathLimit;
    }

    public void setDefenderDeathLimit(int defenderDeathLimit) {
        this.defenderDeathLimit = defenderDeathLimit;
    }

    @Override
    public Map<Namespace, Object> getMetadata() {
        return this.metadata;
    }

    public static enum Result {
        SUCCESS(true),
        ATTACKER_SURRENDERED,
        DEFENDER_SURRENDERED(true),
        LOGOUT,
        DIED,
        TIMES_UP,
        DEFENDER_DEATH_LIMIT(true),
        ATTACKER_DEATH_LIMIT,
        UNCLAIMED(true),
        ATTACKER_NO_LONGER_IN_KINGDOM;

        private final boolean successful;

        private Result(boolean successful) {
            this.successful = successful;
        }

        private Result() {
            this(false);
        }

        public boolean isSuccessful() {
            return this.successful;
        }
    }
}

