/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.invasions;

import java.awt.Color;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.boss.BarColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.entity.KingdomEntityRegistry;
import org.kingdoms.managers.entity.types.KingdomEntity;
import org.kingdoms.managers.entity.types.KingdomLandEntity;
import org.kingdoms.managers.invasions.Invasion;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.bossbars.BossBarSession;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.enumeration.QuickEnumMap;
import org.kingdoms.utils.string.StringUtils;
import org.kingdoms.utils.time.TimeFormatter;

public class Plunder
extends Invasion {
    private static final DecimalFormat PROGRESS_FORMAT = new DecimalFormat("#,##0.0", new DecimalFormatSymbols(Locale.ENGLISH));
    private final QuickEnumMap<State, OptionCache> cache = new QuickEnumMap((Enum[])State.values());
    protected double captureProgress;
    protected State state = State.CAPTURING;

    public Plunder(KingdomPlayer invader, Land originLand, Set<SimpleChunkLocation> affectedLands, Location startLocation, boolean ransackMode) {
        super(invader, originLand, affectedLands, startLocation, ransackMode);
        if (this.defenderDeathLimit <= 0 || this.invaderDeathLimit <= 0) {
            KLogger.error("Cannot start plunder invasion with the current player-death option: defender=" + this.defenderDeathLimit + ", attacker=" + this.invaderDeathLimit + " defaulting back to 10");
            this.invaderDeathLimit = 10;
            this.defenderDeathLimit = 10;
        }
    }

    @Override
    public void start() {
        this.finalizePreparation();
        this.setupBossBars();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), this::usePlunderTask);
    }

    public void usePlunderTask() {
        int captureProgressBossBar;
        String cpbar;
        ConfigSection progressSection = KingdomsConfig.INVASIONS.accessor().gotoSection("bossbar").getSection();
        final double range = progressSection.getDouble("range");
        if (this.getAttackerProgress() != null) {
            progressSection = KingdomsConfig.INVASIONS.accessor().gotoSection("plunder", "defender-bossbar").getSection();
            this.defenderProgress = BossBarSession.from(progressSection);
        }
        switch (cpbar = KingdomsConfig.Invasions.PLUNDER_CAPTURE_PROGRESS_BOSSBAR_USE.getManager().getString().toLowerCase(Locale.ENGLISH)) {
            case "none": {
                captureProgressBossBar = 0;
                break;
            }
            case "normal": {
                captureProgressBossBar = 1;
                break;
            }
            case "timer": {
                captureProgressBossBar = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown capture progress boss bar mode: " + cpbar);
            }
        }
        this.initializeCache();
        if (range <= 0.0) {
            this.addBossBarToAllMembers();
        }
        final ArrayList<Location> first = new ArrayList<Location>();
        final ArrayList<Location> second = new ArrayList<Location>();
        if (KingdomsConfig.Invasions.PLUNDER_PARTICLES_ENABLED.getManager().getBoolean()) {
            Plunder.populateParticleLocations(this.getOriginLand().getLocation(), first, second);
        }
        this.setTask(new BukkitRunnable(){
            final Kingdom defenderKingdom;
            final Kingdom attackerKingdom;
            final BossBarSession progress;
            final BossBarSession timeLimitProgress;
            final long duration;
            final double increment;
            final double captureProgressGoal;
            final Location landLocation;
            final String fancyGoal;
            final boolean considerMobs;
            int nearbyCheck;
            int particleTick;
            {
                this.defenderKingdom = Plunder.this.getDefender();
                this.attackerKingdom = Plunder.this.getAttacker();
                this.progress = Plunder.this.getAttackerProgress();
                this.timeLimitProgress = Plunder.this.getTimeLimitProgress();
                this.duration = Plunder.this.getDuration();
                this.increment = KingdomsConfig.Invasions.PLUNDER_CAPTURE_PROGRESS_INCREMENT.getManager().getDouble();
                this.captureProgressGoal = KingdomsConfig.Invasions.PLUNDER_CAPTURE_PROGRESS_GOAL.getManager().getDouble();
                this.landLocation = range > 0.0 ? Plunder.this.getOriginLand().getLocation().getCenterLocation() : null;
                this.fancyGoal = StringUtils.toFancyNumber(this.captureProgressGoal);
                this.considerMobs = KingdomsConfig.Invasions.PLUNDER_CAPTURE_PROGRESS_CONSIDER_KINGDOM_MOBS.getManager().getBoolean();
                this.nearbyCheck = 100;
            }

            public void run() {
                if (this.particleTick++ % 30 == 0) {
                    Plunder.this.spawnParticles(first, second);
                }
                if (Plunder.this.champion != null) {
                    Plunder.this.championAbilitiesTick();
                }
                long timePassed = Plunder.this.getTimePassed();
                if (this.duration != 0L && timePassed >= this.duration) {
                    Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> Plunder.this.end(Invasion.Result.TIMES_UP));
                    this.cancel();
                    return;
                }
                int totalAttackers = 0;
                int totalDefenders = 0;
                for (LivingEntity entity : Plunder.this.getEntitiesInArea()) {
                    KingdomEntity kingdomEntity;
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (this.defenderKingdom.isMember((OfflinePlayer)player)) {
                            ++totalDefenders;
                            continue;
                        }
                        if (!this.attackerKingdom.isMember((OfflinePlayer)player)) continue;
                        ++totalAttackers;
                        continue;
                    }
                    if (!this.considerMobs || !((kingdomEntity = KingdomEntityRegistry.getKingdomEntity((Entity)entity)) instanceof KingdomLandEntity) || !kingdomEntity.getKingdom().getId().equals(this.defenderKingdom.getId())) continue;
                    ++totalDefenders;
                }
                if (totalAttackers > totalDefenders) {
                    Plunder.this.captureProgress += this.increment;
                    Plunder.this.state = State.CAPTURING;
                } else {
                    Plunder.this.state = State.PROTECTED;
                }
                if (Plunder.this.captureProgress >= this.captureProgressGoal) {
                    Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> Plunder.this.end(Invasion.Result.SUCCESS));
                    this.cancel();
                    return;
                }
                BarColor stateColor = ((OptionCache)Plunder.this.cache.get((Object)Plunder.this.state)).color;
                if (captureProgressBossBar == 1) {
                    if (Plunder.this.getAttackerProgress() != null) {
                        Plunder.this.getAttackerProgress().setColor(stateColor);
                    }
                    if (Plunder.this.getDefenderProgress() != null) {
                        Plunder.this.getDefenderProgress().setColor(stateColor);
                    }
                } else if (captureProgressBossBar == 2 && this.timeLimitProgress != null) {
                    this.timeLimitProgress.setColor(stateColor);
                }
                if (this.progress != null || this.timeLimitProgress != null) {
                    Object[] edits = new Object[]{"time", TimeFormatter.of(this.duration - timePassed), "defender-score", (int)Plunder.this.getDefenderScore(), "attacker-score", (int)Plunder.this.getAttackerScore(), "defender-lives-left", (int)((double)Plunder.this.getDefenderDeathLimit() - Plunder.this.getAttackerScore()), "attacker-lives-left", (int)((double)Plunder.this.getInvaderDeathLimit() - Plunder.this.getDefenderScore()), "capture-progress", PROGRESS_FORMAT.format(Plunder.this.captureProgress), "capture-progress-goal", this.fancyGoal};
                    if (this.progress != null) {
                        double percent = captureProgressBossBar == 1 ? Plunder.this.getBossBarCaptureProgress(this.captureProgressGoal) : (Plunder.this.reverseProgress ? ((double)Plunder.this.defenderDeathLimit - Plunder.this.getAttackerScore()) / (double)Plunder.this.defenderDeathLimit : Plunder.this.getAttackerScore() / (double)Plunder.this.defenderDeathLimit);
                        Plunder.this.updateProgress(this.progress, percent, edits);
                    }
                    if (Plunder.this.getDefenderProgress() != null) {
                        double percent = captureProgressBossBar == 1 ? Plunder.this.getBossBarCaptureProgress(this.captureProgressGoal) : (Plunder.this.reverseProgress ? ((double)Plunder.this.invaderDeathLimit - Plunder.this.getDefenderScore()) / (double)Plunder.this.invaderDeathLimit : Plunder.this.getDefenderScore() / (double)Plunder.this.invaderDeathLimit);
                        Plunder.this.updateProgress(Plunder.this.getDefenderProgress(), percent, edits);
                    }
                    Plunder.this.updateTimeLimitBossBar(timePassed, this.defenderKingdom, () -> captureProgressBossBar == 2 ? Double.valueOf(Plunder.this.getBossBarCaptureProgress(this.captureProgressGoal)) : null, edits);
                    if (range > 0.0 && this.nearbyCheck++ == 100) {
                        this.nearbyCheck = 0;
                        Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> Plunder.this.updateRangedBossBar(range, this.landLocation));
                    }
                }
            }
        }.runTaskTimerAsynchronously((Plugin)Kingdoms.get(), 0L, 1L));
    }

    private static void populateParticleLocations(SimpleChunkLocation chunk, List<Location> particles, List<Location> barracksParticles) {
        Block block;
        int blocklocX;
        int z;
        Block block2;
        int blocklocZ;
        int blocklocX2;
        int x;
        World world = chunk.getBukkitWorld();
        int zRow = 0;
        int offsetX = chunk.getX() * 16;
        int offsetZ = chunk.getZ() * 16;
        for (x = 0; x < 16; ++x) {
            blocklocX2 = x + offsetX;
            blocklocZ = zRow + offsetZ;
            block2 = world.getHighestBlockAt(blocklocX2, blocklocZ);
            particles.add(new Location(world, (double)block2.getX(), (double)(block2.getY() + 1), (double)block2.getZ()));
        }
        zRow = 15;
        for (x = 0; x < 16; ++x) {
            blocklocX2 = x + offsetX;
            blocklocZ = zRow + offsetZ;
            block2 = world.getHighestBlockAt(blocklocX2, blocklocZ);
            particles.add(new Location(world, (double)block2.getX(), (double)(block2.getY() + 1), (double)block2.getZ()));
        }
        int xRow = 0;
        for (z = 0; z < 16; ++z) {
            blocklocX = xRow + offsetX;
            int blocklocZ2 = z + offsetZ;
            block = world.getHighestBlockAt(blocklocX, blocklocZ2);
            particles.add(new Location(world, (double)block.getX(), (double)(block.getY() + 1), (double)block.getZ()));
        }
        xRow = 15;
        for (z = 0; z < 16; ++z) {
            blocklocX = xRow + offsetX;
            int blocklocZ3 = z + offsetZ;
            block = world.getHighestBlockAt(blocklocX, blocklocZ3);
            particles.add(new Location(world, (double)block.getX(), (double)(block.getY() + 1), (double)block.getZ()));
        }
        for (int x2 = 2; x2 < 14; ++x2) {
            for (int z2 = 2; z2 < 14; ++z2) {
                if (MathUtils.hasChance(30.0)) continue;
                int blocklocX3 = x2 + offsetX;
                int blocklocZ4 = z2 + offsetZ;
                Block block3 = world.getHighestBlockAt(blocklocX3, blocklocZ4);
                barracksParticles.add(new Location(world, (double)block3.getX(), (double)block3.getY(), (double)block3.getZ()));
            }
        }
    }

    private void initializeCache() {
        YamlConfigAccessor barColorSection = KingdomsConfig.Invasions.PLUNDER_CAPTURE_PROGRESS_BOSSBAR_STATE_COLORS.getManager().getSection();
        YamlConfigAccessor particles = KingdomsConfig.Invasions.PLUNDER_PARTICLES_STATES.getManager().getSection();
        for (State state : State.values()) {
            String config = StringUtils.configOption(state);
            BarColor color = BarColor.valueOf((String)barColorSection.getString(config).toUpperCase(Locale.ENGLISH));
            ParticleDisplay particle = ParticleDisplay.fromConfig(particles.gotoSection(config).toBukkitConfigurationSection());
            this.cache.put(state, new OptionCache(particle, color));
        }
    }

    private double getBossBarCaptureProgress(double goal) {
        return this.reverseProgress ? (goal - this.captureProgress) / goal : this.captureProgress / goal;
    }

    public void spawnParticles(List<Location> particles, List<Location> barracksParticles) {
        ParticleDisplay particle = this.cache.get((Object)this.state).particle;
        for (Location loc : particles) {
            particle.spawn(loc);
        }
        for (Location loc : barracksParticles) {
            int constRand = Math.abs((loc.getBlockY() + loc.getBlockX() + loc.getBlockZ() * 65 / 8) % 4);
            World world = loc.getWorld();
            switch (constRand) {
                case 0: {
                    world.playEffect(loc, Effect.MOBSPAWNER_FLAMES, 1);
                }
                case 1: {
                    ParticleDisplay.simple(loc, Particle.SMOKE_LARGE).directional().offset(0.0, 0.1, 0.0).withExtra(0.5).spawn();
                    break;
                }
                case 2: {
                    ParticleDisplay.simple(loc, Particle.CAMPFIRE_COSY_SMOKE).directional().offset(0.0, 0.1, 0.0).withExtra(0.5).spawn();
                    break;
                }
                case 3: {
                    ParticleDisplay.colored(loc, Color.BLACK, 3.0f).withCount(2).spawn();
                }
            }
        }
    }

    public double getAttackerCaptureProgress() {
        return this.captureProgress;
    }

    public static enum State {
        CAPTURING,
        PROTECTED;

    }

    private static final class OptionCache {
        private final ParticleDisplay particle;
        private final BarColor color;

        private OptionCache(ParticleDisplay particle, BarColor color) {
            this.particle = particle;
            this.color = color;
        }
    }
}

