/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land;

import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.xseries.XPotion;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.PvPManager;
import org.kingdoms.utils.internal.enumeration.QuickEnumSet;
import org.kingdoms.utils.string.StringUtils;

public final class LandEffectsManager
implements Listener {
    @EventHandler(ignoreCancelled=true)
    public void onPotionEffectsThrow(PotionSplashEvent event) {
        ThrownPotion potion = event.getPotion();
        if (!(potion.getShooter() instanceof Player)) {
            return;
        }
        List<String> disallowed = KingdomsConfig.Claims.POTION_PROTECTED_EFFECTS.getManager().getStringList();
        QuickEnumSet disallowedSet = new QuickEnumSet((Enum[])XPotion.VALUES);
        for (String string : disallowed) {
            Optional<XPotion> xPotion = XPotion.matchXPotion(string);
            xPotion.ifPresent(disallowedSet::add);
        }
        boolean contains = false;
        for (PotionEffect effect : potion.getEffects()) {
            if (!disallowedSet.contains((Object)XPotion.matchXPotion(effect.getType()))) continue;
            contains = true;
            break;
        }
        if (!contains) {
            return;
        }
        Player player = (Player)potion.getShooter();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        for (LivingEntity entity : event.getAffectedEntities()) {
            if (player == entity || !(entity instanceof Player) || PvPManager.canFight(player, (Player)entity)) continue;
            event.setIntensity(entity, 0.0);
        }
    }

    static {
        EnumMap<KingdomRelation, List<XPotion.Effect>> effects = new EnumMap<KingdomRelation, List<XPotion.Effect>>(KingdomRelation.class);
        for (KingdomRelation relation : KingdomRelation.VALUES) {
            List<String> relEffects = KingdomsConfig.Relations.RELATIONS_EFFECTS.getManager().withOption("relation", StringUtils.configOption(relation)).getStringList();
            effects.put(relation, XPotion.parseEffects(relEffects));
        }
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Kingdoms.get(), () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                Land land;
                KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
                Kingdom kingdom = kp.getKingdom();
                if (kp.isAdmin() || (land = SimpleChunkLocation.of(player.getLocation()).getLand()) == null || !land.isClaimed()) continue;
                KingdomRelation relation = land.getKingdom().getRelationWith(kingdom);
                List relEffects = (List)effects.get((Object)relation);
                Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> {
                    for (XPotion.Effect effect : relEffects) {
                        effect.apply((LivingEntity)player);
                    }
                });
            }
        }, 10L, 200L);
    }

    public static final class BeaconManager
    implements Listener {
        @EventHandler(ignoreCancelled=true)
        public void onPotionEffectsThrow(EntityPotionEffectEvent event) {
            if (event.getCause() != EntityPotionEffectEvent.Cause.BEACON) {
                return;
            }
            if (!(event.getEntity() instanceof Player)) {
                return;
            }
            Player player = (Player)event.getEntity();
            Land land = Land.getLand(player.getLocation());
            if (land == null || !land.isClaimed()) {
                return;
            }
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            if (!land.getKingdom().hasAttribute(kp.getKingdom(), (RelationAttribute)StandardRelationAttribute.CEASEFIRE)) {
                event.setCancelled(true);
            }
        }
    }
}

