/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.claiming;

import java.util.List;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.xseries.XBiome;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextBuilder;
import org.kingdoms.managers.chunkrestoration.ChunkSnapshotManager;
import org.kingdoms.managers.land.claiming.AbstractClaimProcessor;
import org.kingdoms.managers.land.claiming.BiomeClaimResult;
import org.kingdoms.managers.land.claiming.UnclaimProcessor;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.services.managers.SoftService;
import org.kingdoms.services.worldguard.ServiceWorldGuard;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.NationZone;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.versionsupport.VersionSupport;

public class ClaimProcessor
extends AbstractClaimProcessor {
    private boolean shouldOverclaim = false;

    public ClaimProcessor(SimpleChunkLocation chunk, KingdomPlayer kp, Kingdom kingdom) {
        super(chunk, kp, kingdom);
    }

    @Override
    public AbstractClaimProcessor recompile() {
        return new ClaimProcessor(this.chunk, this.kp, this.kingdom).process();
    }

    @Override
    public long getResourcePoints() {
        return -this.rp;
    }

    @Override
    public double getMoney() {
        return -this.money;
    }

    @Override
    public void finalizeRequest() {
        super.finalizeRequest();
        Long cd = KingdomsConfig.Claims.UNCLAIM_COOLDOWN.getManager().getTime(this.contextHolder);
        if (cd != null) {
            UnclaimProcessor.getUnclaimCooldown().add(this.chunk, cd);
        }
        if (KingdomsConfig.Claims.RESTORATION_ENABLED.getManager().getBoolean() && !ChunkSnapshotManager.hasSnapshot(this.chunk)) {
            ChunkSnapshotManager.queueSnapshotGeneration(this.chunk);
        }
    }

    protected KingdomsLang handleMaxClaims() {
        int maxKingdomClaim = this.kingdom.getMaxClaims(this.chunk.getWorld());
        if (this.kingdom.getLandLocations().size() + 1 > maxKingdomClaim) {
            this.var("limit", maxKingdomClaim);
            return KingdomsLang.COMMAND_CLAIM_MAX_CLAIMS;
        }
        int maxClaims = this.kp.getRank().getMaxClaims();
        if (maxClaims >= 0 && this.kp.getClaims().size() + 1 > maxClaims) {
            this.var("limit", maxClaims);
            return maxClaims == 0 ? KingdomsLang.COMMAND_CLAIM_NO_CLAIMS_PLAYER : KingdomsLang.COMMAND_CLAIM_MAX_CLAIMS_PLAYER;
        }
        return null;
    }

    public boolean hasCosts() {
        return this.rp > 0L || this.money > 0.0;
    }

    public boolean shouldOverclaim() {
        return this.shouldOverclaim;
    }

    protected KingdomsLang checkProtectedRegion() {
        if (!SoftService.WORLD_GUARD.isAvailable()) {
            return null;
        }
        int radius = KingdomsConfig.Claims.PROTECTED_REGION_RADIUS.getManager().getInt();
        if (radius <= 1) {
            if (ServiceHandler.isInRegion(this.chunk)) {
                return KingdomsLang.COMMAND_CLAIM_IN_REGION;
            }
        } else {
            int z;
            int x;
            World world;
            ServiceWorldGuard wg = (ServiceWorldGuard)SoftService.WORLD_GUARD.getService();
            SimpleChunkLocation protectedRegion = this.chunk.findFromSurroundingChunks(radius, arg_0 -> ClaimProcessor.lambda$checkProtectedRegion$0(wg, world = this.chunk.getBukkitWorld(), x = this.chunk.getX(), z = this.chunk.getZ(), radius, arg_0));
            if (protectedRegion != null) {
                return KingdomsLang.COMMAND_CLAIM_NEAR_REGION;
            }
        }
        return null;
    }

    public static BiomeClaimResult processBiome(SimpleChunkLocation chunkLocation) {
        YamlConfigAccessor worldSettings = KingdomsConfig.Claims.BIOMES.getManager().withProperty(chunkLocation.getWorld()).getSection();
        if (worldSettings == null) {
            return new BiomeClaimResult(null, 0L, false);
        }
        boolean whitelist = worldSettings.getBoolean("whitelist");
        List<String> biomes = worldSettings.getStringList("biomes");
        ConfigSection costFactorSection = worldSettings.getSection().getSection("cost-factor");
        World world = chunkLocation.getBukkitWorld();
        Location center = chunkLocation.getCenterLocation();
        double highestY = world.getMaxHeight();
        XBiome xBiome = null;
        long costFactor = 0L;
        for (double lowestY = (double)VersionSupport.getMinWorldHeight(world); lowestY < highestY; lowestY += 50.0) {
            Location loc = center.clone();
            loc.setY(lowestY);
            Biome biome = loc.getBlock().getBiome();
            xBiome = XBiome.matchXBiome(biome);
            costFactor = costFactorSection.getLong(xBiome.name());
            boolean contains = biomes.contains(xBiome.name().toUpperCase(Locale.ENGLISH));
            if (contains == whitelist) continue;
            return new BiomeClaimResult(xBiome, costFactor, true);
        }
        return new BiomeClaimResult(xBiome, costFactor, false);
    }

    public static KingdomsLang checkWorldAndPermission(String world, KingdomPlayer kp) {
        if (KingdomsConfig.DISABLED_WORLDS.getStringList().contains(world)) {
            return KingdomsLang.DISABLED_WORLD;
        }
        if (KingdomsConfig.Claims.DISABLED_WORLDS.getManager().getStringList().contains(world)) {
            return KingdomsLang.COMMAND_CLAIM_DISABLED_WORLD;
        }
        if (!kp.hasPermission(StandardKingdomPermission.CLAIM)) {
            return StandardKingdomPermission.CLAIM.getDeniedMessage();
        }
        return null;
    }

    @Override
    protected KingdomsLang checkConstants() {
        return ClaimProcessor.checkWorldAndPermission(this.chunk.getWorld(), this.kp);
    }

    @Override
    public KingdomsLang processIssue() {
        KingdomsLang issue = this.checkConstants();
        if (issue != null) {
            return issue;
        }
        Land land = this.chunk.getLand();
        if (land != null && land.isClaimed()) {
            if (this.kingdom.isClaimed(this.chunk)) {
                return KingdomsLang.COMMAND_CLAIM_ALREADY_OWNED;
            }
            if (!KingdomsConfig.Powers.POWER_ENABLED.getManager().getBoolean()) {
                return KingdomsLang.COMMAND_CLAIM_OCCUPIED_LAND;
            }
            Kingdom other = land.getKingdom();
            if (!other.canBeOverclaimed()) {
                return KingdomsLang.COMMAND_CLAIM_CANT_OVERCLAIM;
            }
            this.shouldOverclaim = true;
        }
        if (!this.kp.isAdmin()) {
            Nation nation;
            KingdomsLang result = this.handleMaxClaims();
            if (result != null) {
                return result;
            }
            result = this.checkProtectedRegion();
            if (result != null) {
                return result;
            }
            BiomeClaimResult biome = ClaimProcessor.processBiome(this.chunk);
            if (biome.isDisallowed()) {
                this.var("biome", biome.getBiome().name().toLowerCase(Locale.ENGLISH));
                return KingdomsLang.COMMAND_CLAIM_DISALLOWED_BIOME;
            }
            Pair<Long, Double> costs = ClaimProcessor.calculateCosts(this.kingdom, 1, this.auto, biome.getCostFactor());
            if (costs != null) {
                this.rp = costs.getKey();
                this.money = costs.getValue();
                this.var("rp", this.rp);
                this.var("money", this.money);
                this.var("biome_cost_factor", biome.getCostFactor());
                if (!this.kingdom.hasResourcePoints(this.rp)) {
                    return KingdomsLang.COMMAND_CLAIM_NEED_RP;
                }
                if (!this.kingdom.hasMoney(this.money)) {
                    return KingdomsLang.COMMAND_CLAIM_NEED_MONEY;
                }
                this.rp = -this.rp;
                this.money = -this.money;
            }
            if (!Land.isConnected(this.chunk, this.kingdom)) {
                return KingdomsLang.COMMAND_CLAIM_NOT_CONNECTED;
            }
            if (Land.validateDistance(this.chunk, this.kingdom.getId()) != null) {
                return KingdomsLang.COMMAND_CLAIM_NOT_DISTANCED;
            }
            NationZone nationZone = Land.getNationZone(this.chunk);
            if (nationZone != null && !(nation = nationZone.getNation()).isMember(this.kp.getKingdomId())) {
                this.var("nation", nation.getName());
                return KingdomsLang.COMMAND_CLAIM_NATION_ZONE;
            }
        }
        return null;
    }

    @Override
    public ClaimProcessor process() {
        this.issue = this.processIssue();
        return this;
    }

    public static Pair<Long, Double> calculateCosts(Kingdom kingdom, int lands, boolean auto, long biomeFactor) {
        int currentLands;
        int starterPack = KingdomsConfig.Claims.STARTER_FREE.getManager().getInt();
        int freeLands = starterPack - ((currentLands = kingdom.getLandLocations().size()) + lands);
        if (freeLands >= 0) {
            return null;
        }
        if (starterPack > currentLands && (lands -= starterPack - currentLands) <= 0) {
            return null;
        }
        PlaceholderContextBuilder ctx = new PlaceholderContextBuilder().withContext(kingdom);
        ctx.raw("biome_cost_factor", biomeFactor);
        KingdomsConfig.Claims rpOpt = auto ? KingdomsConfig.Claims.RESOURCE_POINTS_AUTO_CLAIMS : KingdomsConfig.Claims.RESOURCE_POINTS_CLAIMS;
        long rp = (long)MathUtils.eval(rpOpt.getManager().getMathExpression(), ctx);
        double money = 0.0;
        if (ServiceHandler.bankServiceAvailable()) {
            KingdomsConfig.Claims moneyOpt = auto ? KingdomsConfig.Claims.MONEY_AUTO_CLAIMS : KingdomsConfig.Claims.MONEY_CLAIMS;
            money = MathUtils.eval(moneyOpt.getManager().getMathExpression(), ctx);
        }
        return Pair.of(rp * (long)lands, money * (double)lands);
    }

    private static /* synthetic */ SimpleChunkLocation lambda$checkProtectedRegion$0(ServiceWorldGuard wg, World world, int x, int z, int radius, SimpleChunkLocation current) {
        return wg.isChunkInRegion(world, x, z, radius) ? current : null;
    }
}

