/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.indicator;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.versionsupport.VersionSupport;

public final class BlockVisualizerBuilder {
    public final List<Block> blocks = new ArrayList<Block>();
    private final Player player;
    private final Chunk chunk;
    private final int y;
    private final int maxHeight;
    private final int minHeight;
    private final int maxAttempts;
    private final XMaterial cornerBlocks;
    private final XMaterial twoBlocks;
    private final boolean outOfWorldBuildingBounds;

    public BlockVisualizerBuilder(Player player, Chunk chunk, int y, int maxAttempts, XMaterial cornerBlocks, XMaterial twoBlocks) {
        World world = chunk.getWorld();
        this.player = player;
        this.chunk = chunk;
        this.cornerBlocks = cornerBlocks;
        this.twoBlocks = twoBlocks;
        this.maxAttempts = maxAttempts;
        this.maxHeight = world.getMaxHeight() - 1;
        this.minHeight = VersionSupport.getMinWorldHeight(world);
        if (y < this.minHeight) {
            this.outOfWorldBuildingBounds = true;
            y = this.minHeight;
        } else if (y > this.maxHeight) {
            this.outOfWorldBuildingBounds = true;
            y = this.maxHeight;
        } else {
            this.outOfWorldBuildingBounds = maxAttempts <= 0;
        }
        this.y = y;
    }

    public void visualize(int x, int z, boolean corner) {
        int y = this.y;
        if (!this.outOfWorldBuildingBounds) {
            Block block;
            boolean descending;
            int attempt = this.maxAttempts;
            boolean isPassable = LocationUtils.blockCanBeReplaced(this.chunk.getBlock(x, y + 1, z));
            boolean bl = descending = y + 1 <= this.maxHeight && isPassable;
            if (!isPassable) {
                y += 2;
            }
            while (attempt-- > 0 && y > this.minHeight && y < this.maxHeight && descending != !LocationUtils.blockCanBeReplaced(block = this.chunk.getBlock(x, y, z))) {
                if (descending) {
                    --y;
                    continue;
                }
                ++y;
            }
        }
        Block block = this.chunk.getBlock(x, y, z);
        Location location = block.getLocation();
        PlayerUtils.sendBlockChange(this.player, location, corner ? this.cornerBlocks : this.twoBlocks);
        this.blocks.add(block);
    }
}

