/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.protection;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.land.protection.MiscUpgradeManager;
import org.kingdoms.utils.internal.integer.IntHashSet;

public final class KingdomVaultManager
implements Listener {
    public static final IntHashSet VIEWVERS = new IntHashSet();

    public static void asViewer(Player player) {
        VIEWVERS.add(player.getEntityId());
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        HumanEntity player = event.getPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(player.getUniqueId());
        if (!kp.hasKingdom()) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (kingdom.getNexusChest() != event.getPlayer().getOpenInventory().getTopInventory()) {
            return;
        }
        VIEWVERS.remove(event.getPlayer().getEntityId());
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!VIEWVERS.contains(player.getEntityId())) {
            return;
        }
        if (event.getClickedInventory() == player.getOpenInventory().getTopInventory()) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null) {
            return;
        }
        if (!MiscUpgradeManager.canPlaceItemInKingdomChest(clicked)) {
            KingdomsLang.VAULT_BLACKLISTED_ITEM.sendError((CommandSender)player, new Object[0]);
            event.setCancelled(true);
        }
    }
}

