/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.protectionsign;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.ProtectionSign;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.chat.ChatInputManager;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.string.StringUtils;

public final class ProtectionSignGUIManager {
    public static void openMenu(Player player, ProtectionSign protection) {
        InteractiveGUI gui = GUIAccessor.prepare(player, (OfflinePlayer)player, "protection-signs/protected-sign", "protectionsign-member-count", protection.getPlayers().size(), "protectionsign-kingdom-count", protection.getKingdoms().size(), "protection_type", protection.getProtectionType().getDisplayname(), "owner", protection.getOwnerPlayer().getName());
        if (gui == null) {
            return;
        }
        gui.push("back", () -> ((Player)player).closeInventory(), new Object[0]).push("protection-type", () -> ProtectionSignGUIManager.openProtectionTypeGUI(player, protection), new Object[0]).push("info", () -> {
            if (!protection.isContainer()) {
                KingdomsLang.PROTECTED_SIGNS_PASSWORD_CONTAINER_ONLY.sendMessage((CommandSender)player);
                return;
            }
            KingdomsLang.PROTECTED_SIGNS_PASSWORD_ASK.sendMessage((CommandSender)player);
            gui.startConversation("info");
        }, input -> ProtectionSignGUIManager.setPassword(player, input, protection), new Object[0]).push("players", () -> ProtectionSignGUIManager.openPlayers(player, protection), new Object[0]).push("kingdoms", () -> ProtectionSignGUIManager.openKingdoms(player, protection), new Object[0]);
        gui.open();
    }

    public static void setPassword(Player player, String password, ProtectionSign protection) {
        String removeKeyword = KingdomsConfig.ProtectionSigns.PASSWORDS_REMOVE_KEYWORD.getManager().getString();
        if (password.equalsIgnoreCase(removeKeyword)) {
            if (!protection.hasPassword()) {
                KingdomsLang.PROTECTED_SIGNS_PASSWORD_NOT_SET.sendError((CommandSender)player, new Object[0]);
            } else {
                KingdomsLang.PROTECTED_SIGNS_PASSWORD_REMOVED.sendMessage((CommandSender)player);
                password = null;
            }
        } else {
            int maxLength = KingdomsConfig.ProtectionSigns.PASSWORDS_LENGTH_MAX.getManager().getInt();
            int minLength = KingdomsConfig.ProtectionSigns.PASSWORDS_LENGTH_MIN.getManager().getInt();
            int len = password.length();
            if (len < minLength || len > maxLength) {
                KingdomsLang.PROTECTED_SIGNS_PASSWORD_LENGTH.sendError((CommandSender)player, "min", minLength, "max", maxLength, "length", len);
                return;
            }
            KingdomsLang.PROTECTED_SIGNS_PASSWORD_SET.sendMessage((CommandSender)player);
        }
        protection.changePassword(password);
        ChatInputManager.endConversation(player);
    }

    public static void openKingdoms(Player player, ProtectionSign protection) {
        InteractiveGUI gui = GUIAccessor.prepare(player, "protection-signs/kingdoms");
        if (gui == null) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        gui.push("include", () -> {
            int limit = KingdomsConfig.ProtectionSigns.LIMITS_KINGDOMS.getManager().getInt();
            if (protection.getKingdoms().size() >= limit) {
                KingdomsLang.PROTECTED_SIGNS_KINGDOMS_LIMIT.sendMessage((CommandSender)player, "limit", limit);
                return;
            }
            KingdomsLang.PROTECTED_SIGNS_KINGDOMS_INCLUDE_NAME.sendMessage((CommandSender)player);
            gui.startConversation("include");
        }, input -> {
            Kingdom kingdom = Kingdom.getKingdom(input);
            if (kingdom == null) {
                KingdomsLang.NOT_FOUND_KINGDOM.sendError((CommandSender)player, "kingdom", input);
                return;
            }
            if (kingdom.getId().equals(kp.getKingdomId())) {
                KingdomsLang.PROTECTED_SIGNS_KINGDOMS_INCLUDE_OWNER.sendMessage((CommandSender)player, "name", kingdom.getName());
                return;
            }
            if (protection.getKingdoms().containsKey(kingdom.getId())) {
                KingdomsLang.PROTECTED_SIGNS_KINGDOMS_INCLUDE_IS_ALREADY_IN_GROUP.sendMessage((CommandSender)player, "name", kingdom.getName());
                return;
            }
            protection.getKingdoms().put(kingdom.getId(), true);
            KingdomsLang.PROTECTED_SIGNS_KINGDOMS_INCLUDE_INCLUDED.sendMessage((CommandSender)player, "name", kingdom.getName());
            gui.endConversation();
            ProtectionSignGUIManager.openPlayers(player, protection);
        }, new Object[0]).push("exclude", () -> {
            int limit = KingdomsConfig.ProtectionSigns.LIMITS_PLAYERS.getManager().getInt();
            if (protection.getKingdoms().size() >= limit) {
                KingdomsLang.PROTECTED_SIGNS_KINGDOMS_LIMIT.sendMessage((CommandSender)player, "limit", limit);
                return;
            }
            KingdomsLang.PROTECTED_SIGNS_KINGDOMS_EXCLUDE_NAME.sendMessage((CommandSender)player);
            gui.startConversation("exclude");
        }, input -> {
            Kingdom kingdom = Kingdom.getKingdom(input);
            if (kingdom == null) {
                KingdomsLang.NOT_FOUND_KINGDOM.sendError((CommandSender)player, "kingdom", input);
                return;
            }
            if (kingdom.getId().equals(kp.getKingdomId())) {
                KingdomsLang.PROTECTED_SIGNS_KINGDOMS_EXCLUDE_OWNER.sendError((CommandSender)player, "name", kingdom.getName());
                return;
            }
            if (protection.getKingdoms().containsKey(kingdom.getId())) {
                KingdomsLang.PROTECTED_SIGNS_KINGDOMS_EXCLUDE_IS_ALREADY_IN_GROUP.sendError((CommandSender)player, "name", kingdom.getName());
                return;
            }
            protection.getKingdoms().put(kingdom.getId(), false);
            KingdomsLang.PROTECTED_SIGNS_KINGDOMS_EXCLUDE_EXCLUDED.sendMessage((CommandSender)player, "name", kingdom.getName());
            gui.endConversation();
            ProtectionSignGUIManager.openPlayers(player, protection);
        }, new Object[0]).push("clear", () -> {
            protection.getKingdoms().clear();
            KingdomsLang.PROTECTED_SIGNS_KINGDOMS_CLEARED.sendMessage((CommandSender)player);
            ProtectionSignGUIManager.openMenu(player, protection);
        }, new Object[0]);
        ReusableOptionHandler option = gui.getReusableOption("members");
        ArrayList<UUID> disbanded = new ArrayList<UUID>();
        for (Map.Entry<UUID, Boolean> memberEntry : protection.getKingdoms().entrySet()) {
            Kingdom kingdom = Kingdom.getKingdom(memberEntry.getKey());
            if (kingdom == null) {
                KingdomsLang.PROTECTED_SIGNS_KINGDOMS_DISBANDED.sendMessage((CommandSender)player, "id", memberEntry.getKey());
                disbanded.add(memberEntry.getKey());
                continue;
            }
            option.onNormalClicks(() -> {
                protection.getKingdoms().remove(kingdom.getId());
                KingdomsLang.PROTECTED_SIGNS_KINGDOMS_REMOVED.sendMessage((CommandSender)player, "name", kingdom.getName());
                ProtectionSignGUIManager.openMenu(player, protection);
            }).setEdits("name", kingdom.getName(), "included", memberEntry.getValue()).pushHead(kingdom.getKing().getOfflinePlayer());
            if (option.hasNext()) continue;
            break;
        }
        disbanded.forEach(k -> protection.getKingdoms().remove(k));
        gui.push("back", () -> ProtectionSignGUIManager.openMenu(player, protection), new Object[0]);
        gui.open();
    }

    public static void openPlayers(Player player, ProtectionSign protection) {
        InteractiveGUI gui = GUIAccessor.prepare(player, "protection-signs/players");
        if (gui == null) {
            return;
        }
        gui.push("include", () -> {
            int limit = KingdomsConfig.ProtectionSigns.LIMITS_PLAYERS.getManager().getInt();
            if (protection.getPlayers().size() >= limit) {
                KingdomsLang.PROTECTED_SIGNS_PLAYERS_LIMIT.sendMessage((CommandSender)player, "limit", limit);
                return;
            }
            KingdomsLang.PROTECTED_SIGNS_PLAYERS_INCLUDE_NAME.sendMessage((CommandSender)player);
            gui.startConversation("include");
        }, input -> {
            OfflinePlayer include = PlayerUtils.getOfflinePlayer(input);
            if (include == null) {
                KingdomsLang.NOT_FOUND_PLAYER.sendError((CommandSender)player, new Object[0]);
                return;
            }
            if (include.getUniqueId().equals(protection.getOwner())) {
                KingdomsLang.PROTECTED_SIGNS_PLAYERS_INCLUDE_OWNER.sendMessage((CommandSender)player, "name", include.getName());
                return;
            }
            if (protection.getPlayers().containsKey(include.getUniqueId())) {
                KingdomsLang.PROTECTED_SIGNS_PLAYERS_INCLUDE_IS_ALREADY_IN_GROUP.sendMessage((CommandSender)player, "name", include.getName());
                return;
            }
            protection.getPlayers().put(include.getUniqueId(), true);
            KingdomsLang.PROTECTED_SIGNS_PLAYERS_INCLUDE_INCLUDED.sendMessage((CommandSender)player, "name", include.getName());
            gui.endConversation();
            ProtectionSignGUIManager.openPlayers(player, protection);
        }, new Object[0]).push("exclude", () -> {
            int limit = KingdomsConfig.ProtectionSigns.LIMITS_PLAYERS.getManager().getInt();
            if (protection.getPlayers().size() >= limit) {
                KingdomsLang.PROTECTED_SIGNS_PLAYERS_LIMIT.sendError((CommandSender)player, "limit", limit);
                return;
            }
            KingdomsLang.PROTECTED_SIGNS_PLAYERS_EXCLUDE_NAME.sendError((CommandSender)player, new Object[0]);
            gui.startConversation("exclude");
        }, input -> {
            OfflinePlayer exclude = PlayerUtils.getOfflinePlayer(input);
            if (exclude == null) {
                KingdomsLang.NOT_FOUND_PLAYER.sendError((CommandSender)player, new Object[0]);
                return;
            }
            if (exclude.getUniqueId().equals(protection.getOwner())) {
                KingdomsLang.PROTECTED_SIGNS_PLAYERS_EXCLUDE_OWNER.sendError((CommandSender)player, "name", exclude.getName());
                return;
            }
            if (protection.getPlayers().containsKey(exclude.getUniqueId())) {
                KingdomsLang.PROTECTED_SIGNS_PLAYERS_EXCLUDE_IS_ALREADY_IN_GROUP.sendError((CommandSender)player, "name", exclude.getName());
                return;
            }
            protection.getPlayers().put(exclude.getUniqueId(), false);
            KingdomsLang.PROTECTED_SIGNS_PLAYERS_EXCLUDE_EXCLUDED.sendMessage((CommandSender)player, "name", exclude.getName());
            gui.endConversation();
            ProtectionSignGUIManager.openPlayers(player, protection);
        }, new Object[0]).push("clear", () -> {
            protection.getPlayers().clear();
            KingdomsLang.PROTECTED_SIGNS_PLAYERS_CLEARED.sendMessage((CommandSender)player);
            ProtectionSignGUIManager.openMenu(player, protection);
        }, new Object[0]);
        ReusableOptionHandler option = gui.getReusableOption("members");
        for (Map.Entry<UUID, Boolean> memberEntry : protection.getPlayers().entrySet()) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)memberEntry.getKey());
            option.onNormalClicks(() -> {
                protection.getPlayers().remove(offlinePlayer.getUniqueId());
                KingdomsLang.PROTECTED_SIGNS_PLAYERS_REMOVED.sendMessage((CommandSender)player, "name", offlinePlayer.getName());
                ProtectionSignGUIManager.openMenu(player, protection);
            }).setEdits("name", offlinePlayer.getName(), "included", memberEntry.getValue()).pushHead(offlinePlayer);
            if (option.hasNext()) continue;
            break;
        }
        gui.push("back", () -> ProtectionSignGUIManager.openMenu(player, protection), new Object[0]);
        gui.open();
    }

    public static void openProtectionTypeGUI(Player player, ProtectionSign protection) {
        InteractiveGUI gui = GUIAccessor.prepare(player, "protection-signs/protection-type");
        if (gui == null) {
            return;
        }
        for (ProtectionSign.ProtectionType type : ProtectionSign.ProtectionType.values()) {
            gui.push(StringUtils.configOption(type), () -> {
                player.closeInventory();
                if (protection.getProtectionType() == type) {
                    KingdomsLang.PROTECTED_SIGNS_PROTECTION_TYPE_ALREADY_USING.sendMessage((CommandSender)player, "protection", type.getDisplayname());
                } else {
                    protection.setProtectionType(type);
                    KingdomsLang.PROTECTED_SIGNS_PROTECTION_TYPE_CHANGED.sendMessage((CommandSender)player, "protection", type.getDisplayname());
                    protection.updateSign();
                }
            }, "protection", type.getDisplayname(), "enabled", protection.getProtectionType() == type);
        }
        gui.push("back", () -> ProtectionSignGUIManager.openMenu(player, protection), new Object[0]);
        gui.open();
    }
}

