/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.structures;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPermission;
import org.kingdoms.constants.player.KingdomPermissionRegistry;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.constants.player.RankMap;
import org.kingdoms.data.Pair;
import org.kingdoms.events.general.ranks.RankColorChangeEvent;
import org.kingdoms.events.general.ranks.RankCreateEvent;
import org.kingdoms.events.general.ranks.RankDeleteEvent;
import org.kingdoms.events.general.ranks.RankMaterialChangeEvent;
import org.kingdoms.events.general.ranks.RankMaxClaimsChangeEvent;
import org.kingdoms.events.general.ranks.RankNameChangeEvent;
import org.kingdoms.events.general.ranks.RankPermissionChangeEvent;
import org.kingdoms.events.general.ranks.RankPriorityChangeEvent;
import org.kingdoms.events.general.ranks.RankSymbolChangeEvent;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.GUIPagination;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XTag;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.MessagePiece;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.internal.enumeration.OrderedSet;
import org.kingdoms.utils.string.StringUtils;

public final class RankEditor {
    private final Player player;
    private final KingdomPlayer kp;
    private final Rank rank;
    private final Group group;
    private final Consumer<InteractiveGUI> ranksGUIEditor;
    private final KingdomsGUI ranksGUIPath;

    public RankEditor(Player player, Rank rank, Group group, Consumer<InteractiveGUI> ranksGUIEditor, KingdomsGUI ranksGUIPath) {
        this.player = player;
        this.kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        this.rank = rank;
        this.group = group;
        this.ranksGUIEditor = ranksGUIEditor;
        this.ranksGUIPath = ranksGUIPath;
    }

    public static MessageBuilder getRankEdits(Rank rank) {
        return new MessageBuilder().raw("rank_node", rank.getNode()).raw("rank_priority", rank.getPriority()).raw("rank_max_claims", rank.getMaxClaims()).raw("rank_material", rank.getMaterial().toString()).parse("rank_symbol", rank.getSymbol()).parse("rank_name", rank.getName()).parse("rank_color", rank.getColor());
    }

    public static XMaterial randomMaterial() {
        XMaterial mat;
        Material material;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while ((material = (mat = XMaterial.VALUES[random.nextInt(0, XMaterial.VALUES.length)]).parseMaterial()) == null || XTag.INVENTORY_NOT_DISPLAYABLE.isTagged(XMaterial.matchXMaterial(material))) {
        }
        return mat;
    }

    public static Rank createNewRank(RankMap ranks, boolean nation) {
        String node = KingdomsConfig.Ranks.NEW_RANK_NODE.getManager().getString();
        int i = 0;
        while (ranks.getRanks().containsKey(node)) {
            node = "node (" + ++i + ')';
        }
        String name = KingdomsConfig.Ranks.NEW_RANK_NAME.getManager().getString();
        String color = KingdomsConfig.Ranks.NEW_RANK_COLOR.getManager().getString();
        String symbol = KingdomsConfig.Ranks.NEW_RANK_SYMBOL.getManager().getString();
        int maxClaims = KingdomsConfig.Ranks.NEW_RANK_MAX_CLAIMS.getManager().getInt();
        List<String> permissions = KingdomsConfig.Ranks.NEW_RANK_PERMISSIONS.getManager().getStringList();
        Set<KingdomPermission> perms = !permissions.isEmpty() && permissions.get(0).equals("@MEMBER") ? (nation ? new HashSet<KingdomPermission>() : ranks.getLowestRank().copyPermissions()) : KingdomPermissionRegistry.parse(permissions);
        String materialName = KingdomsConfig.Ranks.NEW_RANK_MATERIAL.getManager().getString();
        XMaterial material = materialName.equalsIgnoreCase("random") ? RankEditor.randomMaterial() : XMaterial.matchXMaterial(materialName).orElse(XMaterial.DIRT);
        return new Rank(node, name, color, symbol, material, ranks.size() - 1, maxClaims, perms);
    }

    protected static InteractiveGUI openRanks(KingdomsGUI guiPath, Player player, KingdomPlayer kp, Group group, Consumer<InteractiveGUI> editor) {
        InteractiveGUI ranks = GUIAccessor.prepare(player, guiPath, new MessageBuilder().withContext(kp.getOfflinePlayer()));
        ranks.push("add", () -> {
            int limit;
            int size = group.getRanks().size();
            if (size >= (limit = KingdomsConfig.Ranks.CUSTOM_RANKS_LIMITS_RANKS.getManager().getInt())) {
                KingdomsLang.NEXUS_RANK_EDITOR_MAX.sendMessage((CommandSender)player, "limit", limit);
                return;
            }
            Rank rank = RankEditor.createNewRank(group.getRanks(), false);
            Kingdoms.taskScheduler().executeAsync(() -> {
                RankCreateEvent event = new RankCreateEvent(rank, group, kp);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                group.getRanks().push(size - 1, rank);
                new RankEditor(player, rank, group, editor, guiPath).openRankEditor(innerGUI -> innerGUI.push("back", () -> RankEditor.openRanks(guiPath, player, kp, group, editor), new Object[0]));
            });
        }, new Object[0]).push("reset", () -> {
            InteractiveGUI gui = GUIAccessor.prepare(player, "confirm/ranks/reset");
            if (gui == null) {
                return;
            }
            gui.push("confirm", () -> {
                group.setRanks(Rank.copyDefaults());
                RankEditor.openRanks(guiPath, player, kp, group, editor);
            }, new Object[0]).push("cancel", () -> ((Player)player).closeInventory(), new Object[0]);
            gui.open();
        }, new Object[0]).push("demote-all", () -> {
            InteractiveGUI gui = GUIAccessor.prepare(player, "confirm/ranks/demote-all");
            if (gui == null) {
                return;
            }
            gui.push("confirm", () -> {
                Rank memberRank = group.getRanks().getLowestRank();
                if (group instanceof Nation) {
                    for (KingdomPlayer member : group.getKingdomPlayers()) {
                        if (member.getNationRank().isKing()) continue;
                        member.setNationRank(KingdomPlayer.getKingdomPlayer((OfflinePlayer)player), memberRank);
                    }
                } else {
                    for (KingdomPlayer member : group.getKingdomPlayers()) {
                        if (member.getRank().isKing()) continue;
                        member.setRank(KingdomPlayer.getKingdomPlayer((OfflinePlayer)player), memberRank);
                    }
                }
                RankEditor.openRanks(guiPath, player, kp, group, editor);
            }, new Object[0]).push("cancel", () -> ((Player)player).closeInventory(), new Object[0]);
            gui.open();
        }, new Object[0]);
        ReusableOptionHandler holder = ranks.getReusableOption("rank");
        if (holder != null) {
            for (Rank rank : group.getRanks().getSortedRanks().values()) {
                holder.getSettings().addAll((Map)RankEditor.getRankEdits(rank).getPlaceholders());
                ((ReusableOptionHandler)holder.editItem(item -> rank.getMaterial().setType((ItemStack)item))).onNormalClicks(() -> new RankEditor(player, rank, group, editor, guiPath).openRankEditor(innerGUI -> innerGUI.push("back", () -> RankEditor.openRanks(guiPath, player, kp, group, editor), new Object[0]))).done();
            }
        }
        editor.accept(ranks);
        ranks.open();
        return ranks;
    }

    public InteractiveGUI openRankEditor(Consumer<InteractiveGUI> editor) {
        boolean king = this.rank.isKing();
        boolean nation = this.group instanceof Nation;
        KingdomsGUI path = nation ? (king ? KingdomsGUI.STRUCTURES_NEXUS_NATION_RANKS_KING$RANK$EDITOR : KingdomsGUI.STRUCTURES_NEXUS_NATION_RANKS_RANK$EDITOR) : (king ? KingdomsGUI.STRUCTURES_NEXUS_RANKS_KING$RANK$EDITOR : KingdomsGUI.STRUCTURES_NEXUS_RANKS_RANK$EDITOR);
        return this.openRankEditor(path, editor);
    }

    public InteractiveGUI openRankEditor(KingdomsGUI guiPath, Consumer<InteractiveGUI> editor) {
        InteractiveGUI gui = GUIAccessor.prepare(this.player, guiPath, RankEditor.getRankEdits(this.rank).withContext(this.kp.getOfflinePlayer()));
        gui.push("node", () -> {
            KingdomsLang.NEXUS_RANK_EDITOR_ENTER_VALUE.sendMessage((CommandSender)this.player);
            gui.startConversation("node");
        }, input -> {
            if (!StringUtils.isEnglish(input)) {
                KingdomsLang.NEXUS_RANK_EDITOR_INVALID_NODE.sendError((CommandSender)this.player, new Object[0]);
                return;
            }
            int limit = KingdomsConfig.Ranks.CUSTOM_RANKS_LIMITS_LENGTH_NODE.getManager().getInt();
            if (input.length() > limit) {
                KingdomsLang.NEXUS_RANK_EDITOR_LENGTH_NODE.sendError((CommandSender)this.player, "limit", limit);
                return;
            }
            if (this.group.getRanks().has((String)input)) {
                KingdomsLang.NEXUS_RANK_EDITOR_NODE_ALREADY_EXISTS.sendError((CommandSender)this.player, new Object[0]);
                return;
            }
            this.group.updateRankNode(this.rank.getNode(), (String)input);
            this.openRankEditor(guiPath, editor);
            gui.endConversation();
        }, new Object[0]).push("name", () -> {
            KingdomsLang.NEXUS_RANK_EDITOR_ENTER_VALUE.sendMessage((CommandSender)this.player);
            gui.startConversation("name");
        }, input -> {
            int limit = KingdomsConfig.Ranks.CUSTOM_RANKS_LIMITS_LENGTH_NAME.getManager().getInt();
            if (input.length() > limit) {
                KingdomsLang.NEXUS_RANK_EDITOR_LENGTH_NAME.sendMessage((CommandSender)this.player, "limit", limit);
                return;
            }
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.player);
            RankNameChangeEvent event = new RankNameChangeEvent(this.rank, this.group, kp, (String)input);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.rank.setName(event.getNewName());
            this.openRankEditor(guiPath, editor);
            gui.endConversation();
        }, new Object[0]).push("color", () -> {
            KingdomsLang.NEXUS_RANK_EDITOR_ENTER_VALUE.sendMessage((CommandSender)this.player);
            gui.startConversation("color");
        }, input -> {
            int limit = KingdomsConfig.Ranks.CUSTOM_RANKS_LIMITS_LENGTH_COLOR.getManager().getInt();
            MessageObject compiled = MessageCompiler.compile(input, new MessageCompilerSettings(false, true, true, false, false, null));
            if (compiled.hasPiece(piece -> !(piece instanceof MessagePiece.SimpleColor) && !(piece instanceof MessagePiece.HexColor))) {
                KingdomsLang.NEXUS_RANK_EDITOR_COLOR_HAS_NONE_COLORS.sendError((CommandSender)this.player, new Object[0]);
                return;
            }
            if (compiled.count(piece -> piece instanceof MessagePiece.Color) > limit) {
                KingdomsLang.NEXUS_RANK_EDITOR_LENGTH_COLOR.sendMessage((CommandSender)this.player, "limit", limit);
                return;
            }
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.player);
            RankColorChangeEvent event = new RankColorChangeEvent(this.rank, this.group, kp, (String)input);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.rank.setColor(event.getNewColor());
            this.openRankEditor(guiPath, editor);
            gui.endConversation();
        }, new Object[0]).push("symbol", () -> {
            KingdomsLang.NEXUS_RANK_EDITOR_ENTER_VALUE.sendMessage((CommandSender)this.player);
            gui.startConversation("symbol");
        }, input -> {
            int limit = KingdomsConfig.Ranks.CUSTOM_RANKS_LIMITS_LENGTH_SYMBOL.getManager().getInt();
            if (input.length() > limit) {
                KingdomsLang.NEXUS_RANK_EDITOR_LENGTH_SYMBOL.sendError((CommandSender)this.player, "limit", limit);
                return;
            }
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.player);
            RankSymbolChangeEvent event = new RankSymbolChangeEvent(this.rank, this.group, kp, (String)input);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.rank.setSymbol(event.getNewSymbol());
            this.openRankEditor(guiPath, editor);
            gui.endConversation();
        }, new Object[0]).push("priority", () -> {
            KingdomsLang.NEXUS_RANK_EDITOR_ENTER_VALUE.sendMessage((CommandSender)this.player);
            gui.startConversation("priority");
        }, input -> {
            int newPriority;
            try {
                newPriority = Integer.parseInt(input);
            }
            catch (NumberFormatException ignored) {
                KingdomsLang.INVALID_NUMBER.sendError((CommandSender)this.player, "arg", input);
                return;
            }
            int size = this.group.getRanks().size();
            if (newPriority <= 0 || newPriority >= size) {
                KingdomsLang.NEXUS_RANK_EDITOR_INVALID_PRIORITY.sendError((CommandSender)this.player, new Object[0]);
                return;
            }
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.player);
            RankPriorityChangeEvent event = new RankPriorityChangeEvent(this.rank, this.group, kp, newPriority);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.group.getRanks().push(newPriority, this.rank);
            this.openRankEditor(guiPath, editor);
            gui.endConversation();
        }, new Object[0]).push("max-claims", () -> {
            KingdomsLang.NEXUS_RANK_EDITOR_ENTER_VALUE.sendMessage((CommandSender)this.player);
            gui.startConversation("max-claims");
        }, input -> {
            int num;
            try {
                num = Integer.parseInt(input);
            }
            catch (NumberFormatException ignored) {
                KingdomsLang.NEXUS_RANK_EDITOR_INVALID_MAX_CLAIMS.sendError((CommandSender)this.player, new Object[0]);
                return;
            }
            if (num < 0) {
                KingdomsLang.NEXUS_RANK_EDITOR_INVALID_MAX_CLAIMS.sendError((CommandSender)this.player, new Object[0]);
                return;
            }
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.player);
            RankMaxClaimsChangeEvent event = new RankMaxClaimsChangeEvent(this.rank, this.group, kp, num);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.rank.setMaxClaims(event.getNewMaxClaims());
            this.openRankEditor(guiPath, editor);
            gui.endConversation();
        }, new Object[0]).push("delete", () -> Kingdoms.taskScheduler().executeAsync(() -> {
            int ranks = this.group.getRanks().size();
            if (ranks - 1 < 2) {
                KingdomsLang.NEXUS_RANK_EDITOR_CANNOT_DELETE_RANK.sendError((CommandSender)this.player, new Object[0]);
                return;
            }
            if (this.rank.isKing()) {
                KingdomsLang.NEXUS_RANK_EDITOR_CANNOT_DELETE_KING.sendError((CommandSender)this.player, new Object[0]);
                return;
            }
            if (this.group.getRanks().getLowestRank().getPriority() == this.rank.getPriority()) {
                KingdomsLang.NEXUS_RANK_EDITOR_CANNOT_DELETE_MEMBER.sendError((CommandSender)this.player, new Object[0]);
                return;
            }
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.player);
            RankDeleteEvent event = new RankDeleteEvent(this.rank, this.group, kp);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.group.getRanks().remove(this.rank.getNode());
            RankEditor.openRanks(this.ranksGUIPath, this.player, kp, this.group, this.ranksGUIEditor);
        }), new Object[0]).push("copy", () -> this.rankSelector(innerGUI -> innerGUI.push("back", () -> this.openRankEditor(editor), new Object[0])), new Object[0]);
        gui.option("material").editItem(item -> this.rank.getMaterial().setType((ItemStack)item)).onNormalClicks(() -> {
            KingdomsLang.NEXUS_RANK_EDITOR_ENTER_VALUE.sendMessage((CommandSender)this.player);
            gui.startConversation("material");
        }).setConversation(input -> {
            Optional<XMaterial> material = XMaterial.matchXMaterial(input);
            if (!material.isPresent()) {
                KingdomsLang.NEXUS_RANK_EDITOR_UNKNOWN_MATERIAL.sendError((CommandSender)this.player, "material", input);
                return;
            }
            XMaterial mat = material.get();
            List<String> list2 = KingdomsConfig.Ranks.CUSTOM_RANKS_LIMITS_MATERIAL_LIST.getManager().getStringList();
            boolean whitelist = KingdomsConfig.Ranks.CUSTOM_RANKS_LIMITS_MATERIAL_WHITELIST.getManager().getBoolean();
            boolean contains = mat.isOneOf(list2);
            if (XTag.INVENTORY_NOT_DISPLAYABLE.isTagged(mat) || whitelist != contains) {
                KingdomsLang.NEXUS_RANK_EDITOR_INVALID_MATERIAL.sendMessage((CommandSender)this.player, "material", KingdomsLang.translateMaterial(mat));
                return;
            }
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.player);
            RankMaterialChangeEvent event = new RankMaterialChangeEvent(this.rank, this.group, kp, mat);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.rank.setMaterial(event.getNewMaterial());
            this.openRankEditor(guiPath, editor);
            gui.endConversation();
        }).done();
        gui.push("permissions", () -> this.openPermissions(innerGUI -> innerGUI.push("back", () -> this.openRankEditor(editor), new Object[0]), 0), new Object[0]);
        editor.accept(gui);
        gui.open();
        return gui;
    }

    public InteractiveGUI openPermissions(Consumer<InteractiveGUI> editor, int page) {
        InteractiveGUI gui = GUIAccessor.prepare(this.player, "structures/nexus/ranks/permissions");
        Pair pagination = GUIPagination.paginate(gui, Kingdoms.get().getPermissionRegistery().getRegistry().values(), "permissions", page, newPage -> this.openPermissions(editor, (int)newPage));
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.player);
        for (KingdomPermission permission : pagination.getValue()) {
            pagination.getKey().setEdits("permission", permission.getNamespace().getConfigOptionName(), "enabled", this.rank.hasPermission(permission));
            pagination.getKey().onNormalClicks(() -> Kingdoms.taskScheduler().executeAsync(() -> {
                RankPermissionChangeEvent event = new RankPermissionChangeEvent(this.rank, this.group, kp, new OrderedSet<KingdomPermission>(this.rank.getPermissions()));
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                if (this.rank.hasPermission(permission)) {
                    this.rank.getPermissions().remove(permission);
                } else {
                    this.rank.getPermissions().add(permission);
                }
                this.openPermissions(editor, page);
            })).done();
        }
        editor.accept(gui);
        gui.open();
        return gui;
    }

    public InteractiveGUI rankSelector(Consumer<InteractiveGUI> editor) {
        InteractiveGUI gui = GUIAccessor.prepare(this.player, "structures/nexus/ranks/rank-selector", RankEditor.getRankEdits(this.rank).withContext(this.kp.getOfflinePlayer()));
        if (gui == null) {
            return null;
        }
        ReusableOptionHandler holder = gui.getReusableOption("ranks");
        for (Rank copiedRank : this.group.getRanks().getSortedRanks().values()) {
            if (copiedRank.isKing() || copiedRank.equals(this.rank)) continue;
            holder.getSettings().addAll((Map)RankEditor.getRankEdits(copiedRank).getPlaceholders());
            ((ReusableOptionHandler)holder.editItem(item -> copiedRank.getMaterial().setType((ItemStack)item))).onNormalClicks(() -> {
                this.rank.setName(copiedRank.getName());
                this.rank.setColor(copiedRank.getColor());
                this.rank.setMaterial(copiedRank.getMaterial());
                this.rank.setMaxClaims(copiedRank.getMaxClaims());
                this.rank.setSymbol(copiedRank.getSymbol());
                this.rank.setPermissions(copiedRank.copyPermissions());
                KingdomsLang.NEXUS_RANK_EDITOR_COPY.sendMessage((CommandSender)this.player, "copy_node", copiedRank.getNode(), "rank_node", this.rank.getNode());
                this.openRankEditor(editor);
            }).done();
        }
        editor.accept(gui);
        gui.open();
        return gui;
    }
}

