/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.turrets;

import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomItem;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.TurretType;
import org.kingdoms.constants.land.turrets.objects.MineTurret;
import org.kingdoms.events.general.KingdomDisbandEvent;
import org.kingdoms.events.items.KingdomItemBreakEvent;
import org.kingdoms.events.items.KingdomItemPlaceEvent;
import org.kingdoms.events.lands.AsyncBatchLandLoadEvent;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.events.lands.LandUnloadEvent;
import org.kingdoms.events.lands.UnclaimLandEvent;
import org.kingdoms.managers.turrets.TurretFactory;

public final class LandTurretCacheOptimizerWatcher
implements Listener {
    private static boolean hasNoRangedTurrets(Land land) {
        for (Turret turret : land.getTurrets().values()) {
            if (!((TurretType)((TurretStyle)turret.getStyle()).getType()).isRanged()) continue;
            return false;
        }
        return true;
    }

    private static void cache(Land land) {
        TurretFactory.getTurretLands().put(land.getLocation(), land);
    }

    private static void uncache(SimpleChunkLocation chunkLocation) {
        TurretFactory.getTurretLands().remove(chunkLocation);
    }

    @EventHandler
    public void onLoad(AsyncBatchLandLoadEvent event) {
        for (Land land : event.getLands()) {
            if (!land.isClaimed() || LandTurretCacheOptimizerWatcher.hasNoRangedTurrets(land)) continue;
            LandTurretCacheOptimizerWatcher.cache(land);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onLandClaim(ClaimLandEvent event) {
        for (Land land : event.getLands()) {
            if (LandTurretCacheOptimizerWatcher.hasNoRangedTurrets(land)) continue;
            LandTurretCacheOptimizerWatcher.cache(land);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onTurretPlace(KingdomItemPlaceEvent<Turret> event) {
        if (!(event.getKingdomItem() instanceof Turret)) {
            return;
        }
        Turret turret = (Turret)event.getKingdomItem();
        if (turret instanceof MineTurret) {
            return;
        }
        Land land = ((Turret)event.getKingdomItem()).getLand();
        LandTurretCacheOptimizerWatcher.cache(land);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onTurretBreak(KingdomItemBreakEvent<?> event) {
        Land land = ((KingdomItem)event.getKingdomItem()).getLand();
        if (LandTurretCacheOptimizerWatcher.hasNoRangedTurrets(land)) {
            LandTurretCacheOptimizerWatcher.uncache(land.getLocation());
        }
    }

    @EventHandler
    public void onUnclaim(UnclaimLandEvent event) {
        for (SimpleChunkLocation loc : event.getLandLocations()) {
            LandTurretCacheOptimizerWatcher.uncache(loc);
        }
    }

    @EventHandler
    public void onUnload(LandUnloadEvent event) {
        LandTurretCacheOptimizerWatcher.uncache(event.getLand().getLocation());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onDisband(KingdomDisbandEvent event) {
        Kingdom kingdom = event.getKingdom();
        for (SimpleChunkLocation landLocation : kingdom.getLandLocations()) {
            LandTurretCacheOptimizerWatcher.uncache(landLocation);
        }
    }
}

