/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.services;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.ListenerPriority;
import github.scarsz.discordsrv.api.Subscribe;
import github.scarsz.discordsrv.api.events.DiscordReadyEvent;
import github.scarsz.discordsrv.dependencies.jda.api.EmbedBuilder;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageEmbed;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.MessageAction;
import github.scarsz.discordsrv.util.MessageUtil;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.KeyedYamlConfigAccessor;
import org.kingdoms.events.members.KingdomJoinEvent;
import org.kingdoms.events.members.KingdomLeaveEvent;
import org.kingdoms.events.members.NationJoinEvent;
import org.kingdoms.events.members.NationLeaveEvent;
import org.kingdoms.libs.snakeyaml.common.ScalarStyle;
import org.kingdoms.libs.snakeyaml.nodes.ScalarNode;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.services.Service;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.services.managers.SoftService;
import org.kingdoms.utils.ColorUtils;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.string.StringUtils;

public final class ServiceDiscordSRV
implements Listener,
Service {
    private static TextChannel privateChannel;
    private static TextChannel globalChannel;
    private static final KLogger LOGGER;
    private static boolean initialized;

    @Override
    public void enable() {
        ServiceHandler.addGlobalMessageHandler(ServiceDiscordSRV::logGlobalMessage);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Kingdoms.get());
        if (DiscordSRV.isReady) {
            LOGGER.log("Bot is already loaded and ready to use. Initializing DiscordSRV support...");
            ServiceDiscordSRV.init(false);
        } else {
            LOGGER.log("Waiting for the bot to finish loading...");
            DiscordSRV.api.subscribe((Object)this);
        }
    }

    public static void init(boolean forceInit) {
        if (!SoftService.DISCORDSRV.isAvailable()) {
            return;
        }
        if (initialized && !forceInit) {
            return;
        }
        MessageHandler.sendConsolePluginMessage("&2Initiating DiscordSRV support...");
        KeyedYamlConfigAccessor privateChanName = KingdomsConfig.Chat.DISCORDSRV_PRIVATE_CHANNEL.getManager();
        LOGGER.property((Object)"Private channel name", privateChanName.getString());
        if (!Strings.isNullOrEmpty((String)privateChanName.getString()) && (privateChannel = ServiceDiscordSRV.getChannelCheckSpecified(privateChanName)) == null) {
            MessageHandler.sendConsolePluginMessage("&cUnknown channel specified for DiscordSRV private channel&8: &e" + privateChanName.getNode().getWholeMark());
        }
        KeyedYamlConfigAccessor globalChannelOption = KingdomsConfig.Chat.DISCORDSRV_GLOBAL_CHANNEL.getManager();
        LOGGER.property((Object)"Global channel name", globalChannelOption.getString());
        if (!Strings.isNullOrEmpty((String)globalChannelOption.getString()) && (globalChannel = ServiceDiscordSRV.getChannelCheckSpecified(globalChannelOption)) == null) {
            MessageHandler.sendConsolePluginMessage("&cUnknown channel specified for DiscordSRV global channel&8: &e" + globalChannelOption.getNode().getWholeMark());
        }
        LOGGER.property((Object)"Webhook Support", ServiceDiscordSRV.isWebhookSupportEnabled());
        LOGGER.property((Object)"Main guild", DiscordSRV.getPlugin().getMainGuild().getName());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerJoinKingdom(KingdomJoinEvent event) {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)Kingdoms.get(), () -> ServiceHandler.announce(KingdomsConfig.Chat.DISCORDSRV_ANNOUNCEMENTS_KINGDOM_JOIN, (Supplier<MessageBuilder>)((Supplier)() -> new MessageBuilder().ignoreColors().withContext(event.getPlayer().getOfflinePlayer()))), 10L);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onLeaveKingdom(KingdomLeaveEvent event) {
        ServiceHandler.announce(KingdomsConfig.Chat.DISCORDSRV_ANNOUNCEMENTS_KINGDOM_LEAVE, (Supplier<MessageBuilder>)((Supplier)() -> new MessageBuilder().ignoreColors().raw("reason", event.getReason().name().toLowerCase()).withContext(event.getPlayer().getOfflinePlayer())));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void kingdomJoinNationEvent(NationJoinEvent event) {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)Kingdoms.get(), () -> ServiceHandler.announce(KingdomsConfig.Chat.DISCORDSRV_ANNOUNCEMENTS_NATION_JOIN, (Supplier<MessageBuilder>)((Supplier)() -> new MessageBuilder().ignoreColors().withContext(event.getNation()))), 10L);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void kingdomLeaveNationEvent(NationLeaveEvent event) {
        ServiceHandler.announce(KingdomsConfig.Chat.DISCORDSRV_ANNOUNCEMENTS_NATION_LEAVE, (Supplier<MessageBuilder>)((Supplier)() -> new MessageBuilder().ignoreColors().raw("reason", event.getReason().name().toLowerCase()).withContext(event.getKingdom())));
    }

    @Override
    public void disable() {
        LOGGER.log("Unsubscribing from API...");
        DiscordSRV.api.unsubscribe((Object)this);
    }

    public static void logGlobalMessage(Player player, String str) {
        ServiceDiscordSRV.sendMessage(globalChannel, player, str);
    }

    public static void logPrivateMessages(Player player, String str) {
        if (Objects.equals(DiscordSRV.getPlugin().getConsoleChannel(), privateChannel) && !ServiceDiscordSRV.isWebhookSupportEnabled()) {
            return;
        }
        ServiceDiscordSRV.sendMessage(privateChannel, player, str);
    }

    private static void sendMessage(TextChannel channel, Player sender, String msg) {
        if (channel == null) {
            LOGGER.log("Attempted to send msg '" + msg + "' from " + sender.getName() + " to a null channel.");
            return;
        }
        String translated = DiscordSRV.getPlugin().getDestinationGameChannelNameForTextChannel(channel);
        LOGGER.log(() -> "Player " + sender.getName() + " sent a message to translated DiscordSRV channel: " + channel + " -> " + translated + " with message: " + msg);
        DiscordSRV.getPlugin().processChatMessage(sender, MessageUtil.toComponent((String)msg, (boolean)true), translated, false, null);
    }

    static boolean isChannelSpecified(TextChannel channel) {
        return DiscordSRV.getPlugin().getChannels().containsValue(channel.getId());
    }

    public static TextChannel getChannelWithoutChecks(String str) {
        return ServiceDiscordSRV.getChannel0(str);
    }

    private static boolean isWebhookSupportEnabled() {
        return DiscordSRV.config().getBoolean("Experiment_WebhookChatMessageDelivery");
    }

    public static TextChannel getChannelCheckSpecified(KeyedYamlConfigAccessor option) {
        TextChannel chan = ServiceDiscordSRV.getChannel0(option.getString());
        if (chan == null) {
            return null;
        }
        if (!ServiceDiscordSRV.isChannelSpecified(chan)) {
            KLogger.warn("The channel '" + chan.getName() + "' (" + chan.getId() + ") cannot be used because it's not specified in DiscordSRV's 'Channels' config.yml option. For more information visit: https://github.com/CryptoMorin/KingdomsX/wiki/FAQ#why-is-in-game-chat-not-sent-to-discord\n" + option.getNode().getWholeMark());
        }
        return chan;
    }

    public static void sendMessage(TextChannel channel, ConfigSection section, MessageBuilder settings) {
        MessageAction msgAction;
        String strMsg;
        ConfigSection msg = section.getSection("message");
        if (msg == null) {
            strMsg = section.getString("message");
            if (strMsg == null) {
                KLogger.warn("Failed to send message to '" + channel.getName() + "' no message specified. If you want to disable this specific announcement, remove the channel instead.");
                return;
            }
        } else {
            strMsg = msg.getString("message");
        }
        MessageAction messageAction = msgAction = Strings.isNullOrEmpty((String)strMsg) ? null : channel.sendMessage((CharSequence)MessageCompiler.compile(strMsg).buildPlain(settings));
        if (msg != null) {
            MessageEmbed embed = ServiceDiscordSRV.buildEmbed(msg, settings);
            if (msgAction == null) {
                msgAction = channel.sendMessageEmbeds(embed, new MessageEmbed[0]);
            } else {
                msgAction.setEmbeds(new MessageEmbed[]{embed});
            }
        }
        if (msgAction != null) {
            msgAction.queue();
        }
    }

    public static MessageEmbed buildEmbed(ConfigSection section, MessageBuilder settings) {
        ConfigSection fields;
        ConfigSection footer;
        ConfigSection author;
        String desc;
        EmbedBuilder eb = new EmbedBuilder();
        Function translate = msg -> {
            if (Strings.isNullOrEmpty((String)msg)) {
                return null;
            }
            return Strings.isNullOrEmpty((String)(msg = MessageCompiler.compile(msg).buildPlain(settings))) ? null : msg;
        };
        ConfigSection title = section.getSection("title");
        if (title != null) {
            eb.setTitle((String)translate.apply((Object)title.getString("text")), (String)translate.apply((Object)title.getString("url")));
        }
        if ((desc = (String)translate.apply((Object)section.getString("description"))) == null || desc.trim().isEmpty()) {
            desc = "Description option is missing. It's required and it should not be empty.";
        }
        eb.setDescription((CharSequence)desc);
        eb.setThumbnail((String)translate.apply((Object)section.getString("thumbnail")));
        eb.setImage((String)translate.apply((Object)section.getString("image")));
        String color = section.getString("color");
        if (color != null) {
            eb.setColor(ColorUtils.parseColor(color));
        }
        if ((author = section.getSection("author")) != null) {
            eb.setAuthor((String)translate.apply((Object)author.getString("name")), (String)translate.apply((Object)author.getString("url")), (String)translate.apply((Object)author.getString("icon")));
        }
        if ((footer = section.getSection("footer")) != null) {
            eb.setFooter((String)translate.apply((Object)footer.getString("text")), (String)translate.apply((Object)footer.getString("icon")));
        }
        if ((fields = section.getSection("fields")) != null) {
            for (String field : fields.getKeys()) {
                String fieldDesc = fields.getString(field);
                if (fieldDesc == null) continue;
                ScalarNode node = (ScalarNode)fields.getNode(field);
                boolean inline = node.getScalarStyle() == ScalarStyle.SINGLE_QUOTED;
                eb.addField((String)translate.apply((Object)field), (String)translate.apply((Object)fieldDesc), inline);
            }
        }
        return eb.build();
    }

    static TextChannel getChannel0(String str) {
        TextChannel channel = ServiceDiscordSRV.getChannel00(str);
        if (channel == null) {
            return null;
        }
        if (DiscordSRV.getPlugin().getJda().getGuildCache().size() > 1L) {
            KLogger.debug((DebugNS)KingdomsDebug.DISCORDSRV, () -> "DiscordSRV bot is in multiple servers. Chosen channel: " + channel.getGuild() + " -> " + channel);
        }
        return channel;
    }

    static TextChannel getChannel00(String str) {
        if (str.equalsIgnoreCase("$console")) {
            TextChannel console = DiscordSRV.getPlugin().getConsoleChannel();
            if (console == null) {
                MessageHandler.sendConsolePluginMessage("&cUnable to find the console channel for DiscordSRV.");
            }
            return console;
        }
        if (str.equalsIgnoreCase("$main")) {
            TextChannel chat = DiscordSRV.getPlugin().getMainTextChannel();
            if (chat == null) {
                MessageHandler.sendConsolePluginMessage("&cUnable to find the main chat channel for DiscordSRV.");
            }
            return chat;
        }
        Guild guild = DiscordSRV.getPlugin().getMainGuild();
        int len = str.length();
        if (len > 15 && len < 20 && StringUtils.isPureNumber(str)) {
            TextChannel chan = guild.getTextChannelById(Long.parseLong(str));
            if (chan == null) {
                LOGGER.log("No channel was found with id '" + str + "' in guild.");
            }
            return chan;
        }
        List chans = guild.getTextChannelsByName(str, true);
        if (chans.isEmpty()) {
            LOGGER.log("No channel was found with name '" + str + "' in guild.");
            return null;
        }
        return Objects.requireNonNull((TextChannel)chans.get(0));
    }

    @Subscribe(priority=ListenerPriority.MONITOR)
    public void onBotLoad(DiscordReadyEvent event) {
        LOGGER.property((Object)"Ready", true);
        ServiceDiscordSRV.init(false);
    }

    static {
        LOGGER = new KLogger(KingdomsDebug.DISCORDSRV);
        initialized = false;
    }
}

