/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.kingdoms.constants.land.location.SimpleChunkLocation;

public final class LandUtil {
    public static Collection<Set<SimpleChunkLocation>> getConnectedClusters(int radius, Set<SimpleChunkLocation> chunks) {
        ArrayList<Set<SimpleChunkLocation>> clusters = new ArrayList<Set<SimpleChunkLocation>>(5);
        HashSet<SimpleChunkLocation> checked = new HashSet<SimpleChunkLocation>(chunks.size());
        for (SimpleChunkLocation chunk : chunks) {
            if (checked.contains(chunk)) continue;
            HashSet<SimpleChunkLocation> cluster = new HashSet<SimpleChunkLocation>(10);
            LandUtil.checkChunksForConnection(radius, chunk, chunks, cluster, checked);
            clusters.add(cluster);
        }
        return clusters;
    }

    private static void checkChunksForConnection(int radius, SimpleChunkLocation chunk, Set<SimpleChunkLocation> chunks, Set<SimpleChunkLocation> cluster, Set<SimpleChunkLocation> checked) {
        for (SimpleChunkLocation around : chunk.getChunksAround(radius)) {
            if (!chunks.contains(around)) continue;
            checked.add(around);
            if (!cluster.add(around)) continue;
            LandUtil.checkChunksForConnection(radius, around, chunks, cluster, checked);
        }
    }
}

