/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.NumberConversions;
import org.kingdoms.libs.xseries.ReflectionUtils;
import org.kingdoms.utils.Validate;

public final class Laser {
    private static final String TEAM = "kingdoms";
    private static final String COLLISION_RULE = "never";
    private static final AtomicInteger TEAM_ID = new AtomicInteger();
    private static final AtomicInteger LAST_ISSUED_EID = new AtomicInteger(2000000000);
    private final int duration;
    private final int distanceSquared;
    private final Object createGuardianPacket;
    private final Object createSquidPacket;
    private final Object destroyPacket;
    private final Object metadataPacketGuardian;
    private final Object metadataPacketSquid;
    private final Object fakeGuardianDataWatcher;
    private final Object teamCreatePacket;
    private final Map<UUID, Player> players = new ConcurrentHashMap<UUID, Player>(10);
    private final Set<Integer> seen = new HashSet<Integer>();
    private final NMSEntityInfo squid;
    private final NMSEntityInfo guardian;
    private Location start;
    private Location lastEndLocation;
    private Supplier<Location> endLocationTracker;
    private BukkitRunnable run;

    public Laser(Location start, Supplier<Location> endLocationTracker, int duration, int distance) throws ReflectiveOperationException {
        Object guardian;
        Object squid;
        Location end = endLocationTracker.get();
        if (start.getWorld() != end.getWorld()) {
            throw new IllegalArgumentException("Laser start world is different from the end location: " + start.getWorld() + " - " + end.getWorld());
        }
        this.start = start;
        this.endLocationTracker = endLocationTracker;
        this.duration = duration;
        this.distanceSquared = distance * distance;
        if (ReflectionUtils.supports(17)) {
            squid = NMSReflection.createSquid(end);
            this.createSquidPacket = NMSReflection.createPacketEntitySpawn(squid);
        } else {
            squid = null;
            this.createSquidPacket = NMSReflection.createSpawnPacket(end, NMSReflection.SQUID_TYPE);
        }
        String UUIDFieldName = ReflectionUtils.v(19, "d").orElse("b");
        String EntityIdFieldName = ReflectionUtils.v(19, "c").orElse("a");
        UUID squidUUID = (UUID)NMSReflection.getField(UUIDFieldName, this.createSquidPacket);
        int squidId = (Integer)NMSReflection.getField(EntityIdFieldName, this.createSquidPacket);
        this.squid = new NMSEntityInfo(squid, squidUUID, squidId);
        this.metadataPacketSquid = NMSReflection.createPacketMetadata(squidId, NMSReflection.fakeSquidWatcher);
        NMSReflection.setDirtyWatcher(NMSReflection.fakeSquidWatcher);
        this.fakeGuardianDataWatcher = NMSReflection.createFakeDataWatcher();
        NMSReflection.initGuardianWatcher(this.fakeGuardianDataWatcher, squidId);
        if (ReflectionUtils.supports(17)) {
            guardian = NMSReflection.createGuardian(start);
            this.createGuardianPacket = NMSReflection.createPacketEntitySpawn(guardian);
        } else {
            guardian = null;
            this.createGuardianPacket = NMSReflection.createSpawnPacket(start, NMSReflection.GUARDIAN_TYPE);
        }
        UUID guardianUUID = (UUID)NMSReflection.getField(UUIDFieldName, this.createGuardianPacket);
        int guardianId = (Integer)NMSReflection.getField(EntityIdFieldName, this.createGuardianPacket);
        this.guardian = new NMSEntityInfo(guardian, guardianUUID, guardianId);
        this.metadataPacketGuardian = NMSReflection.createPacketMetadata(guardianId, this.fakeGuardianDataWatcher);
        this.teamCreatePacket = NMSReflection.createPacketTeamAddEntities(squidUUID, guardianUUID);
        this.destroyPacket = NMSReflection.createPacketRemoveEntities(squidId, guardianId);
    }

    private static double distanceSquared(Location start, Location location) {
        return NumberConversions.square((double)(start.getX() - location.getX())) + NumberConversions.square((double)(start.getY() - location.getY())) + NumberConversions.square((double)(start.getZ() - location.getZ()));
    }

    public void start(final Plugin plugin) {
        if (this.run != null) {
            throw new IllegalStateException("Laser is already started");
        }
        this.run = new BukkitRunnable(){
            final World world;
            int time;
            {
                this.world = Laser.this.start.getWorld();
                this.time = Laser.this.duration;
            }

            public void run() {
                for (Player player : this.world.getPlayers()) {
                    if (Laser.this.isCloseEnough(player.getLocation())) {
                        if (Laser.this.players.put(player.getUniqueId(), player) != null) continue;
                        Laser.this.sendStartPackets(plugin, player, !Laser.this.seen.add(player.getEntityId()));
                        continue;
                    }
                    if (Laser.this.players.remove(player.getUniqueId()) == null) continue;
                    Laser.this.destroy(player);
                }
                if (--this.time == 0) {
                    this.cancel();
                }
                try {
                    Location end = Laser.this.getEndLocation();
                    if (end != null) {
                        Object packet = NMSReflection.teleport(Laser.this.squid, end);
                        for (Player player : Laser.this.players.values()) {
                            ReflectionUtils.sendPacket(player, packet);
                        }
                    }
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }

            public synchronized void cancel() throws IllegalStateException {
                super.cancel();
                Laser.this.run = null;
                for (Player player : Laser.this.players.values()) {
                    Laser.this.destroy(player);
                }
                Laser.this.players.clear();
            }
        };
        this.run.runTaskTimerAsynchronously(plugin, 0L, 20L);
    }

    public void destroy(Player player) {
        ReflectionUtils.sendPacket(player, this.destroyPacket);
    }

    public void clear() {
        this.players.clear();
    }

    public void stop() {
        Validate.isTrue(this.run != null, "Laser not started");
        this.run.cancel();
    }

    public void moveStart(Location location) throws ReflectiveOperationException {
        this.start = location;
        Object packet = NMSReflection.teleport(this.guardian, this.start);
        for (Player player : this.players.values()) {
            ReflectionUtils.sendPacket(player, packet);
        }
    }

    public Location getStart() {
        return this.start;
    }

    public void moveEnd(Supplier<Location> endLocationTracker) throws ReflectiveOperationException {
        this.endLocationTracker = endLocationTracker;
    }

    public void callColorChange() {
        for (Player player : this.players.values()) {
            ReflectionUtils.sendPacket(player, this.metadataPacketGuardian);
        }
    }

    public boolean isStarted() {
        return this.run != null;
    }

    private void sendStartPackets(Plugin plugin, Player player, boolean hasSeen) {
        ArrayList<Object> packets = new ArrayList<Object>(6);
        Bukkit.getScheduler().runTaskLaterAsynchronously(plugin, () -> {
            Location end;
            packets.clear();
            packets.add(this.createGuardianPacket);
            if (ReflectionUtils.supports(15)) {
                packets.add(this.metadataPacketGuardian);
            }
            if (!hasSeen) {
                packets.add(this.teamCreatePacket);
            }
            if ((end = this.getEndLocation()) != null) {
                try {
                    packets.add(NMSReflection.teleport(this.squid, end));
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
            ReflectionUtils.sendPacketSync(player, packets.toArray());
        }, 5L);
        packets.add(this.createSquidPacket);
        if (ReflectionUtils.supports(15)) {
            packets.add(this.metadataPacketSquid);
        }
        ReflectionUtils.sendPacketSync(player, packets.toArray());
    }

    private boolean isCloseEnough(Location location) {
        return Laser.distanceSquared(this.start, location) <= (double)this.distanceSquared || this.lastEndLocation != null && Laser.distanceSquared(this.lastEndLocation, location) <= (double)this.distanceSquared;
    }

    private Location getEndLocation() {
        Location end = this.endLocationTracker.get();
        return end == null ? this.lastEndLocation : (this.lastEndLocation = end);
    }

    private static final class NMSEntityInfo {
        private final Object entity;
        private final UUID uuid;
        private final int id;

        private NMSEntityInfo(Object entity, UUID uuid, int id) {
            this.entity = entity;
            this.uuid = uuid;
            this.id = id;
        }
    }

    private static final class NMSReflection {
        private static final MethodHandle PACKET_SPAWN;
        private static final MethodHandle SET_LOCATION;
        private static final Object NMS_WORLD;
        private static final int TEAM_METHOD_ADD = 3;
        private static final Class<?> packetRemove;
        private static final Class<?> packetTeleport;
        private static final Class<?> packetTeam;
        private static final Class<?> packetMetadata;
        private static Constructor<?> watcherConstructor;
        private static Method watcherSet;
        private static Method watcherRegister;
        private static Method watcherDirty;
        private static Method watcherPack;
        private static Object WATCHER_INVISILIBITY;
        private static Object WATCHER_SPIKES;
        private static Object WATCHER_ATTACK_ID;
        private static Object SQUID_TYPE;
        private static Object GUARDIAN_TYPE;
        private static Object fakeSquid;
        private static Object fakeSquidWatcher;

        private NMSReflection() {
        }

        private static int generateEID() {
            return LAST_ISSUED_EID.getAndIncrement();
        }

        public static Object createFakeDataWatcher() throws ReflectiveOperationException {
            Object watcher = watcherConstructor.newInstance(fakeSquid);
            if (ReflectionUtils.supports(14)) {
                NMSReflection.setField(watcher, "registrationLocked", false);
            }
            return watcher;
        }

        public static void setDirtyWatcher(Object watcher) throws ReflectiveOperationException {
            if (ReflectionUtils.supports(15)) {
                watcherDirty.invoke(watcher, WATCHER_INVISILIBITY);
            }
        }

        public static Object createSquid(Location location) throws ReflectiveOperationException {
            Object entity = ReflectionUtils.getNMSClass("world.entity.animal", "EntitySquid").getDeclaredConstructors()[0].newInstance(SQUID_TYPE, NMS_WORLD);
            NMSReflection.setLocation(entity, location);
            return entity;
        }

        public static Object createGuardian(Location location) throws ReflectiveOperationException {
            Object entity = ReflectionUtils.getNMSClass("world.entity.monster", "EntityGuardian").getDeclaredConstructors()[0].newInstance(GUARDIAN_TYPE, NMS_WORLD);
            NMSReflection.setLocation(entity, location);
            return entity;
        }

        public static Object createSpawnPacket(Location location, Object entityType) {
            try {
                Object packet = PACKET_SPAWN.invoke();
                NMSReflection.setField(packet, "a", NMSReflection.generateEID());
                NMSReflection.setField(packet, "b", UUID.randomUUID());
                NMSReflection.setField(packet, "c", entityType);
                NMSReflection.setField(packet, "d", location.getX());
                NMSReflection.setField(packet, "e", location.getY());
                NMSReflection.setField(packet, "f", location.getZ());
                NMSReflection.setField(packet, "j", (byte)(location.getYaw() * 256.0f / 360.0f));
                NMSReflection.setField(packet, "k", (byte)(location.getPitch() * 256.0f / 360.0f));
                if (!ReflectionUtils.supports(15)) {
                    NMSReflection.setField(packet, "m", fakeSquidWatcher);
                }
                return packet;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public static void initGuardianWatcher(Object watcher, int squidId) throws ReflectiveOperationException {
            NMSReflection.tryWatcherSet(watcher, WATCHER_INVISILIBITY, (byte)32);
            NMSReflection.tryWatcherSet(watcher, WATCHER_SPIKES, false);
            NMSReflection.tryWatcherSet(watcher, WATCHER_ATTACK_ID, squidId);
        }

        public static Object createPacketEntitySpawn(Object entity) {
            try {
                return PACKET_SPAWN.invoke(entity);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public static Object createPacketRemoveEntities(int squidId, int guardianId) throws ReflectiveOperationException {
            if (ReflectionUtils.supports(17)) {
                Constructor<?> ctor = packetRemove.getConstructor(int[].class);
                return ctor.newInstance(new Object[]{new int[]{squidId, guardianId}});
            }
            Object packet = packetRemove.newInstance();
            NMSReflection.setField(packet, "a", new int[]{squidId, guardianId});
            return packet;
        }

        public static void setLocation(Object entity, Location location) {
            try {
                SET_LOCATION.invoke(entity, location.getX(), location.getY(), location.getZ(), location.getPitch(), location.getYaw());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        public static Object createPacketTeamAddEntities(UUID squidUUID, UUID guardianUUID) throws ReflectiveOperationException {
            Object packet;
            String id = Laser.TEAM + TEAM_ID.getAndIncrement();
            if (ReflectionUtils.supports(17)) {
                ArrayList<String> players = new ArrayList<String>(2);
                players.add(squidUUID.toString());
                players.add(guardianUUID.toString());
                Constructor<?> ctor = packetTeam.getDeclaredConstructor(String.class, Integer.TYPE, Optional.class, Collection.class);
                ctor.setAccessible(true);
                packet = ctor.newInstance(id, 3, Optional.empty(), players);
            } else {
                packet = packetTeam.newInstance();
                NMSReflection.setField(packet, "a", id);
                NMSReflection.setField(packet, "f", Laser.COLLISION_RULE);
                NMSReflection.setField(packet, "i", 3);
                Collection players = (Collection)NMSReflection.getField(packetTeam, "h", packet);
                players.add(squidUUID.toString());
                players.add(guardianUUID.toString());
            }
            return packet;
        }

        public static Object teleport(NMSEntityInfo entityInfo, Location location) throws ReflectiveOperationException {
            Object packet;
            if (ReflectionUtils.supports(17)) {
                try {
                    NMSReflection.setLocation(entityInfo.entity, location);
                    packet = packetTeleport.getConstructor(ReflectionUtils.getNMSClass("world.entity", "Entity")).newInstance(entityInfo.entity);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    return null;
                }
            } else {
                packet = packetTeleport.newInstance();
                NMSReflection.setField(packet, "a", entityInfo.id);
                NMSReflection.setField(packet, "b", location.getX());
                NMSReflection.setField(packet, "c", location.getY());
                NMSReflection.setField(packet, "d", location.getZ());
                NMSReflection.setField(packet, "e", (byte)(location.getYaw() * 256.0f / 360.0f));
                NMSReflection.setField(packet, "f", (byte)(location.getPitch() * 256.0f / 360.0f));
                NMSReflection.setField(packet, "g", true);
            }
            return packet;
        }

        private static Object createPacketMetadata(int entityId, Object watcher) throws ReflectiveOperationException {
            if (ReflectionUtils.supports(19)) {
                return packetMetadata.getConstructor(Integer.TYPE, List.class).newInstance(entityId, watcherPack.invoke(watcher, new Object[0]));
            }
            return packetMetadata.getConstructor(Integer.TYPE, watcher.getClass(), Boolean.TYPE).newInstance(entityId, watcher, false);
        }

        private static void tryWatcherSet(Object watcher, Object watcherObject, Object watcherData) throws ReflectiveOperationException {
            block2: {
                try {
                    watcherSet.invoke(watcher, watcherObject, watcherData);
                }
                catch (InvocationTargetException ex) {
                    watcherRegister.invoke(watcher, watcherObject, watcherData);
                    if (!ReflectionUtils.supports(15)) break block2;
                    watcherDirty.invoke(watcher, watcherObject);
                }
            }
        }

        private static Method getMethodIgnoreParams(Class<?> clazz, String name) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(name)) continue;
                return method;
            }
            return null;
        }

        private static Method getMethodStarting(Class<?> clazz, String name, MethodType type) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(name) || method.getReturnType() != type.returnType()) continue;
                if (type.parameterCount() != 0 && type.parameterCount() <= method.getParameterCount()) {
                    int i = 0;
                    Parameter[] params = method.getParameters();
                    for (Class<?> param : type.parameterArray()) {
                        if (params[i++].getType() == param) continue;
                        i = -1;
                        break;
                    }
                    if (i == -1) continue;
                }
                method.setAccessible(true);
                return method;
            }
            return null;
        }

        private static void setField(Object instance, String name, Object value) throws ReflectiveOperationException {
            Field field = instance.getClass().getDeclaredField(name);
            field.setAccessible(true);
            field.set(instance, value);
        }

        private static Object getField(Class<?> clazz, String name, Object instance) throws ReflectiveOperationException {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field.get(instance);
        }

        private static Object getField(String name, Object instance) throws ReflectiveOperationException {
            return NMSReflection.getField(instance.getClass(), name, instance);
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Object nmsWorld = null;
            MethodHandle setLocation = null;
            MethodHandle packetSpawn = null;
            Class<?> craftWorld = ReflectionUtils.getCraftClass("CraftWorld");
            Class<?> entity = ReflectionUtils.getNMSClass("world.entity", "Entity");
            Class<?> entityLiving = ReflectionUtils.getNMSClass("world.entity", "EntityLiving");
            Class<?> guardian = ReflectionUtils.getNMSClass("world.entity.monster", "EntityGuardian");
            Class<?> squid = ReflectionUtils.getNMSClass("world.entity.animal", "EntitySquid");
            Class<?> craftSquid = ReflectionUtils.getCraftClass("entity.CraftSquid");
            Class<?> dataWatcher = ReflectionUtils.getNMSClass("network.syncher", "DataWatcher");
            Class<?> dataWatcherObject = ReflectionUtils.getNMSClass("network.syncher", "DataWatcherObject");
            Class<?> entityTypes = ReflectionUtils.getNMSClass("world.entity", "EntityTypes");
            Class<?> packetSpawnClass = ReflectionUtils.getNMSClass("network.protocol.game", ReflectionUtils.v(19, "PacketPlayOutSpawnEntity").orElse("PacketPlayOutSpawnEntityLiving"));
            packetRemove = ReflectionUtils.getNMSClass("network.protocol.game", "PacketPlayOutEntityDestroy");
            packetTeleport = ReflectionUtils.getNMSClass("network.protocol.game", "PacketPlayOutEntityTeleport");
            packetTeam = ReflectionUtils.getNMSClass("network.protocol.game", "PacketPlayOutScoreboardTeam");
            packetMetadata = ReflectionUtils.getNMSClass("network.protocol.game", "PacketPlayOutEntityMetadata");
            try {
                Object[] objectArray;
                String watcherAttacker;
                String watcherSpikes;
                String watcherInvis;
                if (ReflectionUtils.VER < 13) {
                    watcherInvis = "Z";
                    watcherSpikes = "bA";
                    watcherAttacker = "bB";
                    SQUID_TYPE = 94;
                    GUARDIAN_TYPE = 68;
                } else if (ReflectionUtils.VER == 13) {
                    watcherInvis = "ac";
                    watcherSpikes = "bF";
                    watcherAttacker = "bG";
                    SQUID_TYPE = 70;
                    GUARDIAN_TYPE = 28;
                } else if (ReflectionUtils.VER == 14) {
                    watcherInvis = "W";
                    watcherSpikes = "b";
                    watcherAttacker = "bD";
                    SQUID_TYPE = 73;
                    GUARDIAN_TYPE = 30;
                } else if (ReflectionUtils.VER == 15) {
                    watcherInvis = "T";
                    watcherSpikes = "b";
                    watcherAttacker = "bA";
                    SQUID_TYPE = 74;
                    GUARDIAN_TYPE = 31;
                } else if (ReflectionUtils.VER == 16) {
                    watcherInvis = "S";
                    watcherSpikes = "b";
                    watcherAttacker = "d";
                    SQUID_TYPE = 74;
                    GUARDIAN_TYPE = 31;
                } else if (ReflectionUtils.VER == 17) {
                    watcherInvis = "Z";
                    watcherSpikes = "b";
                    watcherAttacker = "e";
                    SQUID_TYPE = entityTypes.getDeclaredField("aJ").get(null);
                    GUARDIAN_TYPE = entityTypes.getDeclaredField("K").get(null);
                } else if (ReflectionUtils.VER == 18) {
                    watcherInvis = "Z";
                    watcherSpikes = "b";
                    watcherAttacker = "e";
                    SQUID_TYPE = entityTypes.getDeclaredField("aJ").get(null);
                    GUARDIAN_TYPE = entityTypes.getDeclaredField("K").get(null);
                } else {
                    watcherInvis = "an";
                    watcherSpikes = "b";
                    watcherAttacker = "e";
                    SQUID_TYPE = entityTypes.getDeclaredField("aT").get(null);
                    GUARDIAN_TYPE = entityTypes.getDeclaredField("V").get(null);
                }
                WATCHER_INVISILIBITY = NMSReflection.getField(entity, watcherInvis, null);
                WATCHER_SPIKES = NMSReflection.getField(guardian, watcherSpikes, null);
                WATCHER_ATTACK_ID = NMSReflection.getField(guardian, watcherAttacker, null);
                nmsWorld = craftWorld.getDeclaredMethod("getHandle", new Class[0]).invoke(Bukkit.getWorlds().get(0), new Object[0]);
                watcherConstructor = dataWatcher.getDeclaredConstructor(entity);
                watcherSet = dataWatcher.getDeclaredMethod(ReflectionUtils.v(18, "b").orElse("set"), dataWatcherObject, Object.class);
                watcherRegister = dataWatcher.getDeclaredMethod(ReflectionUtils.v(18, "a").orElse("register"), dataWatcherObject, Object.class);
                if (ReflectionUtils.supports(15)) {
                    watcherDirty = NMSReflection.getMethodIgnoreParams(dataWatcher, "markDirty");
                }
                if (ReflectionUtils.supports(19)) {
                    watcherPack = dataWatcher.getDeclaredMethod("b", new Class[0]);
                }
                packetSpawn = lookup.findConstructor(packetSpawnClass, ReflectionUtils.v(19, MethodType.methodType(Void.TYPE, entity)).v(17, MethodType.methodType(Void.TYPE, entityLiving)).orElse(MethodType.methodType(Void.TYPE)));
                if (ReflectionUtils.supports(17)) {
                    setLocation = lookup.findVirtual(entity, ReflectionUtils.v(18, "a").orElse("setLocation"), MethodType.methodType(Void.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE));
                }
                if (ReflectionUtils.supports(14)) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = ReflectionUtils.supports(17) ? SQUID_TYPE : entityTypes.getDeclaredField("SQUID").get(null);
                    objectArray = objectArray2;
                    objectArray2[1] = nmsWorld;
                } else {
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = nmsWorld;
                }
                Object[] entityConstructorParams = objectArray;
                fakeSquid = ReflectionUtils.getNMSClass("world.entity.animal", "EntitySquid").getDeclaredConstructors()[0].newInstance(entityConstructorParams);
                fakeSquidWatcher = NMSReflection.createFakeDataWatcher();
                NMSReflection.tryWatcherSet(fakeSquidWatcher, WATCHER_INVISILIBITY, (byte)32);
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
            NMS_WORLD = nmsWorld;
            SET_LOCATION = setLocation;
            PACKET_SPAWN = packetSpawn;
        }
    }
}

