/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.NoWhenBranchMatchedException;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.nbt.ItemNBT;
import org.kingdoms.utils.nbt.NBTWrappers;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lorg/kingdoms/utils/NBTItemDeserializer;", "", "()V", "deserialize", "Lorg/bukkit/inventory/ItemStack;", "section", "Lorg/kingdoms/utils/config/ConfigSection;", "deserializeNBT", "Lorg/kingdoms/utils/nbt/NBTWrappers$NBTBase;", "NBTType", "core"})
public final class NBTItemDeserializer {
    @NotNull
    public static final NBTItemDeserializer INSTANCE = new NBTItemDeserializer();

    private NBTItemDeserializer() {
    }

    @NotNull
    public final ItemStack deserialize(@NotNull ConfigSection section) {
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        ItemStack itemStack = XItemStack.deserialize(section.toBukkitConfigurationSection());
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"deserialize(section.toBu\u2026itConfigurationSection())");
        ItemStack item = itemStack;
        String[] stringArray = new String[]{"nbt"};
        ConfigSection configSection = section.getSection(stringArray);
        if (configSection == null) {
            return item;
        }
        ConfigSection nbt = configSection;
        NBTWrappers.NBTTagCompound root = ItemNBT.getTag(item);
        Map<String, ConfigSection> map = nbt.getSections();
        Intrinsics.checkNotNullExpressionValue(map, (String)"nbt.sections");
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            ConfigSection value = (ConfigSection)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            root.set(key, this.deserializeNBT(value));
        }
        ItemStack itemStack2 = ItemNBT.setTag(item, root);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"setTag(item, root)");
        return itemStack2;
    }

    /*
     * WARNING - void declaration
     */
    private final NBTWrappers.NBTBase<?> deserializeNBT(ConfigSection section) {
        NBTWrappers.NBTBase nBTBase;
        String string = section.getString("type");
        Intrinsics.checkNotNull((Object)string);
        switch (WhenMappings.$EnumSwitchMapping$0[NBTType.valueOf(string).ordinal()]) {
            case 1: {
                nBTBase = new NBTWrappers.NBTTagString(section.getString("value"));
                break;
            }
            case 2: {
                String[] stringArray = new String[]{"value"};
                nBTBase = new NBTWrappers.NBTTagByte((byte)section.getInt(stringArray));
                break;
            }
            case 3: {
                String[] stringArray = new String[]{"value"};
                nBTBase = new NBTWrappers.NBTTagShort((short)section.getInt(stringArray));
                break;
            }
            case 4: {
                String[] stringArray = new String[]{"value"};
                nBTBase = new NBTWrappers.NBTTagInt(section.getInt(stringArray));
                break;
            }
            case 5: {
                String[] stringArray = new String[]{"value"};
                nBTBase = new NBTWrappers.NBTTagFloat(section.getFloat(stringArray));
                break;
            }
            case 6: {
                String[] stringArray = new String[]{"value"};
                nBTBase = new NBTWrappers.NBTTagLong(section.getLong(stringArray));
                break;
            }
            case 7: {
                String[] stringArray = new String[]{"value"};
                nBTBase = new NBTWrappers.NBTTagDouble(section.getDouble(stringArray));
                break;
            }
            case 8: {
                void $this$mapTo$iv$iv;
                String[] stringArray = new String[]{"value"};
                List<Integer> list2 = section.getIntegerList(stringArray);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"section.getIntegerList(\"value\")");
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void x;
                    Integer n = (Integer)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((byte)x.intValue());
                }
                byte[] byArray = CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
                nBTBase = new NBTWrappers.NBTTagByteArray(byArray);
                break;
            }
            case 9: {
                String[] stringArray = new String[]{"value"};
                List<Integer> list3 = section.getIntegerList(stringArray);
                Intrinsics.checkNotNullExpressionValue(list3, (String)"section.getIntegerList(\"value\")");
                nBTBase = new NBTWrappers.NBTTagIntArray(CollectionsKt.toIntArray((Collection)list3));
                break;
            }
            case 10: {
                nBTBase = new NBTWrappers.NBTTagShort(0);
                break;
            }
            case 11: {
                String[] stringArray = new String[]{"value"};
                ConfigSection configSection = section.getSection(stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)configSection, (String)"section.getSection(\"value\")");
                nBTBase = this.deserializeNBT(configSection);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return nBTBase;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\r\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/utils/NBTItemDeserializer$NBTType;", "", "(Ljava/lang/String;I)V", "STRING", "BYTE", "SHORT", "INT", "FLOAT", "LONG", "DOUBLE", "VOID", "COMPOUND", "BYTE_ARRAY", "INT_ARRAY", "core"})
    private static final class NBTType
    extends Enum<NBTType> {
        public static final /* enum */ NBTType STRING = new NBTType();
        public static final /* enum */ NBTType BYTE = new NBTType();
        public static final /* enum */ NBTType SHORT = new NBTType();
        public static final /* enum */ NBTType INT = new NBTType();
        public static final /* enum */ NBTType FLOAT = new NBTType();
        public static final /* enum */ NBTType LONG = new NBTType();
        public static final /* enum */ NBTType DOUBLE = new NBTType();
        public static final /* enum */ NBTType VOID = new NBTType();
        public static final /* enum */ NBTType COMPOUND = new NBTType();
        public static final /* enum */ NBTType BYTE_ARRAY = new NBTType();
        public static final /* enum */ NBTType INT_ARRAY = new NBTType();
        private static final /* synthetic */ NBTType[] $VALUES;

        public static NBTType[] values() {
            return (NBTType[])$VALUES.clone();
        }

        public static NBTType valueOf(String value) {
            return Enum.valueOf(NBTType.class, value);
        }

        static {
            $VALUES = nBTTypeArray = new NBTType[]{NBTType.STRING, NBTType.BYTE, NBTType.SHORT, NBTType.INT, NBTType.FLOAT, NBTType.LONG, NBTType.DOUBLE, NBTType.VOID, NBTType.COMPOUND, NBTType.BYTE_ARRAY, NBTType.INT_ARRAY};
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NBTType.values().length];
            nArray[NBTType.STRING.ordinal()] = 1;
            nArray[NBTType.BYTE.ordinal()] = 2;
            nArray[NBTType.SHORT.ordinal()] = 3;
            nArray[NBTType.INT.ordinal()] = 4;
            nArray[NBTType.FLOAT.ordinal()] = 5;
            nArray[NBTType.LONG.ordinal()] = 6;
            nArray[NBTType.DOUBLE.ordinal()] = 7;
            nArray[NBTType.BYTE_ARRAY.ordinal()] = 8;
            nArray[NBTType.INT_ARRAY.ordinal()] = 9;
            nArray[NBTType.VOID.ordinal()] = 10;
            nArray[NBTType.COMPOUND.ordinal()] = 11;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

