/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.cooldown;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class LazyCooldown {
    private static final Map<String, LazyCooldown> COOLDOWNS = new HashMap<String, LazyCooldown>();
    private final long time;
    private final long start;

    public LazyCooldown(Object id, String name, long time, TimeUnit timeUnit) {
        this.time = timeUnit.toMillis(time);
        this.start = System.currentTimeMillis();
        COOLDOWNS.put(id + name, this);
    }

    public LazyCooldown(Object id, String name, long time) {
        this(id, name, time, TimeUnit.MILLISECONDS);
    }

    public static boolean isInCooldown(Object id, String name) {
        return LazyCooldown.getTimeLeft(id, name) != 0L;
    }

    public static LazyCooldown stop(Object id, String name) {
        return COOLDOWNS.remove(id + name);
    }

    public static LazyCooldown getCooldown(Object id, String name) {
        return COOLDOWNS.get(id + name);
    }

    public static long getTimeLeft(Object id, String name) {
        LazyCooldown cooldown = LazyCooldown.getCooldown(id, name);
        if (cooldown == null) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        long difference = now - cooldown.start;
        if (difference >= cooldown.time) {
            LazyCooldown.stop(id, name);
            return 0L;
        }
        return cooldown.time - difference;
    }
}

