/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal;

import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;

public class QuantumHashSet<K>
extends AbstractSet<K>
implements Cloneable {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int TREEIFY_THRESHOLD = 8;
    static final int UNTREEIFY_THRESHOLD = 6;
    static final int MIN_TREEIFY_CAPACITY = 64;
    final float loadFactor;
    transient Node<K>[] table;
    transient int size;
    transient int modCount;
    int threshold;

    public QuantumHashSet(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        this.threshold = QuantumHashSet.tableSizeFor(initialCapacity);
    }

    public QuantumHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public QuantumHashSet() {
        this.loadFactor = 0.75f;
    }

    public static int hash(Object key) {
        if (key == null) {
            throw new NullPointerException("Cannot hash null key to set");
        }
        int h = key.hashCode();
        return h ^ h >>> 16;
    }

    static Class<?> comparableClassFor(Object x) {
        if (x instanceof Comparable) {
            Class<?> c = x.getClass();
            if (c == String.class) {
                return c;
            }
            Type[] ts = c.getGenericInterfaces();
            if (ts != null) {
                for (Type type : ts) {
                    Type[] as;
                    ParameterizedType p;
                    Type t = type;
                    if (!(t instanceof ParameterizedType) || (p = (ParameterizedType)t).getRawType() != Comparable.class || (as = p.getActualTypeArguments()) == null || as.length != 1 || as[0] != c) continue;
                    return c;
                }
            }
        }
        return null;
    }

    static int compareComparables(Class<?> kc, Object k, Object x) {
        return x == null || x.getClass() != kc ? 0 : ((Comparable)k).compareTo(x);
    }

    static int tableSizeFor(int cap) {
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object key) {
        return this.getNode(QuantumHashSet.hash(key), key) != null;
    }

    @Override
    public @NonNull Iterator<K> iterator() {
        return new KeyIterator();
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int expectedModCount = this.modCount;
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        int ti = 0;
        for (int si = 0; si < this.table.length; si += 2) {
            Node<K> key = this.table[si];
            if (key == null) continue;
            if (ti >= this.size) {
                throw new ConcurrentModificationException();
            }
            a[ti++] = key;
        }
        if (ti < this.size || expectedModCount != this.modCount) {
            throw new ConcurrentModificationException();
        }
        if (ti < a.length) {
            a[ti] = null;
        }
        return a;
    }

    @Override
    public boolean add(K key) {
        return this.putVal(QuantumHashSet.hash(key), key);
    }

    final Node<K> getNode(int hash, @NonNull Object key) {
        Node<K> first;
        int n;
        if (this.table != null && (n = this.table.length) > 0 && (first = this.table[n - 1 & hash]) != null) {
            Object k;
            if (first.hash == hash && ((k = first.key) == key || key.equals(k))) {
                return first;
            }
            Node e = first.next;
            if (e != null) {
                if (first instanceof TreeNode) {
                    return ((TreeNode)first).getTreeNode(hash, key);
                }
                do {
                    if (e.hash != hash || (k = e.key) != key && !key.equals(k)) continue;
                    return e;
                } while ((e = e.next) != null);
            }
        }
        return null;
    }

    public final boolean putVal(int hash, @NonNull K key) {
        int i;
        Node<K> p;
        int n;
        Node<K>[] tab = this.table;
        if (this.table == null || (n = tab.length) == 0) {
            tab = this.resize();
            n = tab.length;
        }
        if ((p = tab[i = n - 1 & hash]) == null) {
            tab[i] = this.newNode(hash, key, null);
        } else {
            Node<K> e;
            Object k;
            if (p.hash == hash && ((k = p.key) == key || key.equals(k))) {
                e = p;
            } else if (p instanceof TreeNode) {
                e = ((TreeNode)p).putTreeVal(this, tab, hash, key);
            } else {
                int binCount = 0;
                while (true) {
                    if ((e = p.next) == null) {
                        p.next = this.newNode(hash, key, null);
                        if (binCount < 7) break;
                        this.treeifyBin(tab, hash);
                        break;
                    }
                    if (e.hash == hash && ((k = e.key) == key || key.equals(k))) break;
                    p = e;
                    ++binCount;
                }
            }
            if (e != null) {
                return true;
            }
        }
        ++this.modCount;
        if (++this.size > this.threshold) {
            this.resize();
        }
        return false;
    }

    final Node<K>[] resize() {
        int newCap;
        Node<K>[] oldTab = this.table;
        int oldCap = oldTab == null ? 0 : oldTab.length;
        int oldThr = this.threshold;
        int newThr = 0;
        if (oldCap > 0) {
            if (oldCap >= 0x40000000) {
                this.threshold = Integer.MAX_VALUE;
                return oldTab;
            }
            newCap = oldCap << 1;
            if (newCap < 0x40000000 && oldCap >= 16) {
                newThr = oldThr << 1;
            }
        } else if (oldThr > 0) {
            newCap = oldThr;
        } else {
            newCap = 16;
            newThr = 12;
        }
        if (newThr == 0) {
            float ft = (float)newCap * this.loadFactor;
            newThr = newCap < 0x40000000 && ft < 1.0737418E9f ? (int)ft : Integer.MAX_VALUE;
        }
        this.threshold = newThr;
        Node[] newTab = new Node[newCap];
        this.table = newTab;
        if (oldTab != null) {
            for (int j = 0; j < oldCap; ++j) {
                Node next;
                Node<K> e = oldTab[j];
                if (e == null) continue;
                oldTab[j] = null;
                if (e.next == null) {
                    newTab[e.hash & newCap - 1] = e;
                    continue;
                }
                if (e instanceof TreeNode) {
                    ((TreeNode)e).split(this, newTab, j, oldCap);
                    continue;
                }
                Node<K> loHead = null;
                Node<K> loTail = null;
                Node<K> hiHead = null;
                Node<K> hiTail = null;
                do {
                    next = e.next;
                    if ((e.hash & oldCap) == 0) {
                        if (loTail == null) {
                            loHead = e;
                        } else {
                            loTail.next = e;
                        }
                        loTail = e;
                        continue;
                    }
                    if (hiTail == null) {
                        hiHead = e;
                    } else {
                        hiTail.next = e;
                    }
                    hiTail = e;
                } while ((e = next) != null);
                if (loTail != null) {
                    loTail.next = null;
                    newTab[j] = loHead;
                }
                if (hiTail == null) continue;
                hiTail.next = null;
                newTab[j + oldCap] = hiHead;
            }
        }
        return newTab;
    }

    final void treeifyBin(Node<K>[] tab, int hash) {
        int n;
        if (tab == null || (n = tab.length) < 64) {
            this.resize();
        } else {
            int index = n - 1 & hash;
            Node<K> e = tab[index];
            if (e != null) {
                TreeNode<K> hd = null;
                TreeNode<K> tl = null;
                do {
                    TreeNode<K> p = this.replacementTreeNode(e, null);
                    if (tl == null) {
                        hd = p;
                    } else {
                        p.prev = tl;
                        tl.next = p;
                    }
                    tl = p;
                } while ((e = e.next) != null);
                tab[index] = hd;
                if (tab[index] != null) {
                    hd.treeify(tab);
                }
            }
        }
    }

    @Override
    public boolean remove(Object key) {
        return this.removeNode(QuantumHashSet.hash(key), key, true) != null;
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> c) {
        return false;
    }

    @Override
    public boolean addAll(@NonNull Collection<? extends K> c) {
        return false;
    }

    @Override
    public boolean retainAll(@NonNull Collection<?> c) {
        return false;
    }

    @Override
    public boolean removeAll(@NonNull Collection<?> c) {
        return false;
    }

    final Node<K> removeNode(int hash, Object key, boolean movable) {
        int index;
        Node<K> p;
        int n;
        Node<K>[] tab = this.table;
        if (tab != null && (n = tab.length) > 0 && (p = tab[index = n - 1 & hash]) != null) {
            Object k;
            Node<K> node = null;
            if (p.hash == hash && ((k = p.key) == key || key != null && key.equals(k))) {
                node = p;
            } else {
                Node e = p.next;
                if (e != null) {
                    if (p instanceof TreeNode) {
                        node = ((TreeNode)p).getTreeNode(hash, key);
                    } else {
                        do {
                            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                                node = e;
                                break;
                            }
                            p = e;
                        } while ((e = e.next) != null);
                    }
                }
            }
            if (node instanceof TreeNode) {
                ((TreeNode)node).removeTreeNode(this, tab, movable);
            } else if (node == p) {
                tab[index] = node.next;
            } else {
                p.next = node.next;
            }
            ++this.modCount;
            --this.size;
            return node;
        }
        return null;
    }

    @Override
    public void clear() {
        ++this.modCount;
        if (this.table != null && this.size > 0) {
            this.size = 0;
            Node<K>[] tab = this.table;
            for (int i = 0; i < tab.length; ++i) {
                tab[i] = null;
            }
        }
    }

    @Override
    public final Spliterator<K> spliterator() {
        return new KeySpliterator(this, 0, -1, 0, 0);
    }

    @Override
    public void forEach(Consumer<? super K> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.size > 0 && this.table != null) {
            int mc = this.modCount;
            for (Node<K> e : this.table) {
                while (e != null) {
                    action.accept(e.key);
                    e = e.next;
                }
            }
            if (this.modCount != mc) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public Node<K> newNode(int hash, K key, Node<K> next) {
        return new Node<K>(hash, key, next);
    }

    public Node<K> replacementNode(Node<K> p, Node<K> next) {
        return new Node(p.hash, p.key, next);
    }

    public TreeNode<K> newTreeNode(int hash, K key, Node<K> next) {
        return new TreeNode<K>(hash, key, next);
    }

    public TreeNode<K> replacementTreeNode(Node<K> p, Node<K> next) {
        return new TreeNode(p.hash, p.key, next);
    }

    private static class Node<K> {
        final int hash;
        final K key;
        Node<K> next;

        Node(int hash, K key, Node<K> next) {
            this.hash = hash;
            this.key = key;
            this.next = next;
        }

        public final String toString() {
            return String.valueOf(this.key);
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator<K> {
        KeyIterator() {
        }

        @Override
        public final K next() {
            return this.nextNode().key;
        }
    }

    static final class TreeNode<K>
    extends Entry<K> {
        TreeNode<K> parent;
        TreeNode<K> left;
        TreeNode<K> right;
        TreeNode<K> prev;
        boolean red;

        TreeNode(int hash, K key, Node<K> next) {
            super(hash, key, next);
        }

        static <K> void moveRootToFront(Node<K>[] tab, TreeNode<K> root) {
            int n;
            if (root != null && tab != null && (n = tab.length) > 0) {
                int index = n - 1 & root.hash;
                TreeNode first = (TreeNode)tab[index];
                if (root != first) {
                    tab[index] = root;
                    TreeNode<K> rp = root.prev;
                    Node rn = root.next;
                    if (rn != null) {
                        ((TreeNode)rn).prev = rp;
                    }
                    if (rp != null) {
                        rp.next = rn;
                    }
                    if (first != null) {
                        first.prev = root;
                    }
                    root.next = first;
                    root.prev = null;
                }
                assert (TreeNode.checkInvariants(root));
            }
        }

        static int tieBreakOrder(Object a, Object b) {
            int d;
            if (a == null || b == null || (d = a.getClass().getName().compareTo(b.getClass().getName())) == 0) {
                d = System.identityHashCode(a) <= System.identityHashCode(b) ? -1 : 1;
            }
            return d;
        }

        static <K> TreeNode<K> rotateLeft(TreeNode<K> root, TreeNode<K> p) {
            TreeNode<K> r;
            if (p != null && (r = p.right) != null) {
                p.right = r.left;
                TreeNode<K> rl = p.right;
                if (p.right != null) {
                    rl.parent = p;
                }
                TreeNode<K> pp = r.parent = p.parent;
                if (r.parent == null) {
                    root = r;
                    r.red = false;
                } else if (pp.left == p) {
                    pp.left = r;
                } else {
                    pp.right = r;
                }
                r.left = p;
                p.parent = r;
            }
            return root;
        }

        static <K> TreeNode<K> rotateRight(TreeNode<K> root, TreeNode<K> p) {
            TreeNode<K> l;
            if (p != null && (l = p.left) != null) {
                p.left = l.right;
                TreeNode<K> lr = p.left;
                if (p.left != null) {
                    lr.parent = p;
                }
                TreeNode<K> pp = l.parent = p.parent;
                if (l.parent == null) {
                    root = l;
                    l.red = false;
                } else if (pp.right == p) {
                    pp.right = l;
                } else {
                    pp.left = l;
                }
                l.right = p;
                p.parent = l;
            }
            return root;
        }

        static <K> TreeNode<K> balanceInsertion(TreeNode<K> root, TreeNode<K> x) {
            x.red = true;
            while (true) {
                TreeNode<K> xpp;
                TreeNode<K> xp;
                if ((xp = x.parent) == null) {
                    x.red = false;
                    return x;
                }
                if (!xp.red || (xpp = xp.parent) == null) {
                    return root;
                }
                TreeNode<K> xppl = xpp.left;
                if (xp == xppl) {
                    TreeNode<K> xppr = xpp.right;
                    if (xppr != null && xppr.red) {
                        xppr.red = false;
                        xp.red = false;
                        xpp.red = true;
                        x = xpp;
                        continue;
                    }
                    if (x == xp.right) {
                        x = xp;
                        root = TreeNode.rotateLeft(root, x);
                        xp = x.parent;
                        TreeNode<K> treeNode = xpp = xp == null ? null : xp.parent;
                    }
                    if (xp == null) continue;
                    xp.red = false;
                    if (xpp == null) continue;
                    xpp.red = true;
                    root = TreeNode.rotateRight(root, xpp);
                    continue;
                }
                if (xppl != null && xppl.red) {
                    xppl.red = false;
                    xp.red = false;
                    xpp.red = true;
                    x = xpp;
                    continue;
                }
                if (x == xp.left) {
                    x = xp;
                    root = TreeNode.rotateRight(root, x);
                    xp = x.parent;
                    TreeNode<K> treeNode = xpp = xp == null ? null : xp.parent;
                }
                if (xp == null) continue;
                xp.red = false;
                if (xpp == null) continue;
                xpp.red = true;
                root = TreeNode.rotateLeft(root, xpp);
            }
        }

        static <K> TreeNode<K> balanceDeletion(TreeNode<K> root, TreeNode<K> x) {
            while (x != null && x != root) {
                TreeNode<K> sr;
                TreeNode<K> sl;
                TreeNode<K> xp = x.parent;
                if (xp == null) {
                    x.red = false;
                    return x;
                }
                if (x.red) {
                    x.red = false;
                    return root;
                }
                TreeNode<K> xpl = xp.left;
                if (xpl == x) {
                    TreeNode<K> xpr = xp.right;
                    if (xpr != null && xpr.red) {
                        xpr.red = false;
                        xp.red = true;
                        root = TreeNode.rotateLeft(root, xp);
                        xp = x.parent;
                        TreeNode<K> treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr == null) {
                        x = xp;
                        continue;
                    }
                    sl = xpr.left;
                    sr = xpr.right;
                    if (!(sr != null && sr.red || sl != null && sl.red)) {
                        xpr.red = true;
                        x = xp;
                        continue;
                    }
                    if (sr == null || !sr.red) {
                        if (sl != null) {
                            sl.red = false;
                        }
                        xpr.red = true;
                        root = TreeNode.rotateRight(root, xpr);
                        xp = x.parent;
                        TreeNode<K> treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr != null) {
                        xpr.red = xp != null && xp.red;
                        sr = xpr.right;
                        if (sr != null) {
                            sr.red = false;
                        }
                    }
                    if (xp != null) {
                        xp.red = false;
                        root = TreeNode.rotateLeft(root, xp);
                    }
                    x = root;
                    continue;
                }
                if (xpl != null && xpl.red) {
                    xpl.red = false;
                    xp.red = true;
                    root = TreeNode.rotateRight(root, xp);
                    xp = x.parent;
                    TreeNode<K> treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl == null) {
                    x = xp;
                    continue;
                }
                sl = xpl.left;
                sr = xpl.right;
                if (!(sl != null && sl.red || sr != null && sr.red)) {
                    xpl.red = true;
                    x = xp;
                    continue;
                }
                if (sl == null || !sl.red) {
                    if (sr != null) {
                        sr.red = false;
                    }
                    xpl.red = true;
                    root = TreeNode.rotateLeft(root, xpl);
                    xp = x.parent;
                    TreeNode<K> treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl != null) {
                    xpl.red = xp != null && xp.red;
                    sl = xpl.left;
                    if (sl != null) {
                        sl.red = false;
                    }
                }
                if (xp != null) {
                    xp.red = false;
                    root = TreeNode.rotateRight(root, xp);
                }
                x = root;
            }
            return root;
        }

        static <K> boolean checkInvariants(TreeNode<K> t) {
            TreeNode<K> tp = t.parent;
            TreeNode<K> tl = t.left;
            TreeNode<K> tr = t.right;
            TreeNode<K> tb = t.prev;
            TreeNode tn = (TreeNode)t.next;
            if (tb != null && tb.next != t) {
                return false;
            }
            if (tn != null && tn.prev != t) {
                return false;
            }
            if (tp != null && t != tp.left && t != tp.right) {
                return false;
            }
            if (tl != null && (tl.parent != t || tl.hash > t.hash)) {
                return false;
            }
            if (tr != null && (tr.parent != t || tr.hash < t.hash)) {
                return false;
            }
            if (t.red && tl != null && tl.red && tr != null && tr.red) {
                return false;
            }
            if (tl != null && !TreeNode.checkInvariants(tl)) {
                return false;
            }
            return tr == null || TreeNode.checkInvariants(tr);
        }

        final TreeNode<K> root() {
            TreeNode<K> r = this;
            TreeNode<K> p;
            while ((p = r.parent) != null) {
                r = p;
            }
            return r;
        }

        final TreeNode<K> find(int h, Object k, Class<?> kc) {
            TreeNode<K> p = this;
            do {
                int dir;
                TreeNode<K> pl = p.left;
                TreeNode<K> pr = p.right;
                int ph = p.hash;
                if (ph > h) {
                    p = pl;
                    continue;
                }
                if (ph < h) {
                    p = pr;
                    continue;
                }
                Object pk = p.key;
                if (pk == k || k != null && k.equals(pk)) {
                    return p;
                }
                if (pl == null) {
                    p = pr;
                    continue;
                }
                if (pr == null) {
                    p = pl;
                    continue;
                }
                if ((kc != null || (kc = QuantumHashSet.comparableClassFor(k)) != null) && (dir = QuantumHashSet.compareComparables(kc, k, pk)) != 0) {
                    p = dir < 0 ? pl : pr;
                    continue;
                }
                TreeNode<K> q = pr.find(h, k, kc);
                if (q != null) {
                    return q;
                }
                p = pl;
            } while (p != null);
            return null;
        }

        final TreeNode<K> getTreeNode(int h, Object k) {
            return (this.parent != null ? this.root() : this).find(h, k, null);
        }

        final void treeify(Node<K>[] tab) {
            TreeNode<K> root = null;
            TreeNode<K> x = this;
            while (x != null) {
                TreeNode next = (TreeNode)x.next;
                x.right = null;
                x.left = null;
                if (root == null) {
                    x.parent = null;
                    x.red = false;
                    root = x;
                } else {
                    TreeNode<K> xp;
                    int dir;
                    Object k = x.key;
                    int h = x.hash;
                    Class<?> kc = null;
                    TreeNode<K> p = root;
                    do {
                        Object pk = p.key;
                        int ph = p.hash;
                        if (ph > h) {
                            dir = -1;
                        } else if (ph < h) {
                            dir = 1;
                        } else if (kc == null && (kc = QuantumHashSet.comparableClassFor(k)) == null || (dir = QuantumHashSet.compareComparables(kc, k, pk)) == 0) {
                            dir = TreeNode.tieBreakOrder(k, pk);
                        }
                        xp = p;
                    } while ((p = dir <= 0 ? p.left : p.right) != null);
                    x.parent = xp;
                    if (dir <= 0) {
                        xp.left = x;
                    } else {
                        xp.right = x;
                    }
                    root = TreeNode.balanceInsertion(root, x);
                }
                x = next;
            }
            TreeNode.moveRootToFront(tab, root);
        }

        final Node<K> untreeify(QuantumHashSet<K> map) {
            Node<K> hd = null;
            Node<K> tl = null;
            Node q = this;
            while (q != null) {
                Node<K> p = map.replacementNode(q, null);
                if (tl == null) {
                    hd = p;
                } else {
                    tl.next = p;
                }
                tl = p;
                q = q.next;
            }
            return hd;
        }

        final TreeNode<K> putTreeVal(QuantumHashSet<K> map, Node<K>[] tab, int h, K k) {
            TreeNode<K> xp;
            int dir;
            TreeNode<K> root;
            Class<?> kc = null;
            boolean searched = false;
            TreeNode<K> p = root = this.parent != null ? this.root() : this;
            do {
                int ph;
                if ((ph = p.hash) > h) {
                    dir = -1;
                } else if (ph < h) {
                    dir = 1;
                } else {
                    Object pk = p.key;
                    if (pk == k || k.equals(pk)) {
                        return p;
                    }
                    if (kc == null && (kc = QuantumHashSet.comparableClassFor(k)) == null || (dir = QuantumHashSet.compareComparables(kc, k, pk)) == 0) {
                        if (!searched) {
                            TreeNode<K> q;
                            searched = true;
                            TreeNode<K> ch = p.left;
                            if (ch != null && (q = ch.find(h, k, kc)) != null || (ch = p.right) != null && (q = ch.find(h, k, kc)) != null) {
                                return q;
                            }
                        }
                        dir = TreeNode.tieBreakOrder(k, pk);
                    }
                }
                xp = p;
            } while ((p = dir <= 0 ? p.left : p.right) != null);
            Node xpn = xp.next;
            TreeNode<K> x = map.newTreeNode(h, k, xpn);
            if (dir <= 0) {
                xp.left = x;
            } else {
                xp.right = x;
            }
            xp.next = x;
            x.prev = xp;
            x.parent = x.prev;
            if (xpn != null) {
                ((TreeNode)xpn).prev = x;
            }
            TreeNode.moveRootToFront(tab, TreeNode.balanceInsertion(root, x));
            return null;
        }

        final void removeTreeNode(QuantumHashSet<K> map, Node<K>[] tab, boolean movable) {
            TreeNode<K> r;
            TreeNode<K> replacement;
            TreeNode<K> rl;
            TreeNode<K> first;
            int n;
            if (tab == null || (n = tab.length) == 0) {
                return;
            }
            int index = n - 1 & this.hash;
            TreeNode<K> root = first = (TreeNode<K>)tab[index];
            TreeNode succ = (TreeNode)this.next;
            TreeNode<K> pred = this.prev;
            if (pred == null) {
                first = succ;
                tab[index] = first;
            } else {
                pred.next = succ;
            }
            if (succ != null) {
                succ.prev = pred;
            }
            if (first == null) {
                return;
            }
            if (root.parent != null) {
                root = root.root();
            }
            if (root == null || root.right == null || (rl = root.left) == null || rl.left == null) {
                tab[index] = first.untreeify(map);
                return;
            }
            TreeNode<K> p = this;
            TreeNode<K> pl = this.left;
            TreeNode<K> pr = this.right;
            if (pl != null && pr != null) {
                TreeNode<K> sl;
                TreeNode<K> s = pr;
                while ((sl = s.left) != null) {
                    s = sl;
                }
                boolean c = s.red;
                s.red = p.red;
                p.red = c;
                TreeNode<K> sr = s.right;
                TreeNode<K> pp = p.parent;
                if (s == pr) {
                    p.parent = s;
                    s.right = p;
                } else {
                    TreeNode<K> sp = s.parent;
                    p.parent = sp;
                    if (p.parent != null) {
                        if (s == sp.left) {
                            sp.left = p;
                        } else {
                            sp.right = p;
                        }
                    }
                    if ((s.right = pr) != null) {
                        pr.parent = s;
                    }
                }
                p.left = null;
                p.right = sr;
                if (p.right != null) {
                    sr.parent = p;
                }
                if ((s.left = pl) != null) {
                    pl.parent = s;
                }
                if ((s.parent = pp) == null) {
                    root = s;
                } else if (p == pp.left) {
                    pp.left = s;
                } else {
                    pp.right = s;
                }
                replacement = sr != null ? sr : p;
            } else {
                replacement = pl != null ? pl : (pr != null ? pr : p);
            }
            if (replacement != p) {
                replacement.parent = p.parent;
                TreeNode<K> pp = replacement.parent;
                if (pp == null) {
                    root = replacement;
                } else if (p == pp.left) {
                    pp.left = replacement;
                } else {
                    pp.right = replacement;
                }
                p.parent = null;
                p.right = null;
                p.left = null;
            }
            TreeNode<K> treeNode = r = p.red ? root : TreeNode.balanceDeletion(root, replacement);
            if (replacement == p) {
                TreeNode<K> pp = p.parent;
                p.parent = null;
                if (pp != null) {
                    if (p == pp.left) {
                        pp.left = null;
                    } else if (p == pp.right) {
                        pp.right = null;
                    }
                }
            }
            if (movable) {
                TreeNode.moveRootToFront(tab, r);
            }
        }

        final void split(QuantumHashSet<K> map, Node<K>[] tab, int index, int bit) {
            TreeNode b = this;
            TreeNode loHead = null;
            TreeNode loTail = null;
            TreeNode hiHead = null;
            TreeNode hiTail = null;
            int lc = 0;
            int hc = 0;
            TreeNode e = b;
            while (e != null) {
                TreeNode next = (TreeNode)e.next;
                e.next = null;
                if ((e.hash & bit) == 0) {
                    e.prev = loTail;
                    if (e.prev == null) {
                        loHead = e;
                    } else {
                        loTail.next = e;
                    }
                    loTail = e;
                    ++lc;
                } else {
                    e.prev = hiTail;
                    if (e.prev == null) {
                        hiHead = e;
                    } else {
                        hiTail.next = e;
                    }
                    hiTail = e;
                    ++hc;
                }
                e = next;
            }
            if (loHead != null) {
                if (lc <= 6) {
                    tab[index] = loHead.untreeify(map);
                } else {
                    tab[index] = loHead;
                    if (hiHead != null) {
                        loHead.treeify(tab);
                    }
                }
            }
            if (hiHead != null) {
                if (hc <= 6) {
                    tab[index + bit] = hiHead.untreeify(map);
                } else {
                    tab[index + bit] = hiHead;
                    if (loHead != null) {
                        hiHead.treeify(tab);
                    }
                }
            }
        }
    }

    private static final class KeySpliterator<K>
    extends HashMapSpliterator<K>
    implements Spliterator<K> {
        KeySpliterator(QuantumHashSet<K> m, int origin, int fence, int est, int expectedModCount) {
            super(m, origin, fence, est, expectedModCount);
        }

        @Override
        public KeySpliterator<K> trySplit() {
            KeySpliterator<K> keySpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid || this.current != null) {
                keySpliterator = null;
            } else {
                this.index = mid;
                KeySpliterator<K> keySpliterator2 = new KeySpliterator<K>(this.map, lo, this.index, this.est >>>= 1, this.expectedModCount);
                keySpliterator = keySpliterator2;
            }
            return keySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> action) {
            int i;
            int mc;
            if (action == null) {
                throw new NullPointerException();
            }
            QuantumHashSet m = this.map;
            Node<K>[] tab = m.table;
            int hi = this.fence;
            if (hi < 0) {
                mc = this.expectedModCount = m.modCount;
                this.fence = tab == null ? 0 : tab.length;
                hi = this.fence;
            } else {
                mc = this.expectedModCount;
            }
            if (tab != null && tab.length >= hi && (i = this.index) >= 0 && (i < (this.index = hi) || this.current != null)) {
                Node p = this.current;
                this.current = null;
                do {
                    if (p == null) {
                        p = tab[i++];
                        continue;
                    }
                    action.accept(p.key);
                    p = p.next;
                } while (p != null || i < hi);
                if (m.modCount != mc) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> action) {
            int hi;
            Node<K>[] tab = this.map.table;
            if (tab != null && tab.length >= (hi = this.getFence()) && this.index >= 0) {
                while (this.current != null || this.index < hi) {
                    if (this.current == null) {
                        this.current = tab[this.index++];
                        continue;
                    }
                    Object k = this.current.key;
                    this.current = this.current.next;
                    action.accept(k);
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return (this.fence < 0 || this.est == this.map.size ? 64 : 0) | 1;
        }
    }

    abstract class HashIterator {
        Node<K> next;
        Node<K> current;
        int expectedModCount;
        int index;

        HashIterator() {
            this.expectedModCount = QuantumHashSet.this.modCount;
            Node<K>[] t = QuantumHashSet.this.table;
            this.next = null;
            this.current = null;
            this.index = 0;
            if (t != null && QuantumHashSet.this.size > 0) {
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        final Node<K> nextNode() {
            if (QuantumHashSet.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Node e = this.next;
            this.current = e;
            this.next = this.current.next;
            if (this.next == null && QuantumHashSet.this.table != null) {
                while (this.index < QuantumHashSet.this.table.length && (this.next = QuantumHashSet.this.table[this.index++]) == null) {
                }
            }
            return e;
        }

        public final void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (QuantumHashSet.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object key = this.current.key;
            this.current = null;
            QuantumHashSet.this.removeNode(QuantumHashSet.hash(key), key, false);
            this.expectedModCount = QuantumHashSet.this.modCount;
        }
    }

    static class Entry<K>
    extends Node<K> {
        Entry(int hash, K key, Node<K> next) {
            super(hash, key, next);
        }
    }

    private static class HashMapSpliterator<K> {
        final QuantumHashSet<K> map;
        Node<K> current;
        int index;
        int fence;
        int est;
        int expectedModCount;

        HashMapSpliterator(QuantumHashSet<K> m, int origin, int fence, int est, int expectedModCount) {
            this.map = m;
            this.index = origin;
            this.fence = fence;
            this.est = est;
            this.expectedModCount = expectedModCount;
        }

        final int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                QuantumHashSet<K> m = this.map;
                this.est = m.size;
                this.expectedModCount = m.modCount;
                Node<K>[] tab = m.table;
                this.fence = tab == null ? 0 : tab.length;
                hi = this.fence;
            }
            return hi;
        }

        public final long estimateSize() {
            this.getFence();
            return this.est;
        }
    }
}

