/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.integer;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.utils.internal.integer.HashContainers;

public class IntHashMap<VType>
implements Iterable<VType> {
    public int[] keys;
    public Object[] values;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected int iterationSeed;

    public IntHashMap() {
        this(4);
    }

    public IntHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public IntHashMap(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = HashContainers.nextIterationSeed();
        this.ensureCapacity(expectedElements);
    }

    public VType put(int key, VType value) {
        int existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key == 0) {
            this.hasEmptyKey = true;
            Object previousValue = this.values[mask + 1];
            this.values[mask + 1] = value;
            return (VType)previousValue;
        }
        int[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                Object previousValue = this.values[slot];
                this.values[slot] = value;
                return (VType)previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            this.values[slot] = value;
        }
        ++this.assigned;
        return null;
    }

    public VType remove(int key) {
        int existing;
        int mask = this.mask;
        if (key == 0) {
            this.hasEmptyKey = false;
            Object previousValue = this.values[mask + 1];
            this.values[mask + 1] = null;
            return (VType)previousValue;
        }
        int[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                Object previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return (VType)previousValue;
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    public VType get(int key) {
        int existing;
        if (key == 0) {
            return (VType)(this.hasEmptyKey ? this.values[this.mask + 1] : null);
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return (VType)this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    public VType getOrDefault(int key, VType defaultValue) {
        int existing;
        if (key == 0) {
            return (VType)(this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue);
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return (VType)this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    public boolean containsKey(int key) {
        int existing;
        if (key == 0) {
            return this.hasEmptyKey;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0);
        Arrays.fill(this.values, null);
    }

    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException();
    }

    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            int[] prevKeys = this.keys;
            Object[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    protected int hashKey(int key) {
        assert (key != 0);
        return HashContainers.mixPhi(key);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(int[] fromKeys, VType[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        int[] keys = this.keys;
        Object[] values = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            int existing = fromKeys[from];
            if (existing == 0) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int[] prevKeys = this.keys;
        Object[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new int[arraySize + emptyElementSlot];
            this.values = new Object[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new IllegalStateException("Not enough memory to allocate buffers for rehashing");
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, int pendingKey, VType pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == 0 && pendingKey != 0);
        int[] prevKeys = this.keys;
        Object[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        int existing;
        int[] keys = this.keys;
        Object[] values = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = values[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0;
        values[gapSlot] = null;
        --this.assigned;
    }

    @Override
    public @NonNull Iterator<VType> iterator() {
        return new Iterate();
    }

    private final class Iterate
    implements Iterator<VType> {
        int cursor = 0;
        VType next;

        private Iterate() {
        }

        @Override
        public boolean hasNext() {
            while (this.cursor < IntHashMap.this.values.length && (this.next = IntHashMap.this.values[this.cursor++]) == null) {
            }
            return this.next != null;
        }

        @Override
        public VType next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            return this.next;
        }
    }
}

