/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.nonnull;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.CollectionToArray;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.markers.KMutableList;
import org.kingdoms.utils.internal.nonnull.NullabilityUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\n\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0016J\u0016\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u000fH\u0096\u0001J\u0016\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0017\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0016J\u0016\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\bH\u0096\u0003\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\b2\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\t\u0010\u001c\u001a\u00020\fH\u0096\u0001J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0096\u0003J\u0015\u0010\u001f\u001a\u00020\b2\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0096\u0001J\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!2\u0006\u0010\u0010\u001a\u00020\bH\u0096\u0001J\u0015\u0010\"\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010#\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0016J\u0016\u0010$\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\bH\u0096\u0001\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010%\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0016J\u001e\u0010&\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010'J\u001f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\bH\u0096\u0001R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006+"}, d2={"Lorg/kingdoms/utils/internal/nonnull/NonNullList;", "V", "", "list", "(Ljava/util/List;)V", "getList", "()Ljava/util/List;", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "clear", "contains", "containsAll", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "remove", "removeAll", "removeAt", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "subList", "fromIndex", "toIndex", "core"})
public final class NonNullList<V>
implements List<V>,
KMutableList {
    @NotNull
    private final List<V> list;
    private final int size;

    public NonNullList(@NotNull List<V> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        this.list = list2;
        this.size = this.list.size();
    }

    @NotNull
    public final List<V> getList() {
        return this.list;
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public V get(int index) {
        return this.list.get(index);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        return this.list.iterator();
    }

    @Override
    @NotNull
    public ListIterator<V> listIterator() {
        return this.list.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<V> listIterator(int index) {
        return this.list.listIterator(index);
    }

    public V removeAt(int index) {
        return this.list.remove(index);
    }

    @Override
    @NotNull
    public List<V> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public V set(int index, V element) {
        return this.list.set(index, NullabilityUtils.assertNonNull(this, element));
    }

    @Override
    public boolean add(V element) {
        return this.list.add(NullabilityUtils.assertNonNull(this, element));
    }

    @Override
    public void add(int index, V element) {
        this.list.add(index, NullabilityUtils.assertNonNull(this, element));
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends V> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.list.addAll(index, NullabilityUtils.assertNonNullElements(elements));
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends V> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.list.addAll(NullabilityUtils.assertNonNullElements(elements));
    }

    @Override
    public boolean remove(Object element) {
        return this.list.remove(NullabilityUtils.assertNonNull(this, element));
    }

    @Override
    public int indexOf(Object element) {
        return this.list.indexOf(NullabilityUtils.assertNonNull(this, element));
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.list.lastIndexOf(NullabilityUtils.assertNonNull(this, element));
    }

    @Override
    public boolean contains(Object element) {
        return this.list.contains(NullabilityUtils.assertNonNull(this, element));
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.list.containsAll(NullabilityUtils.assertNonNullElements(elements));
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.list.retainAll(CollectionsKt.toSet((Iterable)NullabilityUtils.assertNonNullElements(elements)));
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.list.removeAll(CollectionsKt.toSet((Iterable)NullabilityUtils.assertNonNullElements(elements)));
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

