/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.nbt;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.kingdoms.libs.xseries.ReflectionUtils;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.utils.nbt.NBTType;
import org.kingdoms.utils.nbt.NBTWrappers;

public final class ItemNBT {
    public static final boolean CAN_ACCESS_UNBREAKABLE = ReflectionUtils.supports(11);
    private static final MethodHandle AS_NMS_COPY;
    private static final MethodHandle AS_BUKKIT_COPY;
    private static final MethodHandle SET_TAG;
    private static final MethodHandle GET_TAG;

    private ItemNBT() {
    }

    private static Object asNMSCopy(ItemStack item) {
        try {
            return AS_NMS_COPY.invoke(item);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private static ItemStack asBukkitCopy(Object nmsItem) {
        try {
            return AS_BUKKIT_COPY.invoke(nmsItem);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static ItemStack setTag(ItemStack item, NBTWrappers.NBTTagCompound tag) {
        Object nbtTag = tag.toNBT();
        Object nmsItem = ItemNBT.asNMSCopy(item);
        try {
            SET_TAG.invoke(nmsItem, nbtTag);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return ItemNBT.asBukkitCopy(nmsItem);
    }

    public static NBTWrappers.NBTTagCompound getTag(ItemStack item) {
        Object nmsItem = ItemNBT.asNMSCopy(item);
        Object tag = null;
        try {
            tag = GET_TAG.invoke(nmsItem);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (tag == null) {
            return new NBTWrappers.NBTTagCompound();
        }
        NBTWrappers.NBTTagCompound base = NBTWrappers.NBTTagCompound.fromNBT(tag);
        return base == null ? new NBTWrappers.NBTTagCompound() : base;
    }

    public static ItemStack addSimpleTag(ItemStack item, String tag, String value) {
        NBTWrappers.NBTTagCompound compound = ItemNBT.getTag(item);
        compound.setString(tag, value);
        return ItemNBT.setTag(item, compound);
    }

    public static ItemStack setUnbreakable(ItemStack item, boolean unbreakable) {
        if (CAN_ACCESS_UNBREAKABLE) {
            ItemMeta meta = item.getItemMeta();
            meta.setUnbreakable(unbreakable);
            item.setItemMeta(meta);
            return item;
        }
        NBTWrappers.NBTTagCompound tag = ItemNBT.getTag(item);
        tag.set("Unbreakable", NBTType.BOOLEAN, unbreakable);
        return ItemNBT.setTag(item, tag);
    }

    public static void setCanPlaceOnAndDestroy(NBTWrappers.NBTTagCompound tag, Collection<XMaterial> canPlaceOn, Collection<XMaterial> canDestroy) {
        NBTWrappers.NBTTagList<String> canPlaceOnNBT = new NBTWrappers.NBTTagList<String>();
        for (XMaterial material : canPlaceOn) {
            if (!material.isSupported()) continue;
            canPlaceOnNBT.add(new NBTWrappers.NBTTagString("minecraft:" + material.parseMaterial().name().toLowerCase(Locale.ENGLISH)));
        }
        NBTWrappers.NBTTagList<String> canDestroyNBT = new NBTWrappers.NBTTagList<String>();
        for (XMaterial material : canDestroy) {
            if (!material.isSupported()) continue;
            canDestroyNBT.add(new NBTWrappers.NBTTagString("minecraft:" + material.parseMaterial().name().toLowerCase(Locale.ENGLISH)));
        }
        tag.set("CanDestroy", canDestroyNBT);
        tag.set("CanPlaceOn", canPlaceOnNBT);
    }

    public static boolean isKingdomsItem(ItemStack item) {
        Object nmsItem = ItemNBT.asNMSCopy(item);
        Object tag = null;
        try {
            tag = GET_TAG.invoke(nmsItem);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (tag == null) {
            return false;
        }
        Map<String, Object> components = NBTWrappers.NBTTagCompound.getRawMap(tag);
        return components.containsKey("Kingdoms");
    }

    static {
        MethodHandle asNmsCopy = null;
        MethodHandle asBukkitCopy = null;
        MethodHandle setTag = null;
        MethodHandle getTag = null;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Class<?> crafItemStack = ReflectionUtils.getCraftClass("inventory.CraftItemStack");
        Class<?> nmsItemStack = ReflectionUtils.getNMSClass("world.item", "ItemStack");
        Class<?> nbtTagCompound = ReflectionUtils.getNMSClass("nbt", "NBTTagCompound");
        try {
            asNmsCopy = lookup.findStatic(crafItemStack, "asNMSCopy", MethodType.methodType(nmsItemStack, ItemStack.class));
            asBukkitCopy = lookup.findStatic(crafItemStack, "asBukkitCopy", MethodType.methodType(ItemStack.class, nmsItemStack));
            setTag = lookup.findVirtual(nmsItemStack, ReflectionUtils.v(18, "c").orElse("setTag"), MethodType.methodType(Void.TYPE, nbtTagCompound));
            getTag = lookup.findVirtual(nmsItemStack, ReflectionUtils.v(19, "v").v(18, "t").orElse("getTag"), MethodType.methodType(nbtTagCompound));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        AS_NMS_COPY = asNmsCopy;
        AS_BUKKIT_COPY = asBukkitCopy;
        SET_TAG = setTag;
        GET_TAG = getTag;
    }
}

