/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.nbt;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kingdoms.libs.xseries.ReflectionUtils;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.utils.nbt.NBTType;

public final class NBTWrappers {
    private NBTWrappers() {
    }

    private static Class<?> getNBTClass(String clazz) {
        return ReflectionUtils.getNMSClass("nbt", clazz);
    }

    private static Field getDeclaredField(Class<?> clazz, String ... names) {
        int i = 0;
        for (String name : names) {
            ++i;
            try {
                return clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                if (i != names.length) continue;
                e.printStackTrace();
            }
        }
        return null;
    }

    public static final class NBTTagFloat
    extends NBTNumber<Float> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        public NBTTagFloat(float value) {
            super(Float.valueOf(value));
        }

        public static NBTTagFloat fromNBT(Object nbtObject) {
            try {
                return new NBTTagFloat(NBT_DATA.invoke(nbtObject));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        @Override
        public double getAsDouble() {
            return ((Float)this.value).floatValue();
        }

        @Override
        public float getAsFloat() {
            return ((Float)this.value).floatValue();
        }

        @Override
        public Object toNBT() {
            try {
                return CONSTRUCTOR.invoke(this.getAsFloat());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagFloat{" + this.value + '}';
        }

        static {
            Class clazz = NBTWrappers.getNBTClass("NBTTagFloat");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle handler = null;
            MethodHandle data = null;
            try {
                handler = XMaterial.supports(15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Float.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Float.TYPE));
                Field field = NBTWrappers.getDeclaredField(clazz, new String[]{"w", "data"});
                field.setAccessible(true);
                data = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            CONSTRUCTOR = handler;
            NBT_DATA = data;
        }
    }

    public static final class NBTTagLong
    extends NBTNumber<Long> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        public NBTTagLong(long value) {
            super(value);
        }

        public static NBTTagLong fromNBT(Object nbtObject) {
            try {
                return new NBTTagLong(NBT_DATA.invoke(nbtObject));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        @Override
        public double getAsDouble() {
            return ((Long)this.value).longValue();
        }

        @Override
        public long getAsLong() {
            return (Long)this.value;
        }

        @Override
        public Object toNBT() {
            try {
                return CONSTRUCTOR.invoke(this.getAsLong());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagLong{" + this.value + '}';
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class clazz = NBTWrappers.getNBTClass("NBTTagLong");
            MethodHandle handler = null;
            MethodHandle data = null;
            try {
                handler = XMaterial.supports(15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Long.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Long.TYPE));
                Field field = NBTWrappers.getDeclaredField(clazz, new String[]{"c", "data"});
                field.setAccessible(true);
                data = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            CONSTRUCTOR = handler;
            NBT_DATA = data;
        }
    }

    public static final class NBTTagShort
    extends NBTNumber<Short> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        public NBTTagShort(short value) {
            super(value);
        }

        public static NBTTagShort fromNBT(Object nbtObject) {
            try {
                return new NBTTagShort(NBT_DATA.invoke(nbtObject));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        @Override
        public short getAsShort() {
            return (Short)this.value;
        }

        @Override
        public double getAsDouble() {
            return ((Short)this.value).shortValue();
        }

        @Override
        public Object toNBT() {
            try {
                return CONSTRUCTOR.invoke(this.getAsShort());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagShort{" + this.value + '}';
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class clazz = NBTWrappers.getNBTClass("NBTTagShort");
            MethodHandle handler = null;
            MethodHandle data = null;
            try {
                handler = XMaterial.supports(15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Short.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Short.TYPE));
                Field field = NBTWrappers.getDeclaredField(clazz, new String[]{"c", "data"});
                field.setAccessible(true);
                data = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            CONSTRUCTOR = handler;
            NBT_DATA = data;
        }
    }

    public static final class NBTTagByteArray
    extends NBTArray<byte[]> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        public NBTTagByteArray(byte[] value) {
            super(value);
        }

        public static NBTTagByteArray fromNBT(Object nbtObject) {
            try {
                return nbtObject == null ? new NBTTagByteArray(new byte[0]) : new NBTTagByteArray(NBT_DATA.invoke(nbtObject));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        @Override
        public Object toNBT() {
            try {
                return CONSTRUCTOR.invoke((byte[])this.value);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagByteArray{" + Arrays.toString((byte[])this.value) + '}';
        }

        static {
            Class clazz = NBTWrappers.getNBTClass("NBTTagByteArray");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle handler = null;
            MethodHandle data = null;
            try {
                handler = lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, byte[].class));
                Field field = NBTWrappers.getDeclaredField(clazz, new String[]{"c", "data"});
                field.setAccessible(true);
                data = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            CONSTRUCTOR = handler;
            NBT_DATA = data;
        }
    }

    public static final class NBTTagByte
    extends NBTNumber<Byte> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        public NBTTagByte(byte value) {
            super(value);
        }

        public static NBTBase<Byte> fromNBT(Object nbtObject) {
            try {
                return new NBTTagByte(NBT_DATA.invoke(nbtObject));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        @Override
        public double getAsDouble() {
            return ((Byte)this.value).byteValue();
        }

        @Override
        public Object toNBT() {
            try {
                return CONSTRUCTOR.invoke(this.getAsByte());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagByte{" + this.value + '}';
        }

        static {
            Class clazz = NBTWrappers.getNBTClass("NBTTagByte");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle handler = null;
            MethodHandle data = null;
            try {
                handler = XMaterial.supports(15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Byte.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Byte.TYPE));
                Field field = NBTWrappers.getDeclaredField(clazz, new String[]{"x", "data"});
                field.setAccessible(true);
                data = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            CONSTRUCTOR = handler;
            NBT_DATA = data;
        }
    }

    public static final class NBTTagInt
    extends NBTNumber<Integer> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        public NBTTagInt(int value) {
            super(value);
        }

        public static NBTTagInt fromNBT(Object nbtObject) {
            try {
                return new NBTTagInt(NBT_DATA.invoke(nbtObject));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        @Override
        public double getAsDouble() {
            return ((Integer)this.value).intValue();
        }

        @Override
        public Object toNBT() {
            try {
                return CONSTRUCTOR.invoke((Integer)this.value);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagInt{" + this.value + '}';
        }

        static {
            Class clazz = NBTWrappers.getNBTClass("NBTTagInt");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle handler = null;
            MethodHandle data = null;
            try {
                handler = XMaterial.supports(15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Integer.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Integer.TYPE));
                Field field = NBTWrappers.getDeclaredField(clazz, new String[]{"c", "data"});
                field.setAccessible(true);
                data = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            CONSTRUCTOR = handler;
            NBT_DATA = data;
        }
    }

    public static final class NBTTagDouble
    extends NBTNumber<Double> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        public NBTTagDouble(double value) {
            super(value);
        }

        public static NBTTagDouble fromNBT(Object nbtObject) {
            try {
                return new NBTTagDouble(NBT_DATA.invoke(nbtObject));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        @Override
        public Object toNBT() {
            try {
                return CONSTRUCTOR.invoke(this.getAsDouble());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagDouble{" + this.value + '}';
        }

        @Override
        public double getAsDouble() {
            return (Double)this.value;
        }

        static {
            Class clazz = NBTWrappers.getNBTClass("NBTTagDouble");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle handler = null;
            MethodHandle data = null;
            try {
                handler = XMaterial.supports(15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, Double.TYPE)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Double.TYPE));
                Field field = NBTWrappers.getDeclaredField(clazz, new String[]{"w", "data"});
                field.setAccessible(true);
                data = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            CONSTRUCTOR = handler;
            NBT_DATA = data;
        }
    }

    public static abstract class NBTNumber<T extends Number>
    extends NBTBase<T> {
        public NBTNumber(T value) {
            super(value);
        }

        public int getAsInt() {
            return (int)Math.floor(this.getAsDouble());
        }

        public long getAsLong() {
            return (long)Math.floor(this.getAsDouble());
        }

        public abstract double getAsDouble();

        public float getAsFloat() {
            return (float)this.getAsDouble();
        }

        public byte getAsByte() {
            return (byte)(this.getAsInt() & 0xFF);
        }

        public short getAsShort() {
            return (short)(this.getAsInt() & 0xFFFF);
        }
    }

    public static abstract class NBTArray<T>
    extends NBTBase<T> {
        public NBTArray(T value) {
            super(value);
        }
    }

    public static final class NBTTagList<T>
    extends NBTBase<List<NBTBase<T>>> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle GET_DATA;
        private static final MethodHandle SET_DATA;
        private static final MethodHandle GET_TYPE_ID;

        public NBTTagList(List<NBTBase<T>> value) {
            super(value);
        }

        public NBTTagList() {
            super(new ArrayList());
        }

        public static NBTTagList<?> fromNBT(Object nbtObject) {
            List nbtList;
            try {
                nbtList = GET_DATA.invoke(nbtObject);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return new NBTTagList();
            }
            ArrayList list2 = new ArrayList(nbtList.size());
            for (Object entry : nbtList) {
                list2.add(NBTBase.fromNBT(entry));
            }
            return new NBTTagList(list2);
        }

        public boolean add(NBTBase<T> base) {
            ((List)this.value).add(base);
            return true;
        }

        public boolean isType(NBTBase<?> type) {
            return ((List)this.value).isEmpty() || ((NBTBase)((List)this.value).get(0)).getClass().isInstance(type);
        }

        @Override
        public Object toNBT() {
            try {
                ArrayList<Object> array = new ArrayList<Object>(((List)this.value).size());
                for (NBTBase base : (List)this.value) {
                    array.add(base.toNBT());
                }
                if (XMaterial.supports(15)) {
                    byte typeId = array.isEmpty() ? (byte)0 : GET_TYPE_ID.invoke(array.get(0));
                    return CONSTRUCTOR.invoke(array, typeId);
                }
                Object nbtList = CONSTRUCTOR.invoke();
                SET_DATA.invoke(nbtList, array);
                return nbtList;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagList{" + Arrays.toString(((List)this.value).toArray()) + '}';
        }

        static {
            Class clazz = NBTWrappers.getNBTClass("NBTTagList");
            Class nbtBase = NBTWrappers.getNBTClass("NBTBase");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle handler = null;
            MethodHandle getData = null;
            MethodHandle setData = null;
            MethodHandle getTypeId = null;
            try {
                Field field = NBTWrappers.getDeclaredField(clazz, new String[]{"c", "list"});
                field.setAccessible(true);
                getData = lookup.unreflectGetter(field);
                if (XMaterial.supports(15)) {
                    Constructor ctor = clazz.getDeclaredConstructor(List.class, Byte.TYPE);
                    ctor.setAccessible(true);
                    handler = lookup.unreflectConstructor(ctor);
                } else {
                    handler = lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE));
                    setData = lookup.unreflectSetter(field);
                }
                getTypeId = lookup.findVirtual(nbtBase, ReflectionUtils.v(19, "b").v(18, "a").orElse("getTypeId"), MethodType.methodType(Byte.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            CONSTRUCTOR = handler;
            GET_DATA = getData;
            SET_DATA = setData;
            GET_TYPE_ID = getTypeId;
        }
    }

    public static final class NBTTagIntArray
    extends NBTArray<int[]> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        public NBTTagIntArray(int[] value) {
            super(value);
        }

        public static NBTTagIntArray fromNBT(Object nbtObject) {
            try {
                return new NBTTagIntArray(NBT_DATA.invoke(nbtObject));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        @Override
        public Object toNBT() {
            try {
                return CONSTRUCTOR.invoke((int[])this.value);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagIntArray{" + Arrays.toString((int[])this.value) + '}';
        }

        static {
            Class clazz = NBTWrappers.getNBTClass("NBTTagIntArray");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle handler = null;
            MethodHandle data = null;
            try {
                handler = lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, int[].class));
                Field field = NBTWrappers.getDeclaredField(clazz, new String[]{"c", "data"});
                field.setAccessible(true);
                data = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            CONSTRUCTOR = handler;
            NBT_DATA = data;
        }
    }

    public static final class NBTTagLongArray
    extends NBTArray<long[]> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        public NBTTagLongArray(long[] value) {
            super(value);
        }

        public static NBTTagLongArray fromNBT(Object nbtObject) {
            try {
                return new NBTTagLongArray(NBT_DATA.invoke(nbtObject));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        @Override
        public Object toNBT() {
            try {
                return CONSTRUCTOR.invoke((long[])this.value);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagLongArray{" + Arrays.toString((long[])this.value) + '}';
        }

        static {
            Class clazz = NBTWrappers.getNBTClass("NBTTagLongArray");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle handler = null;
            MethodHandle data = null;
            try {
                handler = lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, long[].class));
                Field field = NBTWrappers.getDeclaredField(clazz, new String[]{"c", "data"});
                field.setAccessible(true);
                data = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            CONSTRUCTOR = handler;
            NBT_DATA = data;
        }
    }

    public static final class NBTTagCompound
    extends NBTBase<Map<String, NBTBase<?>>>
    implements org.kingdoms.utils.nbt.NBTTagCompound {
        private static final MethodHandle NBT_TAG_COMPOUND_CONSTRUCTOR;
        private static final MethodHandle GET_COMPOUND_MAP;
        private static final MethodHandle SET_COMPOUND_MAP;

        public NBTTagCompound(Map<String, NBTBase<?>> value) {
            super(value);
        }

        public NBTTagCompound(int capacity) {
            this(new HashMap(capacity));
        }

        public NBTTagCompound() {
            this(new HashMap());
        }

        public static Map<String, Object> getRawMap(Object nbtObject) {
            try {
                return GET_COMPOUND_MAP.invoke(nbtObject);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public static NBTTagCompound fromNBT(Object nbtObject) {
            try {
                Map<String, Object> baseMap = NBTTagCompound.getRawMap(nbtObject);
                NBTTagCompound compound = new NBTTagCompound(baseMap.size());
                for (Map.Entry<String, Object> base : baseMap.entrySet()) {
                    NBTBase<?> nbtBase = NBTBase.fromNBT(base.getValue());
                    if (nbtBase == null) continue;
                    compound.set(base.getKey(), nbtBase);
                }
                return compound;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        @Override
        public <T> void set(String key, NBTType<T> type, T value) {
            NBTBase base = null;
            if (type == NBTType.STRING) {
                base = new NBTTagString((String)value);
            } else if (type == NBTType.BYTE) {
                base = new NBTTagByte((Byte)value);
            } else if (type == NBTType.BOOLEAN) {
                base = new NBTTagByte((byte)((Boolean)value != false ? 1 : 0));
            } else if (type == NBTType.SHORT) {
                base = new NBTTagShort((Short)value);
            } else if (type == NBTType.INTEGER) {
                base = new NBTTagInt((Integer)value);
            } else if (type == NBTType.LONG) {
                base = new NBTTagLong((Long)value);
            } else if (type == NBTType.FLOAT) {
                base = new NBTTagFloat(((Float)value).floatValue());
            } else if (type == NBTType.DOUBLE) {
                base = new NBTTagDouble((Double)value);
            } else if (type == NBTType.BYTE_ARRAY) {
                base = new NBTTagByteArray((byte[])value);
            } else if (type == NBTType.INTEGER_ARRAY) {
                base = new NBTTagIntArray((int[])value);
            } else if (type == NBTType.LONG_ARRAY) {
                base = new NBTTagLong((Long)value);
            }
            ((Map)this.value).put(key, base);
        }

        @Override
        public <T> T get(String key, NBTType<T> type) {
            NBTBase base = (NBTBase)((Map)this.value).get(key);
            return base == null ? null : (T)base.value;
        }

        @Override
        public <T> boolean has(String key, NBTType<T> type) {
            return this.has(key);
        }

        public boolean has(String key) {
            return ((Map)this.value).containsKey(key);
        }

        @Override
        public Object getContainer() {
            return this;
        }

        public void set(String key, NBTBase<?> nbt) {
            ((Map)this.value).put(key, nbt);
        }

        public <T extends NBTBase<?>> T remove(String key) {
            return (T)((NBTBase)((Map)this.value).remove(key));
        }

        public NBTBase<?> removeUnchecked(String key) {
            return (NBTBase)((Map)this.value).remove(key);
        }

        public void setByte(String key, byte value) {
            ((Map)this.getValue()).put(key, new NBTTagByte(value));
        }

        public void setShort(String key, short value) {
            ((Map)this.getValue()).put(key, new NBTTagShort(value));
        }

        public void setInt(String key, int value) {
            ((Map)this.getValue()).put(key, new NBTTagInt(value));
        }

        public void setLong(String key, long value) {
            ((Map)this.getValue()).put(key, new NBTTagLong(value));
        }

        public void setFloat(String key, float value) {
            ((Map)this.getValue()).put(key, new NBTTagFloat(value));
        }

        public void setDouble(String key, double value) {
            ((Map)this.getValue()).put(key, new NBTTagDouble(value));
        }

        public void setString(String key, String value) {
            ((Map)this.getValue()).put(key, new NBTTagString(value));
        }

        public void setStringList(String key, List<String> value) {
            ArrayList strings = new ArrayList(value.size());
            for (String val : value) {
                strings.add(new NBTTagString(val));
            }
            ((Map)this.getValue()).put(key, new NBTTagList(strings));
        }

        public void setCompound(String key, NBTTagCompound compound) {
            ((Map)this.value).put(key, compound);
        }

        public void setByteArray(String key, byte[] value) {
            ((Map)this.getValue()).put(key, new NBTTagByteArray(value));
        }

        public void setIntArray(String key, int[] value) {
            ((Map)this.getValue()).put(key, new NBTTagIntArray(value));
        }

        public void setBoolean(String key, boolean value) {
            this.setByte(key, (byte)(value ? 1 : 0));
        }

        public NBTBase<?> get(String key) {
            return (NBTBase)((Map)this.value).get(key);
        }

        public byte getByte(String key) {
            NBTBase<?> nbt = this.get(key);
            if (!(nbt instanceof NBTTagByte)) {
                return 0;
            }
            return ((NBTTagByte)nbt).getAsByte();
        }

        public short getShort(String key) {
            NBTBase<?> nbt = this.get(key);
            if (!(nbt instanceof NBTTagShort)) {
                return 0;
            }
            return ((NBTTagShort)nbt).getAsShort();
        }

        public int getInt(String key) {
            NBTBase<?> nbt = this.get(key);
            if (!(nbt instanceof NBTTagInt)) {
                return 0;
            }
            return ((NBTTagInt)nbt).getAsShort();
        }

        public long getLong(String key) {
            NBTBase<?> nbt = this.get(key);
            if (!(nbt instanceof NBTTagLong)) {
                return 0L;
            }
            return ((NBTTagLong)nbt).getAsLong();
        }

        public NBTTagCompound getCompound(String key) {
            NBTBase<?> value = this.get(key);
            if (!(value instanceof NBTTagCompound)) {
                return null;
            }
            return (NBTTagCompound)value;
        }

        public float getFloat(String key) {
            NBTBase<?> nbt = this.get(key);
            if (!(nbt instanceof NBTTagFloat)) {
                return 0.0f;
            }
            return ((NBTTagFloat)nbt).getAsFloat();
        }

        public double getDouble(String key) {
            NBTBase<?> nbt = this.get(key);
            if (!(nbt instanceof NBTTagDouble)) {
                return 0.0;
            }
            return ((NBTTagDouble)nbt).getAsDouble();
        }

        public String getString(String key) {
            NBTBase<?> nbt = this.get(key);
            if (!(nbt instanceof NBTTagString)) {
                return null;
            }
            return (String)((NBTTagString)nbt).getValue();
        }

        public List<String> getStringList(String key) {
            NBTBase<?> nbt = this.get(key);
            if (!(nbt instanceof NBTTagList)) {
                return null;
            }
            List values = (List)((NBTTagList)nbt).getValue();
            ArrayList<String> strings = new ArrayList<String>(values.size());
            for (NBTBase val : values) {
                strings.add(String.valueOf(val.value));
            }
            return strings;
        }

        public byte[] getByteArray(String key) {
            NBTBase<?> nbt = this.get(key);
            if (!(nbt instanceof NBTTagByteArray)) {
                return null;
            }
            return (byte[])((NBTTagByteArray)nbt).getValue();
        }

        public int[] getIntArray(String key) {
            NBTBase<?> nbt = this.get(key);
            if (!(nbt instanceof NBTTagIntArray)) {
                return null;
            }
            return (int[])((NBTTagIntArray)nbt).getValue();
        }

        public boolean getBoolean(String key) {
            return this.getByte(key) != 0;
        }

        @Override
        public Object toNBT() {
            try {
                Object compound;
                HashMap<String, Object> map = new HashMap<String, Object>(((Map)this.value).size());
                for (Map.Entry entry : ((Map)this.value).entrySet()) {
                    if (entry.getValue() == this) {
                        throw new IllegalStateException("recursive NBT");
                    }
                    map.put((String)entry.getKey(), ((NBTBase)entry.getValue()).toNBT());
                }
                if (XMaterial.supports(15)) {
                    compound = NBT_TAG_COMPOUND_CONSTRUCTOR.invoke(map);
                } else {
                    compound = NBT_TAG_COMPOUND_CONSTRUCTOR.invoke();
                    SET_COMPOUND_MAP.invoke(compound, map);
                }
                return compound;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(10 + ((Map)this.value).size() * 50);
            builder.append("NBTTagCompound{");
            for (Map.Entry entry : ((Map)this.value).entrySet()) {
                builder.append('\n').append("  ").append((String)entry.getKey()).append(": ").append(entry.getValue());
            }
            return builder.append('\n').append('}').toString();
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class nbtCompound = NBTWrappers.getNBTClass("NBTTagCompound");
            MethodHandle handler = null;
            MethodHandle getMap = null;
            MethodHandle setMap2 = null;
            try {
                Field field = NBTWrappers.getDeclaredField(nbtCompound, new String[]{"x", "map"});
                field.setAccessible(true);
                getMap = lookup.unreflectGetter(field);
                if (XMaterial.supports(15)) {
                    Constructor ctor = nbtCompound.getDeclaredConstructor(Map.class);
                    ctor.setAccessible(true);
                    handler = lookup.unreflectConstructor(ctor);
                } else {
                    handler = lookup.findConstructor(nbtCompound, MethodType.methodType(Void.TYPE));
                    setMap2 = lookup.unreflectSetter(field);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            NBT_TAG_COMPOUND_CONSTRUCTOR = handler;
            GET_COMPOUND_MAP = getMap;
            SET_COMPOUND_MAP = setMap2;
        }
    }

    public static final class NBTTagString
    extends NBTBase<String> {
        private static final MethodHandle CONSTRUCTOR;
        private static final MethodHandle NBT_DATA;

        public NBTTagString(String value) {
            super(value);
        }

        public static NBTTagString fromNBT(Object nbtObject) {
            try {
                return new NBTTagString(NBT_DATA.invoke(nbtObject));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public NBTType<String> getNBTType() {
            return NBTType.STRING;
        }

        @Override
        public Object toNBT() {
            try {
                return CONSTRUCTOR.invoke(this.value == null ? "" : this.value);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagString{" + (String)this.value + '}';
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class clazz = NBTWrappers.getNBTClass("NBTTagString");
            MethodHandle handler = null;
            MethodHandle data = null;
            try {
                handler = XMaterial.supports(15) ? lookup.findStatic(clazz, "a", MethodType.methodType(clazz, String.class)) : lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, String.class));
                Field field = NBTWrappers.getDeclaredField(clazz, new String[]{"A", "data"});
                field.setAccessible(true);
                data = lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            CONSTRUCTOR = handler;
            NBT_DATA = data;
        }
    }

    public static final class NBTTagEnd
    extends NBTBase<Void> {
        private static final MethodHandle NBT_CONSTRUCTOR;

        public NBTTagEnd() {
            super(null);
        }

        public static NBTBase<Void> fromNBT(Object nbtObject) {
            return null;
        }

        @Override
        public Object toNBT() {
            try {
                return NBT_CONSTRUCTOR.invoke();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "NBTTagEnd";
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class stringClass = NBTWrappers.getNBTClass("NBTTagEnd");
            Object handler = null;
            try {
                lookup.findConstructor(stringClass, MethodType.methodType(Void.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            NBT_CONSTRUCTOR = handler;
        }
    }

    public static abstract class NBTBase<T> {
        protected final T value;

        public NBTBase(T value) {
            this.value = value;
        }

        public static NBTBase<?> fromNBT(Object nbtObject) {
            switch (nbtObject.getClass().getSimpleName()) {
                case "NBTTagCompound": {
                    return NBTTagCompound.fromNBT(nbtObject);
                }
                case "NBTTagString": {
                    return NBTTagString.fromNBT(nbtObject);
                }
                case "NBTTagByte": {
                    return NBTTagByte.fromNBT(nbtObject);
                }
                case "NBTTagShort": {
                    return NBTTagShort.fromNBT(nbtObject);
                }
                case "NBTTagInt": {
                    return NBTTagInt.fromNBT(nbtObject);
                }
                case "NBTTagLong": {
                    return NBTTagLong.fromNBT(nbtObject);
                }
                case "NBTTagFloat": {
                    return NBTTagFloat.fromNBT(nbtObject);
                }
                case "NBTTagDouble": {
                    return NBTTagDouble.fromNBT(nbtObject);
                }
                case "NBTTagByteArray": {
                    return NBTTagByteArray.fromNBT(nbtObject);
                }
                case "NBTTagIntArray": {
                    return NBTTagIntArray.fromNBT(nbtObject);
                }
                case "NBTTagLongArray": {
                    return NBTTagLongArray.fromNBT(nbtObject);
                }
                case "NBTTagList": {
                    return NBTTagList.fromNBT(nbtObject);
                }
                case "NBTTagEnd": {
                    return NBTTagEnd.fromNBT(nbtObject);
                }
            }
            throw new UnsupportedOperationException("Unknown NBT type: " + nbtObject.getClass().getSimpleName());
        }

        public final T getValue() {
            return this.value;
        }

        public abstract Object toNBT();
    }
}

