/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.network;

import com.google.common.collect.MapMaker;
import com.mojang.authlib.GameProfile;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.libs.xseries.ReflectionUtils;

public abstract class TinyProtocol {
    private static final AtomicInteger ID = new AtomicInteger(0);
    private static final MethodHandle NETWORK_MANAGER;
    private static final MethodHandle CHANNEL;
    private static final MethodHandle GET_SERVER;
    private static final MethodHandle GET_SERVER_CONNECTION;
    private static final MethodHandle GET_NETWORK_MARKERS;
    private static final Class<?> PacketLoginInStart;
    private static final MethodHandle GET_GAME_PROFILE;
    private final Map<String, Channel> channelLookup = new MapMaker().weakValues().makeMap();
    private final Set<Channel> uninjectedChannels = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());
    private final List<Channel> serverChannels = new ArrayList<Channel>();
    private final String handlerName;
    protected volatile boolean closed;
    protected Plugin plugin;
    private Listener listener;
    private List<Object> networkManagers;
    private ChannelInboundHandlerAdapter serverChannelHandler;
    private ChannelInitializer<Channel> beginInitProtocol;
    private ChannelInitializer<Channel> endInitProtocol;

    public TinyProtocol(final Plugin plugin) {
        this.plugin = plugin;
        this.handlerName = this.getHandlerName();
        this.registerBukkitEvents();
        try {
            try {
                this.registerChannelHandler();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.registerPlayers(plugin);
        }
        catch (IllegalArgumentException ex) {
            plugin.getLogger().info("[TinyProtocol] Delaying server channel injection due to late bind.");
            new BukkitRunnable(){

                public void run() {
                    try {
                        TinyProtocol.this.registerChannelHandler();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    TinyProtocol.this.registerPlayers(plugin);
                    plugin.getLogger().info("[TinyProtocol] Late bind injection successful.");
                }
            }.runTask(plugin);
        }
    }

    private static MethodHandle findFieldOfType(Class<?> clazz, Class<?> type, MethodHandles.Lookup lookup) {
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getType() != type) continue;
            try {
                field.setAccessible(true);
                return lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static MethodHandle getFieldOfGenericType(Class<?> clazz, Class<?> type, Class<?> generic, MethodHandles.Lookup lookup) {
        for (Field field : clazz.getDeclaredFields()) {
            ParameterizedType generics;
            Type arg;
            if (field.getType() != type || (arg = (generics = (ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) != generic) continue;
            try {
                field.setAccessible(true);
                return lookup.unreflectGetter(field);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void createServerChannelHandler() {
        this.endInitProtocol = new ChannelInitializer<Channel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void initChannel(Channel channel) throws Exception {
                try {
                    List list2 = TinyProtocol.this.networkManagers;
                    synchronized (list2) {
                        if (!TinyProtocol.this.closed) {
                            channel.eventLoop().submit(() -> TinyProtocol.this.injectChannelInternal(channel));
                        }
                    }
                }
                catch (Exception e) {
                    TinyProtocol.this.plugin.getLogger().log(Level.SEVERE, "Cannot inject incomming channel " + channel, e);
                }
            }
        };
        this.beginInitProtocol = new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{TinyProtocol.this.endInitProtocol});
            }
        };
        this.serverChannelHandler = new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                Channel channel = (Channel)msg;
                channel.pipeline().addFirst(new ChannelHandler[]{TinyProtocol.this.beginInitProtocol});
                ctx.fireChannelRead(msg);
            }
        };
    }

    private void registerBukkitEvents() {
        this.listener = new Listener(){

            @EventHandler(priority=EventPriority.LOWEST)
            public void onPlayerLogin(PlayerLoginEvent e) {
                if (TinyProtocol.this.closed) {
                    return;
                }
                Channel channel = TinyProtocol.this.getChannel(e.getPlayer());
                if (!TinyProtocol.this.uninjectedChannels.contains(channel)) {
                    TinyProtocol.this.injectPlayer(e.getPlayer());
                }
            }

            @EventHandler
            public void onPluginDisable(PluginDisableEvent e) {
                if (e.getPlugin().equals(TinyProtocol.this.plugin)) {
                    TinyProtocol.this.close();
                }
            }
        };
        this.plugin.getServer().getPluginManager().registerEvents(this.listener, this.plugin);
    }

    private void registerChannelHandler() throws Throwable {
        Object mcServer = GET_SERVER.invoke(Bukkit.getServer());
        Object serverConnection = GET_SERVER_CONNECTION.invoke(mcServer);
        this.networkManagers = GET_NETWORK_MARKERS.invoke(serverConnection);
        this.createServerChannelHandler();
        MethodHandle listeningChannels = TinyProtocol.getFieldOfGenericType(serverConnection.getClass(), List.class, ChannelFuture.class, MethodHandles.lookup());
        List list2 = listeningChannels.invoke(serverConnection);
        for (ChannelFuture item : list2) {
            Channel serverChannel = item.channel();
            this.serverChannels.add(serverChannel);
            serverChannel.pipeline().addFirst(new ChannelHandler[]{this.serverChannelHandler});
        }
    }

    private void unregisterChannelHandler() {
        if (this.serverChannelHandler == null) {
            return;
        }
        for (Channel serverChannel : this.serverChannels) {
            final ChannelPipeline pipeline = serverChannel.pipeline();
            serverChannel.eventLoop().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        pipeline.remove((ChannelHandler)TinyProtocol.this.serverChannelHandler);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private void registerPlayers(Plugin plugin) {
        for (Player player : plugin.getServer().getOnlinePlayers()) {
            this.injectPlayer(player);
        }
    }

    public abstract Object onPacketOutAsync(Player var1, Channel var2, Object var3);

    public abstract Object onPacketInAsync(Player var1, Channel var2, Object var3);

    public void sendPacket(Player player, Object packet) {
        this.sendPacket(this.getChannel(player), packet);
    }

    public void sendPacket(Channel channel, Object packet) {
        channel.pipeline().writeAndFlush(packet);
    }

    public void receivePacket(Player player, Object packet) {
        this.receivePacket(this.getChannel(player), packet);
    }

    public void receivePacket(Channel channel, Object packet) {
        channel.pipeline().context("encoder").fireChannelRead(packet);
    }

    protected String getHandlerName() {
        return "tiny-" + this.plugin.getName() + '-' + ID.incrementAndGet();
    }

    public void injectPlayer(Player player) {
        this.injectChannelInternal((Channel)this.getChannel((Player)player)).player = player;
    }

    public void injectChannel(Channel channel) {
        this.injectChannelInternal(channel);
    }

    private PacketInterceptor injectChannelInternal(Channel channel) {
        try {
            PacketInterceptor interceptor = (PacketInterceptor)channel.pipeline().get(this.handlerName);
            if (interceptor == null) {
                interceptor = new PacketInterceptor();
                channel.pipeline().addBefore("packet_handler", this.handlerName, (ChannelHandler)interceptor);
                this.uninjectedChannels.remove(channel);
            }
            return interceptor;
        }
        catch (IllegalArgumentException e) {
            return (PacketInterceptor)channel.pipeline().get(this.handlerName);
        }
    }

    public Channel getChannel(Player player) {
        Channel channel = this.channelLookup.get(player.getName());
        if (channel == null) {
            try {
                Object connection = ReflectionUtils.getConnection(player);
                Object manager = NETWORK_MANAGER.invoke(connection);
                channel = CHANNEL.invoke(manager);
                this.channelLookup.put(player.getName(), channel);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        return channel;
    }

    public void uninjectPlayer(Player player) {
        this.uninjectChannel(this.getChannel(player));
    }

    public void uninjectChannel(final Channel channel) {
        if (!this.closed) {
            this.uninjectedChannels.add(channel);
        }
        channel.eventLoop().execute(new Runnable(){

            @Override
            public void run() {
                channel.pipeline().remove(TinyProtocol.this.handlerName);
            }
        });
    }

    public boolean hasInjected(Player player) {
        return this.hasInjected(this.getChannel(player));
    }

    public boolean hasInjected(Channel channel) {
        return channel.pipeline().get(this.handlerName) != null;
    }

    public final void close() {
        if (!this.closed) {
            this.closed = true;
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                this.uninjectPlayer(player);
            }
            HandlerList.unregisterAll((Listener)this.listener);
            this.unregisterChannelHandler();
        }
    }

    static {
        PacketLoginInStart = ReflectionUtils.getNMSClass("network.protocol.login", "PacketLoginInStart");
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle networkManager = null;
        MethodHandle channel = null;
        MethodHandle console = null;
        MethodHandle connection = null;
        MethodHandle getNetworkMarkers = null;
        MethodHandle getGameProfile = null;
        Class<?> PlayerConnection = ReflectionUtils.getNMSClass("server.network", "PlayerConnection");
        Class<?> NetworkManager = ReflectionUtils.getNMSClass("network", "NetworkManager");
        Class<?> MinecraftServer2 = ReflectionUtils.getNMSClass("server", "MinecraftServer");
        Class<?> ServerConnection = ReflectionUtils.getNMSClass("server.network", "ServerConnection");
        Class<?> CraftServer = ReflectionUtils.getCraftClass("CraftServer");
        try {
            networkManager = TinyProtocol.findFieldOfType(PlayerConnection, NetworkManager, lookup);
            channel = lookup.findGetter(NetworkManager, ReflectionUtils.supports(17) ? "k" : "channel", Channel.class);
            Field consoleField = CraftServer.getDeclaredField("console");
            consoleField.setAccessible(true);
            console = lookup.unreflectGetter(consoleField);
            connection = TinyProtocol.findFieldOfType(MinecraftServer2, ServerConnection, lookup);
            getNetworkMarkers = TinyProtocol.getFieldOfGenericType(ServerConnection, List.class, NetworkManager, lookup);
            getGameProfile = TinyProtocol.findFieldOfType(PacketLoginInStart, GameProfile.class, lookup);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        NETWORK_MANAGER = networkManager;
        CHANNEL = channel;
        GET_SERVER = console;
        GET_SERVER_CONNECTION = connection;
        GET_NETWORK_MARKERS = getNetworkMarkers;
        GET_GAME_PROFILE = getGameProfile;
    }

    private final class PacketInterceptor
    extends ChannelDuplexHandler {
        public volatile Player player;

        private PacketInterceptor() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            Channel channel = ctx.channel();
            this.handleLoginStart(channel, msg);
            try {
                msg = TinyProtocol.this.onPacketInAsync(this.player, channel, msg);
            }
            catch (Exception e) {
                TinyProtocol.this.plugin.getLogger().log(Level.SEVERE, "Error in onPacketInAsync().", e);
            }
            if (msg != null) {
                super.channelRead(ctx, msg);
            }
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            try {
                msg = TinyProtocol.this.onPacketOutAsync(this.player, ctx.channel(), msg);
            }
            catch (Exception e) {
                TinyProtocol.this.plugin.getLogger().log(Level.SEVERE, "Error in onPacketOutAsync().", e);
            }
            if (msg != null) {
                super.write(ctx, msg, promise);
            }
        }

        private void handleLoginStart(Channel channel, Object packet) {
            if (PacketLoginInStart.isInstance(packet)) {
                GameProfile profile = null;
                try {
                    profile = GET_GAME_PROFILE.invoke(packet);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                TinyProtocol.this.channelLookup.put(profile.getName(), channel);
            }
        }
    }
}

