/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.nms;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.ReflectionUtils;
import org.kingdoms.libs.xseries.XPotion;
import org.kingdoms.utils.nms.EntityFactory;

public final class HologramFactory {
    private static final MethodHandle ENTITY_ARMOR_STAND_CTOR;
    private static final MethodHandle PACKET_PLAY_OUT_ENTITY_METADATA_CTOR;
    private static final MethodHandle SET_MARKER;
    private static final MethodHandle SET_INVISIBLE;
    private static final MethodHandle SET_CUSTOM_NAME_VISIBLE;
    private static final MethodHandle SET_CUSTOM_NAME;
    private static final MethodHandle FROM_STRING_OR_NULL;
    private static final MethodHandle GET_ENTITY_DATA_WATCHER;
    private static final MethodHandle WATCHER_PACK;
    private static final PotionEffect LEVITATION;

    public static ArmorStand spawnUpwards(Location location, String text) {
        ArmorStand armorstand = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        armorstand.setVisible(false);
        armorstand.addPotionEffect(LEVITATION);
        armorstand.setCustomName(text);
        armorstand.setCustomNameVisible(true);
        EntityFactory.addTemporaryEntity((Entity)armorstand);
        return armorstand;
    }

    public static ArmorStand spawn(Location location, Collection<? extends Player> showTo, @NonNull String description) {
        return HologramFactory.spawn(location, showTo, (ArmorStand armorStand) -> {
            armorStand.setVisible(false);
            armorStand.setMarker(true);
            armorStand.setCustomNameVisible(true);
            armorStand.setCustomName(description);
        });
    }

    public static ArmorStand spawn(Location location, Collection<? extends Player> showTo, @NonNull Consumer<ArmorStand> handler) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(showTo);
        Objects.requireNonNull(handler);
        try {
            Object nmsArmorStand = ENTITY_ARMOR_STAND_CTOR.invoke(EntityFactory.getNMSWorld(location.getWorld()), location.getX(), location.getY(), location.getZ());
            ArmorStand armorStand = (ArmorStand)EntityFactory.getBukkitEntity(nmsArmorStand);
            handler.accept(armorStand);
            Object spawnPacket = EntityFactory.createSpawnPacket(nmsArmorStand);
            Object watcher = GET_ENTITY_DATA_WATCHER.invoke(nmsArmorStand);
            Object packetPlayOutEntityMetadata = ReflectionUtils.supports(19) ? PACKET_PLAY_OUT_ENTITY_METADATA_CTOR.invoke(nmsArmorStand.hashCode(), WATCHER_PACK.invoke(watcher)) : PACKET_PLAY_OUT_ENTITY_METADATA_CTOR.invoke(nmsArmorStand.hashCode(), watcher, false);
            for (Player player : showTo) {
                ReflectionUtils.sendPacketSync(player, spawnPacket, packetPlayOutEntityMetadata);
            }
            return armorStand;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static {
        Class<?> chatComponent = ReflectionUtils.getNMSClass("network.chat", "IChatBaseComponent");
        Class<?> craftChatMessage = ReflectionUtils.getCraftClass("util.CraftChatMessage");
        Class<?> EntityArmorStand = ReflectionUtils.getNMSClass("world.entity.decoration", "EntityArmorStand");
        Class<?> PacketPlayOutEntityMetadata = ReflectionUtils.getNMSClass("network.protocol.game", "PacketPlayOutEntityMetadata");
        Class<?> DataWatcher = ReflectionUtils.getNMSClass("network.syncher", "DataWatcher");
        Class<?> NMSEntity = ReflectionUtils.getNMSClass("world.entity", "Entity");
        Class<?> NMSWorld = ReflectionUtils.getNMSClass("world.level", "World");
        Class<?> CraftArmorStand = ReflectionUtils.getCraftClass("entity.CraftArmorStand");
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle fromStringOrNull = null;
        MethodHandle EntityArmorStandCtor = null;
        MethodHandle PacketPlayOutEntityMetadataCtor = null;
        MethodHandle watcherPack = null;
        MethodHandle getEntityDataWatcher = null;
        MethodHandle setMarker = null;
        MethodHandle setCustomNameVisible = null;
        MethodHandle setInvisible = null;
        MethodHandle setCustomName = null;
        try {
            EntityArmorStandCtor = lookup.findConstructor(EntityArmorStand, MethodType.methodType(Void.TYPE, NMSWorld, Double.TYPE, Double.TYPE, Double.TYPE));
            PacketPlayOutEntityMetadataCtor = lookup.findConstructor(PacketPlayOutEntityMetadata, ReflectionUtils.v(19, MethodType.methodType(Void.TYPE, Integer.TYPE, List.class)).orElse(MethodType.methodType(Void.TYPE, Integer.TYPE, DataWatcher, Boolean.TYPE)));
            getEntityDataWatcher = lookup.findVirtual(NMSEntity, ReflectionUtils.v(19, "aj").v(18, "ai").orElse("getDataWatcher"), MethodType.methodType(DataWatcher));
            watcherPack = lookup.findVirtual(DataWatcher, "b", MethodType.methodType(List.class));
            setMarker = lookup.findVirtual(CraftArmorStand, "setMarker", MethodType.methodType(Void.TYPE, Boolean.TYPE));
            setCustomNameVisible = lookup.findVirtual(CraftArmorStand, "setCustomNameVisible", MethodType.methodType(Void.TYPE, Boolean.TYPE));
            setInvisible = lookup.findVirtual(CraftArmorStand, ReflectionUtils.v(13, "setInvisible").orElse("setVisible"), MethodType.methodType(Void.TYPE, Boolean.TYPE));
            setCustomName = lookup.findVirtual(CraftArmorStand, "setCustomName", MethodType.methodType(Void.TYPE, String.class));
            fromStringOrNull = lookup.findStatic(craftChatMessage, ReflectionUtils.v(13, "fromStringOrNull").orElse("fromString"), ReflectionUtils.v(13, MethodType.methodType(chatComponent, String.class, Boolean.TYPE)).orElse(MethodType.methodType(Array.newInstance(chatComponent, 0).getClass(), String.class, Boolean.TYPE)));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        ENTITY_ARMOR_STAND_CTOR = EntityArmorStandCtor;
        PACKET_PLAY_OUT_ENTITY_METADATA_CTOR = PacketPlayOutEntityMetadataCtor;
        SET_MARKER = setMarker;
        SET_INVISIBLE = setInvisible;
        SET_CUSTOM_NAME_VISIBLE = setCustomNameVisible;
        SET_CUSTOM_NAME = setCustomName;
        FROM_STRING_OR_NULL = fromStringOrNull;
        GET_ENTITY_DATA_WATCHER = getEntityDataWatcher;
        WATCHER_PACK = watcherPack;
        LEVITATION = XPotion.LEVITATION.buildPotionEffect(200, 1);
    }
}

