/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.platform;

import java.util.stream.Stream;
import org.bukkit.entity.Player;
import org.geysermc.floodgate.api.FloodgateApi;
import org.kingdoms.main.KLogger;
import org.kingdoms.utils.platform.Platform;

public final class CrossPlatformNotifier {
    protected static boolean isRunningForge() {
        String fml = "net.minecraftforge.fml.";
        return Stream.of("common.Mod", "common.Loader", "common.FMLContainer", "ModLoader", "client.FMLClientHandler", "server.ServerMain").anyMatch(x -> CrossPlatformNotifier.classExists(fml + x));
    }

    protected static boolean isRunningGeyser() {
        String geyser = "org.geysermc";
        return Stream.of("geyser.GeyserMain", "geyser.Constants", "connector.GeyserConnector", "connector.network.session.GeyserSession", "api.Geyser", "api.connection.Connection").anyMatch(x -> CrossPlatformNotifier.classExists(geyser + x));
    }

    public static boolean isFloodgatePlayer(Player player) {
        return Platform.BEDROCK.isAvailable() && FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId());
    }

    protected static boolean isRunningBukkit() {
        return CrossPlatformNotifier.classExists("org.bukkit.entity.Player") && CrossPlatformNotifier.classExists("org.bukkit.Bukkit");
    }

    protected static boolean isRunningPaper() {
        return CrossPlatformNotifier.classExists("com.destroystokyo.paper.PaperConfig") || CrossPlatformNotifier.classExists("io.papermc.paper.configuration.Configuration");
    }

    public static boolean isRunningSpigot() {
        return CrossPlatformNotifier.classExists("org.spigotmc.SpigotConfig");
    }

    public static void warn() {
        if (Platform.FORGE.isAvailable()) {
            KLogger.warn("-----------------------------------------------------------------------------------------------");
            KLogger.warn("Your server is running on a platform that supports Forge. The plugin may not function properly.");
            KLogger.warn("-----------------------------------------------------------------------------------------------");
        }
        if (Platform.BEDROCK.isAvailable()) {
            KLogger.warn("-----------------------------------------------------------------------------------------------");
            KLogger.warn("Your server is running on a platform that supports Bedrock Edition. The plugin may not function properly.");
            KLogger.warn("-----------------------------------------------------------------------------------------------");
        }
    }

    private static boolean classExists(String clazz) {
        try {
            Class.forName(clazz, false, CrossPlatformNotifier.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return true;
        }
    }
}

