/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.animation;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.animation.property.IAnimationProperty;
import com.ticxo.modelengine.api.animation.script.ScriptFunction;
import com.ticxo.modelengine.api.animation.script.ScriptReader;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.model.bone.Nameable;
import com.ticxo.modelengine.api.model.handler.RendererHandler;
import com.ticxo.modelengine.api.nms.entity.fake.BoneRenderer;
import com.ticxo.modelengine.api.utils.logger.TLogger;
import com.ticxo.modelengine.api.utils.registry.TSingletonRegistry;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.Color;

public class ModelEngineScriptReader
extends TSingletonRegistry<ScriptFunction>
implements ScriptReader {
    public ModelEngineScriptReader() {
        this.register("changeparent", this::changeParent);
        this.register("partvis", this::partVisibility);
        this.register("tint", this::tint);
        this.register("enchant", this::enchant);
        this.register("tag", this::tag);
        this.register("changepart", this::changePart);
        this.register("remap", this::remap);
    }

    @Override
    public void read(IAnimationProperty iAnimationProperty, String string) {
        String[] stringArray;
        ActiveModel activeModel = iAnimationProperty.getModel();
        ModelBlueprint modelBlueprint = activeModel.getBlueprint();
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        String[] stringArray2 = string.split("\\{", 2);
        String string2 = stringArray2[0].toLowerCase(Locale.ENGLISH);
        if (stringArray2.length == 2) {
            for (String string3 : stringArray = stringArray2[1].substring(0, stringArray2[1].length() - 1).split(";")) {
                String[] stringArray3 = string3.split("=", 2);
                concurrentMap.put(stringArray3[0].strip(), stringArray3.length == 2 ? this.getAnimationPlaceholder(modelBlueprint, stringArray3[1].strip()) : "");
            }
        }
        if ((stringArray = (String[])this.get(string2)) != null) {
            stringArray.call(activeModel, concurrentMap);
        } else {
            TLogger.warn("Unknown Model Engine script: " + string);
        }
    }

    private void changeParent(ActiveModel activeModel, Map<String, String> map) {
        String string = map.get("parent");
        String string2 = map.get("child");
        Map<String, ModelBone> map2 = activeModel.getBoneIndex();
        ModelBone modelBone = map2.get(string);
        ModelBone modelBone2 = map2.get(string2);
        if (modelBone != null && modelBone2 != null) {
            modelBone.addChild(modelBone2);
        }
    }

    private void partVisibility(ActiveModel activeModel, Map<String, String> map) {
        String string = map.get("part");
        boolean bl = Boolean.parseBoolean(map.get("visible"));
        boolean bl2 = Boolean.parseBoolean(map.get("exact"));
        Map map2 = activeModel.getRendererHandler().getFakeEntity();
        if (bl2) {
            if (map2.containsKey(string)) {
                ((BoneRenderer)map2.get(string)).setModelVisible(bl);
            }
        } else {
            for (String string2 : map2.keySet()) {
                if (!string2.contains(string)) continue;
                ((BoneRenderer)map2.get(string)).setModelVisible(bl);
            }
        }
    }

    private void tint(ActiveModel activeModel, Map<String, String> map) {
        String string = map.get("part");
        String string2 = map.get("color");
        if (string2.startsWith("#")) {
            string2 = string2.substring(1);
        }
        Color color = Color.fromRGB((int)Integer.parseInt(string2, 16));
        boolean bl = Boolean.parseBoolean(map.get("exact"));
        Map map2 = activeModel.getRendererHandler().getFakeEntity();
        if (bl) {
            if (map2.containsKey(string)) {
                ((BoneRenderer)map2.get(string)).setColor(color);
            }
        } else {
            for (String string3 : map2.keySet()) {
                if (!string3.contains(string)) continue;
                ((BoneRenderer)map2.get(string3)).setColor(color);
            }
        }
    }

    private void enchant(ActiveModel activeModel, Map<String, String> map) {
        String string = map.get("part");
        boolean bl = Boolean.parseBoolean(map.get("enchant"));
        boolean bl2 = Boolean.parseBoolean(map.get("exact"));
        Map map2 = activeModel.getRendererHandler().getFakeEntity();
        if (bl2) {
            if (map2.containsKey(string)) {
                ((BoneRenderer)map2.get(string)).setEnchant(bl);
            }
        } else {
            for (String string2 : map2.keySet()) {
                if (!string2.contains(string)) continue;
                ((BoneRenderer)map2.get(string2)).setEnchant(bl);
            }
        }
    }

    private void tag(ActiveModel activeModel, Map<String, String> map) {
        String string = map.get("part");
        String string2 = map.get("tag");
        boolean bl = Boolean.parseBoolean(map.getOrDefault("visible", "true"));
        Nameable nameable = (Nameable)activeModel.getNametagHandler().getBones().get(string);
        if (nameable == null) {
            return;
        }
        if (string2 != null) {
            nameable.setCustomName(string2);
        }
        nameable.setCustomNameVisible(bl);
    }

    private void changePart(ActiveModel activeModel, Map<String, String> map) {
        ModelBlueprint modelBlueprint;
        String string = map.get("part");
        String string2 = map.get("nmodel");
        String string3 = map.get("npart");
        BoneRenderer boneRenderer = (BoneRenderer)activeModel.getRendererHandler().getFakeEntity().get(string);
        if (boneRenderer == null) {
            return;
        }
        ModelBlueprint modelBlueprint2 = modelBlueprint = string2 != null ? ModelEngineAPI.getBlueprint(string2) : activeModel.getBlueprint();
        if (modelBlueprint == null) {
            return;
        }
        Integer n = modelBlueprint.getItemIds().get(string3);
        if (n == null) {
            return;
        }
        boneRenderer.setData(n);
    }

    private void remap(ActiveModel activeModel, Map<String, String> map) {
        String string = map.get("model");
        String string2 = map.get("map");
        ModelBlueprint modelBlueprint = ModelEngineAPI.getBlueprint(string);
        if (modelBlueprint == null) {
            return;
        }
        if (string2 != null) {
            ModelBlueprint modelBlueprint2 = ModelEngineAPI.getBlueprint(string2);
            if (modelBlueprint2 == null) {
                return;
            }
            RendererHandler rendererHandler = activeModel.getRendererHandler();
            Set<String> set = modelBlueprint2.getFlatMap().size() < rendererHandler.getFakeEntity().size() ? modelBlueprint2.getFlatMap().keySet() : rendererHandler.getFakeEntity().keySet();
            for (String string3 : set) {
                BoneRenderer boneRenderer;
                Integer n = modelBlueprint.getItemIds().get(string3);
                if (n == null || (boneRenderer = (BoneRenderer)rendererHandler.getFakeEntity().get(string3)) == null) continue;
                boneRenderer.setData(n);
            }
        } else {
            RendererHandler rendererHandler = activeModel.getRendererHandler();
            Set<String> set = modelBlueprint.getItemIds().size() < rendererHandler.getFakeEntity().size() ? modelBlueprint.getItemIds().keySet() : rendererHandler.getFakeEntity().keySet();
            for (String string4 : set) {
                BoneRenderer boneRenderer;
                Integer n = modelBlueprint.getItemIds().get(string4);
                if (n == null || (boneRenderer = (BoneRenderer)rendererHandler.getFakeEntity().get(string4)) == null) continue;
                boneRenderer.setData(n);
            }
        }
    }

    private String getAnimationPlaceholder(ModelBlueprint modelBlueprint, String string) {
        if (!string.startsWith("<") || !string.endsWith(">")) {
            return string;
        }
        String string2 = string.substring(1, string.length() - 1);
        return modelBlueprint.getAnimationsPlaceholders().getOrDefault(string2, string);
    }
}

