/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.animation.property;

import com.ticxo.modelengine.api.animation.blueprint.BlueprintAnimation;
import com.ticxo.modelengine.api.animation.blueprint.LoopMode;
import com.ticxo.modelengine.api.animation.keyframe.type.ScriptKeyframe;
import com.ticxo.modelengine.api.animation.property.IAnimationProperty;
import com.ticxo.modelengine.api.model.ActiveModel;
import java.util.List;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class SimpleProperty
implements IAnimationProperty {
    private final ActiveModel model;
    private final BlueprintAnimation blueprintAnimation;
    private final double lerpIn;
    private final double lerpOut;
    private double lerpInTime = 0.0;
    private double lerpOutTime = 0.0;
    private double time = 0.0;
    private double speed;
    private IAnimationProperty.Phase phase = IAnimationProperty.Phase.LERPIN;
    private LoopMode forceLoopMode = null;
    private boolean forceOverride = false;

    public SimpleProperty(ActiveModel activeModel, BlueprintAnimation blueprintAnimation) {
        this(activeModel, blueprintAnimation, 0.0, 0.0, 1.0);
    }

    public SimpleProperty(ActiveModel activeModel, BlueprintAnimation blueprintAnimation, double d, double d2, double d3) {
        this.model = activeModel;
        this.blueprintAnimation = blueprintAnimation;
        this.lerpIn = d;
        this.lerpOut = d2;
        this.speed = d3;
    }

    @Override
    public boolean update() {
        return switch (this.phase) {
            case IAnimationProperty.Phase.LERPIN -> this.updateLerpIn();
            case IAnimationProperty.Phase.PLAY -> this.updateTime();
            case IAnimationProperty.Phase.LERPOUT -> this.updateLerpOut();
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private boolean updateLerpIn() {
        if (this.lerpInTime >= this.lerpIn - 1.0E-5) {
            return this.updateTime();
        }
        this.lerpInTime += this.speed / 20.0;
        return true;
    }

    private boolean updateTime() {
        if (this.phase == IAnimationProperty.Phase.LERPIN) {
            this.phase = IAnimationProperty.Phase.PLAY;
            return true;
        }
        LoopMode loopMode = this.forceLoopMode == null ? this.blueprintAnimation.getLoopMode() : this.forceLoopMode;
        switch (loopMode) {
            case ONCE: {
                if (this.time < this.blueprintAnimation.getLength()) {
                    this.time = Math.min(this.time + this.speed / 20.0, this.blueprintAnimation.getLength());
                    return true;
                }
                return this.updateLerpOut();
            }
            case HOLD: {
                this.time = Math.min(this.time + this.speed / 20.0, this.blueprintAnimation.getLength());
                return true;
            }
            case LOOP: {
                this.time = (this.time + this.speed / 20.0) % (this.blueprintAnimation.getLength() + 0.05);
                return true;
            }
        }
        return false;
    }

    private boolean updateLerpOut() {
        if (this.phase == IAnimationProperty.Phase.PLAY && this.lerpOut > 1.0E-5) {
            this.phase = IAnimationProperty.Phase.LERPOUT;
            return true;
        }
        if (this.lerpOutTime >= this.lerpOut - 1.0E-5) {
            return false;
        }
        this.lerpOutTime += this.speed / 20.0;
        return true;
    }

    @Override
    public void stop() {
        this.phase = IAnimationProperty.Phase.LERPOUT;
    }

    @Override
    public String getName() {
        return this.blueprintAnimation.getName();
    }

    @Override
    public Vector getPositionFrame(String string) {
        return this.blueprintAnimation.getPosition(string, this);
    }

    @Override
    public EulerAngle getRotationFrame(String string) {
        return this.blueprintAnimation.getRotation(string, this);
    }

    @Override
    public List<ScriptKeyframe.Script> getScriptFrame() {
        return this.blueprintAnimation.getScripts(this);
    }

    @Override
    public double getLerpInRatio() {
        return this.lerpInTime / this.lerpIn;
    }

    @Override
    public double getLerpOutRatio() {
        return this.lerpOutTime / this.lerpOut;
    }

    @Override
    public boolean isFinished() {
        return this.phase == IAnimationProperty.Phase.LERPOUT || this.time >= this.blueprintAnimation.getLength();
    }

    @Override
    public boolean isOverride() {
        return this.blueprintAnimation.isOverride();
    }

    public String toString() {
        return "SimpleProperty(model=" + this.getModel() + ", blueprintAnimation=" + this.getBlueprintAnimation() + ", lerpIn=" + this.getLerpIn() + ", lerpOut=" + this.getLerpOut() + ", lerpInTime=" + this.getLerpInTime() + ", lerpOutTime=" + this.getLerpOutTime() + ", time=" + this.getTime() + ", speed=" + this.getSpeed() + ", phase=" + this.getPhase() + ", forceLoopMode=" + this.getForceLoopMode() + ", forceOverride=" + this.isForceOverride() + ")";
    }

    @Override
    public ActiveModel getModel() {
        return this.model;
    }

    public BlueprintAnimation getBlueprintAnimation() {
        return this.blueprintAnimation;
    }

    @Override
    public double getLerpIn() {
        return this.lerpIn;
    }

    @Override
    public double getLerpOut() {
        return this.lerpOut;
    }

    @Override
    public double getLerpInTime() {
        return this.lerpInTime;
    }

    @Override
    public void setLerpInTime(double d) {
        this.lerpInTime = d;
    }

    @Override
    public double getLerpOutTime() {
        return this.lerpOutTime;
    }

    @Override
    public void setLerpOutTime(double d) {
        this.lerpOutTime = d;
    }

    @Override
    public double getTime() {
        return this.time;
    }

    @Override
    public double getSpeed() {
        return this.speed;
    }

    @Override
    public void setSpeed(double d) {
        this.speed = d;
    }

    @Override
    public IAnimationProperty.Phase getPhase() {
        return this.phase;
    }

    @Override
    public LoopMode getForceLoopMode() {
        return this.forceLoopMode;
    }

    @Override
    public void setForceLoopMode(LoopMode loopMode) {
        this.forceLoopMode = loopMode;
    }

    @Override
    public boolean isForceOverride() {
        return this.forceOverride;
    }

    @Override
    public void setForceOverride(boolean bl) {
        this.forceOverride = bl;
    }
}

