/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.command;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.command.annotations.CommandAccessible;
import com.ticxo.modelengine.api.command.annotations.CommandAttribute;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.mount.controller.MountController;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public final class CommandParser {
    private static final Map<Class<?>, Function<String, ?>> parsers = Maps.newConcurrentMap();
    private static final Map<Class<?>, TabCompleter> tabCompleter = Maps.newConcurrentMap();

    public static void execute(Object object, String ... stringArray) {
        try {
            Set set = Sets.newConcurrentHashSet();
            block2: for (int i = 0; i < stringArray.length; ++i) {
                CommandAccessible commandAccessible = object.getClass().getAnnotation(CommandAccessible.class);
                if (commandAccessible == null) {
                    return;
                }
                String string = stringArray[i];
                set.clear();
                set.add(object.getClass());
                set.addAll(List.of(commandAccessible.value()));
                for (Class clazz : set) {
                    for (Method method : clazz.getMethods()) {
                        CommandAttribute commandAttribute = method.getAnnotation(CommandAttribute.class);
                        if (commandAttribute == null || !commandAttribute.tag().equals(string)) continue;
                        Class<?>[] classArray = method.getParameterTypes();
                        Object[] objectArray = new Object[method.getParameterCount()];
                        for (int j = 0; j < classArray.length; ++j) {
                            if (++i >= stringArray.length) {
                                return;
                            }
                            objectArray[j] = CommandParser.tryParse(classArray[j], stringArray[i]);
                        }
                        Object object2 = method.invoke(object, objectArray);
                        if (method.getReturnType() == Void.TYPE) {
                            return;
                        }
                        object = object2;
                        continue block2;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static List<String> tabComplete(Object object, String ... stringArray) {
        Class<?> clazz = object.getClass();
        ArrayList<String> arrayList = new ArrayList<String>();
        Set set = Sets.newConcurrentHashSet();
        block0: for (int i = 0; i < stringArray.length; ++i) {
            CommandAccessible commandAccessible = clazz.getAnnotation(CommandAccessible.class);
            if (commandAccessible == null) {
                return List.of();
            }
            String string = stringArray[i];
            arrayList.clear();
            set.clear();
            set.add(clazz);
            set.addAll(List.of(commandAccessible.value()));
            for (Class clazz2 : set) {
                for (Method method : clazz2.getMethods()) {
                    CommandAttribute commandAttribute = method.getAnnotation(CommandAttribute.class);
                    if (commandAttribute == null) continue;
                    arrayList.add(commandAttribute.tag());
                    if (!commandAttribute.tag().equals(string) || i >= stringArray.length - 1) continue;
                    int n = i + method.getParameterCount();
                    if (n < stringArray.length - 1) {
                        clazz = method.getReturnType();
                        i = n;
                        continue block0;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    String[] stringArray2 = commandAttribute.hints();
                    Class<?>[] classArray = method.getParameterTypes();
                    if (stringArray2.length > 0) {
                        for (var19_20 = stringArray.length - 2 - i; var19_20 < stringArray2.length; ++var19_20) {
                            stringBuilder.append(stringArray2[var19_20]).append(" ");
                        }
                    } else {
                        for (var19_20 = stringArray.length - 2 - i; var19_20 < classArray.length; ++var19_20) {
                            stringBuilder.append(classArray[var19_20].getSimpleName()).append(" ");
                        }
                    }
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    arrayList2.add(stringBuilder.toString().trim());
                    Class<?> clazz3 = classArray[stringArray.length - 2 - i];
                    TabCompleter tabCompleter = CommandParser.tabCompleter.get(clazz3);
                    if (tabCompleter != null) {
                        arrayList2.addAll(tabCompleter.getSuggestions());
                    }
                    return arrayList2;
                }
            }
        }
        String string = stringArray[stringArray.length - 1];
        arrayList.removeIf(string2 -> !string2.startsWith(string));
        return arrayList;
    }

    public static Object tryParse(Class<?> clazz, String string) {
        Function<String, ?> function = parsers.get(clazz);
        if (function != null) {
            try {
                return function.apply(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    private static List<String> getPlayers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Bukkit.getOnlinePlayers().forEach(player -> arrayList.add(player.getName()));
        return arrayList;
    }

    static {
        parsers.put(String.class, string -> string);
        parsers.put(Integer.TYPE, Integer::parseInt);
        parsers.put(Integer.class, Integer::parseInt);
        parsers.put(Double.TYPE, Double::parseDouble);
        parsers.put(Double.class, Double::parseDouble);
        parsers.put(Float.TYPE, Float::parseFloat);
        parsers.put(Float.class, Float::parseFloat);
        parsers.put(Boolean.TYPE, Boolean::parseBoolean);
        parsers.put(Boolean.class, Boolean::parseBoolean);
        parsers.put(Player.class, Bukkit::getPlayer);
        parsers.put(Entity.class, Bukkit::getPlayer);
        parsers.put(ActiveModel.class, ModelEngineAPI::createActiveModel);
        parsers.put(MountController.class, string -> ModelEngineAPI.getControllerRegistry().get((String)string));
        tabCompleter.put(Player.class, CommandParser::getPlayers);
        tabCompleter.put(Entity.class, CommandParser::getPlayers);
        tabCompleter.put(ActiveModel.class, () -> new ArrayList<String>(ModelEngineAPI.api.getModelRegistry().getAllBlueprintId()));
        tabCompleter.put(MountController.class, () -> new ArrayList<String>(ModelEngineAPI.getControllerRegistry().getKeys()));
    }

    @FunctionalInterface
    public static interface TabCompleter {
        public List<String> getSuggestions();
    }
}

