/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.entity;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.generator.Hitbox;
import com.ticxo.modelengine.api.model.IModel;
import com.ticxo.modelengine.api.nms.entity.hitbox.ModelHitbox;
import com.ticxo.modelengine.api.nms.entity.impl.DefaultBodyRotationController;
import com.ticxo.modelengine.api.nms.entity.wrapper.BodyRotationController;
import com.ticxo.modelengine.api.nms.entity.wrapper.LookController;
import com.ticxo.modelengine.api.nms.entity.wrapper.MoveController;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.api.nms.world.IDamageSource;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BukkitEntity
implements BaseEntity<Entity> {
    private final Entity original;
    private RangeManager rangeManager;
    private Double stepHeight;
    private Hitbox hitbox;
    private ModelHitbox modelHitbox;

    public BukkitEntity(@NotNull Entity entity) {
        this.original = entity;
    }

    @Override
    public MoveController wrapMoveControl() {
        return ModelEngineAPI.getEntityHandler().wrapMoveControl(this.original);
    }

    @Override
    public LookController wrapLookControl() {
        return ModelEngineAPI.getEntityHandler().wrapLookControl(this.original);
    }

    @Override
    public BodyRotationController wrapBodyRotationControl() {
        BodyRotationController bodyRotationController = ModelEngineAPI.getEntityHandler().wrapBodyRotationControl(this.original);
        if (bodyRotationController == null) {
            bodyRotationController = new DefaultBodyRotationController(this);
        }
        return bodyRotationController;
    }

    @Override
    public void wrapNavigation() {
        ModelEngineAPI.getEntityHandler().wrapNavigation(this.original);
    }

    @Override
    public RangeManager wrapRangeManager(IModel iModel) {
        if (this.rangeManager != null) {
            return this.rangeManager;
        }
        this.rangeManager = ModelEngineAPI.getEntityHandler().wrapRangeManager(this.original);
        return this.rangeManager;
    }

    @Override
    public boolean onHurt(IDamageSource iDamageSource, float f) {
        return ModelEngineAPI.getEntityHandler().hurt(this.original, iDamageSource, f);
    }

    @Override
    public void onInteract(Player player, EquipmentSlot equipmentSlot) {
    }

    @Override
    public void setHitbox(Hitbox hitbox) {
        if (hitbox == null) {
            double d;
            double d2 = this.original.getWidth();
            double d3 = this.original.getHeight();
            double d4 = this.original.getWidth();
            Entity entity = this.original;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                d = livingEntity.getEyeHeight();
            } else {
                d = this.original.getHeight() * 0.5;
            }
            hitbox = new Hitbox(d2, d3, d4, d);
        }
        this.hitbox = hitbox.clone();
        ModelEngineAPI.getEntityHandler().setHitbox(this.original, hitbox);
        if (this.modelHitbox == null) {
            this.modelHitbox = ModelEngineAPI.getEntityHandler().createModelHitbox(this);
        }
        this.getModelHitbox().refresh();
    }

    @Override
    public void setStepHeight(double d) {
        this.stepHeight = d;
        ModelEngineAPI.getEntityHandler().setStepHeight(this.original, d);
    }

    @Override
    public void setCollidableToLiving(LivingEntity livingEntity, boolean bl) {
        if (bl) {
            livingEntity.getCollidableExemptions().remove(this.original.getUniqueId());
        } else {
            livingEntity.getCollidableExemptions().add(this.original.getUniqueId());
        }
    }

    @Override
    public void broadcastSpawnPacket() {
        ModelEngineAPI.getEntityHandler().broadcastSpawnPacket(this, false);
    }

    @Override
    public void broadcastDespawnPacket() {
        ModelEngineAPI.getEntityHandler().broadcastDespawnPacket(this, false);
    }

    @Override
    public int getEntityId() {
        return this.original.getEntityId();
    }

    @Override
    public UUID getUniqueId() {
        return this.original.getUniqueId();
    }

    @Override
    public Location getLocation() {
        return this.original.getLocation();
    }

    @Override
    public World getWorld() {
        return this.original.getWorld();
    }

    @Override
    public boolean isDead() {
        return this.original.isDead();
    }

    @Override
    public boolean isGlowing() {
        return this.original.isGlowing();
    }

    @Override
    public boolean isOnGround() {
        return this.original.isOnGround();
    }

    @Override
    public boolean isMoving() {
        return !this.isDead() && ModelEngineAPI.getEntityHandler().isMoving(this.original);
    }

    @Override
    public void setYHeadRot(float f) {
        ModelEngineAPI.getEntityHandler().setYHeadRot(this.original, f);
    }

    @Override
    public float getYHeadRot() {
        return ModelEngineAPI.getEntityHandler().getYHeadRot(this.original);
    }

    @Override
    public float getXHeadRot() {
        return ModelEngineAPI.getEntityHandler().getXHeadRot(this.original);
    }

    @Override
    public void setYBodyRot(float f) {
        ModelEngineAPI.getEntityHandler().setYBodyRot(this.original, f);
    }

    @Override
    public float getYBodyRot() {
        return ModelEngineAPI.getEntityHandler().getYBodyRot(this.original);
    }

    @Override
    public List<Entity> getPassengers() {
        return this.original.getPassengers();
    }

    @Override
    public ItemStack getItemInSlot(EquipmentSlot equipmentSlot) {
        Entity entity = this.original;
        if (!(entity instanceof LivingEntity)) {
            return null;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        entity = livingEntity.getEquipment();
        if (entity == null) {
            return null;
        }
        return entity.getItem(equipmentSlot);
    }

    @Override
    public Entity getOriginal() {
        return this.original;
    }

    @Override
    public RangeManager getRangeManager() {
        return this.rangeManager;
    }

    @Override
    public Double getStepHeight() {
        return this.stepHeight;
    }

    @Override
    public Hitbox getHitbox() {
        return this.hitbox;
    }

    @Override
    public ModelHitbox getModelHitbox() {
        return this.modelHitbox;
    }
}

