/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.entity;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.generator.Hitbox;
import com.ticxo.modelengine.api.model.IModel;
import com.ticxo.modelengine.api.nms.entity.hitbox.ModelHitbox;
import com.ticxo.modelengine.api.nms.entity.impl.DefaultBodyRotationController;
import com.ticxo.modelengine.api.nms.entity.impl.EmptyLookController;
import com.ticxo.modelengine.api.nms.entity.impl.EmptyMoveController;
import com.ticxo.modelengine.api.nms.entity.wrapper.BodyRotationController;
import com.ticxo.modelengine.api.nms.entity.wrapper.LookController;
import com.ticxo.modelengine.api.nms.entity.wrapper.MoveController;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.api.nms.world.IDamageSource;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BukkitPlayer
implements BaseEntity<Player> {
    private final Player original;
    private RangeManager rangeManager;
    private Double stepHeight;
    private Hitbox hitbox;
    private ModelHitbox modelHitbox;

    public BukkitPlayer(@NotNull Player player) {
        this.original = player;
    }

    @Override
    public MoveController wrapMoveControl() {
        return new EmptyMoveController();
    }

    @Override
    public LookController wrapLookControl() {
        return new EmptyLookController();
    }

    @Override
    public BodyRotationController wrapBodyRotationControl() {
        DefaultBodyRotationController defaultBodyRotationController = new DefaultBodyRotationController(this);
        defaultBodyRotationController.setMaxHeadAngle(75.0f);
        defaultBodyRotationController.setMaxBodyAngle(75.0f);
        defaultBodyRotationController.setPlayerMode(true);
        return defaultBodyRotationController;
    }

    @Override
    public void wrapNavigation() {
    }

    @Override
    public RangeManager wrapRangeManager(IModel iModel) {
        if (this.rangeManager != null) {
            return this.rangeManager;
        }
        this.rangeManager = ModelEngineAPI.getEntityHandler().wrapRangeManager((Entity)this.original);
        return this.rangeManager;
    }

    @Override
    public boolean onHurt(IDamageSource iDamageSource, float f) {
        return ModelEngineAPI.getEntityHandler().hurt((Entity)this.original, iDamageSource, f);
    }

    @Override
    public void onInteract(Player player, EquipmentSlot equipmentSlot) {
    }

    @Override
    public void setHitbox(Hitbox hitbox) {
        if (hitbox == null) {
            hitbox = new Hitbox(this.original.getWidth(), this.original.getHeight(), this.original.getWidth(), this.original.getEyeHeight());
        }
        this.hitbox = hitbox.clone();
        ModelEngineAPI.getEntityHandler().setHitbox((Entity)this.original, hitbox);
        if (this.modelHitbox == null) {
            this.modelHitbox = ModelEngineAPI.getEntityHandler().createModelHitbox(this);
        }
        this.getModelHitbox().refresh();
    }

    @Override
    public void setStepHeight(double d) {
        this.stepHeight = d;
        ModelEngineAPI.getEntityHandler().setStepHeight((Entity)this.original, d);
    }

    @Override
    public void setCollidableToLiving(LivingEntity livingEntity, boolean bl) {
        if (bl) {
            livingEntity.getCollidableExemptions().remove(this.original.getUniqueId());
        } else {
            livingEntity.getCollidableExemptions().add(this.original.getUniqueId());
        }
    }

    @Override
    public void broadcastSpawnPacket() {
        ModelEngineAPI.getEntityHandler().broadcastSpawnPacket(this, true);
    }

    @Override
    public void broadcastDespawnPacket() {
        ModelEngineAPI.getEntityHandler().broadcastDespawnPacket(this, true);
    }

    @Override
    public int getEntityId() {
        return this.original.getEntityId();
    }

    @Override
    public UUID getUniqueId() {
        return this.original.getUniqueId();
    }

    @Override
    public Location getLocation() {
        return this.original.getLocation();
    }

    @Override
    public World getWorld() {
        return this.original.getWorld();
    }

    @Override
    public boolean isDead() {
        return this.original.isDead();
    }

    @Override
    public boolean isGlowing() {
        return this.original.isGlowing();
    }

    @Override
    public boolean isOnGround() {
        return this.original.isOnGround();
    }

    @Override
    public boolean isMoving() {
        return ModelEngineAPI.getEntityHandler().isMoving((Entity)this.original);
    }

    @Override
    public void setYHeadRot(float f) {
        ModelEngineAPI.getEntityHandler().setYHeadRot((Entity)this.original, f);
    }

    @Override
    public float getYHeadRot() {
        return ModelEngineAPI.getEntityHandler().getYHeadRot((Entity)this.original);
    }

    @Override
    public float getXHeadRot() {
        return ModelEngineAPI.getEntityHandler().getXHeadRot((Entity)this.original);
    }

    @Override
    public void setYBodyRot(float f) {
        ModelEngineAPI.getEntityHandler().setYBodyRot((Entity)this.original, f);
    }

    @Override
    public float getYBodyRot() {
        return ModelEngineAPI.getEntityHandler().getYBodyRot((Entity)this.original);
    }

    @Override
    public List<Entity> getPassengers() {
        return this.original.getPassengers();
    }

    @Override
    public ItemStack getItemInSlot(EquipmentSlot equipmentSlot) {
        EntityEquipment entityEquipment = this.original.getEquipment();
        if (entityEquipment == null) {
            return null;
        }
        return entityEquipment.getItem(equipmentSlot);
    }

    @Override
    public Player getOriginal() {
        return this.original;
    }

    @Override
    public RangeManager getRangeManager() {
        return this.rangeManager;
    }

    @Override
    public Double getStepHeight() {
        return this.stepHeight;
    }

    @Override
    public Hitbox getHitbox() {
        return this.hitbox;
    }

    @Override
    public ModelHitbox getModelHitbox() {
        return this.modelHitbox;
    }
}

