/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.model.mananger;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.bone.SubHitbox;
import com.ticxo.modelengine.api.model.mananger.ModelTicker;
import com.ticxo.modelengine.api.nms.entity.hitbox.DynamicHitbox;
import com.ticxo.modelengine.api.nms.world.WorldHandler;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.RayTraceResult;
import org.jetbrains.annotations.Nullable;

public class InteractionTicker
extends BukkitRunnable {
    private final ModelEngineAPI api;
    private final WorldHandler worldHandler;
    private final ModelTicker modelTicker;
    private final Map<Integer, UUID> modelRelay = Maps.newConcurrentMap();
    private final DynamicHitbox dynamicHitbox;
    private final Map<Integer, Integer> playerRelay = Maps.newConcurrentMap();

    public InteractionTicker(ModelEngineAPI modelEngineAPI) {
        this.api = modelEngineAPI;
        this.worldHandler = modelEngineAPI.getNms().getWorldHandler();
        this.modelTicker = ModelEngineAPI.getModelTicker();
        this.dynamicHitbox = ModelEngineAPI.getEntityHandler().getDynamicHitbox();
    }

    public void start() {
        this.runTaskTimerAsynchronously((Plugin)this.api, 0L, 1L);
    }

    public void run() {
        block4: for (Player player : Bukkit.getOnlinePlayers()) {
            double d = 3.0;
            switch (player.getGameMode()) {
                case SPECTATOR: {
                    this.setRelay(player, null);
                    this.dynamicHitbox.updateInactive(player);
                    continue block4;
                }
                case CREATIVE: {
                    d = 5.0;
                }
            }
            Location location = player.getEyeLocation();
            RayTraceResult rayTraceResult = this.worldHandler.asyncRayTrace(location, location.getDirection(), d, FluidCollisionMode.NEVER, false, 0.0, entity -> {
                SubHitbox subHitbox = this.modelTicker.getSubHitboxBone(entity.getUniqueId());
                if (!(subHitbox == null || subHitbox.isOBB() && subHitbox.getSubHitboxEntity().getRelayed().getEntityId() != player.getEntityId())) {
                    return false;
                }
                return entity != player;
            });
            if (rayTraceResult == null) {
                this.setRelay(player, null);
                this.dynamicHitbox.updateInactive(player);
                continue;
            }
            Entity entity2 = rayTraceResult.getHitEntity();
            if (entity2 == null) {
                this.setRelay(player, null);
                this.dynamicHitbox.updateInactive(player);
                continue;
            }
            Integer n = this.modelTicker.isModeledEntityOrSubHitbox(entity2.getUniqueId()) ? Integer.valueOf(entity2.getEntityId()) : null;
            this.setRelay(player, n);
            if (this.modelTicker.isSubHitbox(entity2.getUniqueId())) {
                this.dynamicHitbox.updateActive(player, rayTraceResult);
                continue;
            }
            this.dynamicHitbox.updateInactive(player);
        }
    }

    public void setRelay(Player player, @Nullable Integer n) {
        int n2 = player.getEntityId();
        boolean bl = this.playerRelay.containsKey(player.getEntityId());
        if (n == null) {
            if (bl) {
                this.playerRelay.remove(n2);
            }
        } else if (!bl || this.playerRelay.containsKey(n2) && !this.playerRelay.get(n2).equals(n)) {
            this.playerRelay.put(n2, n);
        }
    }

    public Integer getRelayedId(int n) {
        return this.playerRelay.get(n);
    }

    public void setModelRelay(int n, UUID uUID) {
        this.modelRelay.put(n, uUID);
    }

    public void removeModelRelay(int n) {
        this.modelRelay.remove(n);
    }

    public UUID getModelRelay(int n) {
        return this.modelRelay.get(n);
    }
}

