/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.model.mananger;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.model.vfx.VFX;
import java.util.Map;
import java.util.UUID;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.Nullable;

public class VFXTicker
extends BukkitRunnable {
    private final ModelEngineAPI api;
    private final Map<Integer, UUID> entityIdLookup = Maps.newConcurrentMap();
    private final Map<UUID, VFX> uuidLookup = Maps.newConcurrentMap();

    public void start() {
        this.runTaskTimerAsynchronously((Plugin)this.api, 0L, 1L);
    }

    public void run() {
        for (UUID uUID : this.uuidLookup.keySet()) {
            VFX vFX = this.uuidLookup.get(uUID);
            if (vFX.tick()) continue;
            vFX.destroy();
            this.entityIdLookup.remove(vFX.getBase().getEntityId());
            this.uuidLookup.remove(uUID);
        }
    }

    public void registerVFX(BaseEntity<?> baseEntity, VFX vFX) {
        this.entityIdLookup.put(baseEntity.getEntityId(), baseEntity.getUniqueId());
        this.uuidLookup.put(baseEntity.getUniqueId(), vFX);
    }

    public void removeVFX(UUID uUID) {
        VFX vFX = this.uuidLookup.remove(uUID);
        if (vFX == null) {
            return;
        }
        this.entityIdLookup.remove(vFX.getBase().getEntityId());
        vFX.destroy();
    }

    @Nullable
    public VFX getVFX(int n) {
        return this.getVFX(this.entityIdLookup.get(n));
    }

    @Nullable
    public VFX getVFX(@Nullable UUID uUID) {
        return uUID == null ? null : this.uuidLookup.get(uUID);
    }

    public boolean isVFX(int n) {
        return this.entityIdLookup.containsKey(n) && this.isVFX(this.entityIdLookup.get(n));
    }

    public boolean isVFX(UUID uUID) {
        return this.uuidLookup.containsKey(uUID);
    }

    public VFXTicker(ModelEngineAPI modelEngineAPI) {
        this.api = modelEngineAPI;
    }
}

