/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.utils.logger.TLogger;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class CompatibilityManager
implements Listener {
    private final PluginManager pluginManager;
    private final Set<String> allPlugins = Sets.newConcurrentHashSet();
    private final Map<String, CompatibilityConfiguration> compatibilities = Maps.newConcurrentMap();

    public CompatibilityManager(JavaPlugin javaPlugin) {
        this.pluginManager = Bukkit.getPluginManager();
        for (Plugin plugin : this.pluginManager.getPlugins()) {
            this.allPlugins.add(plugin.getName());
        }
        this.pluginManager.registerEvents((Listener)this, (Plugin)javaPlugin);
    }

    public void registerSupport(String string, CompatibilityConfiguration compatibilityConfiguration) {
        if (!this.allPlugins.contains(string)) {
            return;
        }
        Plugin plugin = this.pluginManager.getPlugin(string);
        if (plugin == null || !plugin.isEnabled() || !compatibilityConfiguration.tryApply(plugin)) {
            this.compatibilities.put(string, compatibilityConfiguration);
        } else {
            TLogger.log("Compatibility applied: " + plugin.getName());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPluginLoad(PluginEnableEvent pluginEnableEvent) {
        Plugin plugin = pluginEnableEvent.getPlugin();
        CompatibilityConfiguration compatibilityConfiguration = this.compatibilities.get(plugin.getName());
        if (compatibilityConfiguration != null) {
            if (!compatibilityConfiguration.tryApply(plugin)) {
                TLogger.error("Failed to apply compatibility support for " + plugin.getName() + ".");
            } else {
                TLogger.log("Compatibility applied: " + plugin.getName());
            }
        }
    }

    public boolean hasPlugin(String string) {
        return this.allPlugins.contains(string);
    }

    @FunctionalInterface
    public static interface CompatibilityConfiguration {
        public boolean tryApply(Plugin var1);
    }
}

