/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils.data;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.animation.blueprint.BlueprintAnimation;
import com.ticxo.modelengine.api.animation.blueprint.LoopMode;
import com.ticxo.modelengine.api.animation.property.IAnimationProperty;
import com.ticxo.modelengine.api.animation.property.SimpleProperty;
import com.ticxo.modelengine.api.animation.state.DefaultStateHandler;
import com.ticxo.modelengine.api.animation.state.ModelState;
import com.ticxo.modelengine.api.generator.Hitbox;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.Mountable;
import com.ticxo.modelengine.api.mount.MountManager;
import com.ticxo.modelengine.api.nms.entity.wrapper.BodyRotationController;
import java.util.Map;
import org.bukkit.NamespacedKey;

public class EntityData {
    public static NamespacedKey DATA_KEY;
    private int renderDistance;
    private boolean isHeadClampUneven;
    private boolean isBodyClampUneven;
    private float maxHeadAngle;
    private float maxBodyAngle;
    private float minHeadAngle;
    private float minBodyAngle;
    private boolean playerMode;
    private float stableAngle;
    private int rotationDelay;
    private int rotationDuration;
    private boolean canSteer;
    private boolean canRide;
    private String mountModelId;
    private String mountDriverBone;
    private boolean isBaseEntityVisible;
    private boolean modelRotationLock;
    private Double stepHeight;
    private Hitbox hitbox;
    private final Map<String, ModelData> models = Maps.newConcurrentMap();

    public void save(ModeledEntity modeledEntity) {
        this.renderDistance = modeledEntity.getRangeManager().getRenderDistance();
        BodyRotationController bodyRotationController = modeledEntity.getBodyRotationController();
        this.isHeadClampUneven = bodyRotationController.isHeadClampUneven();
        this.isBodyClampUneven = bodyRotationController.isBodyClampUneven();
        this.maxHeadAngle = bodyRotationController.getMaxHeadAngle();
        this.maxBodyAngle = bodyRotationController.getMaxBodyAngle();
        this.minHeadAngle = bodyRotationController.getMinHeadAngle();
        this.minBodyAngle = bodyRotationController.getMinBodyAngle();
        this.playerMode = bodyRotationController.isPlayerMode();
        this.stableAngle = bodyRotationController.getStableAngle();
        this.rotationDelay = bodyRotationController.getRotationDelay();
        this.rotationDuration = bodyRotationController.getRotationDuration();
        MountManager mountManager = modeledEntity.getMountManager();
        this.canSteer = mountManager.isCanSteer();
        this.canRide = mountManager.isCanRide();
        Mountable mountable = mountManager.getDriverBone();
        if (mountable != null) {
            this.mountModelId = mountable.getActiveModel().getBlueprint().getModelId();
            this.mountDriverBone = mountable.getBoneId();
        }
        this.stepHeight = modeledEntity.getBase().getStepHeight();
        this.hitbox = modeledEntity.getBase().getHitbox();
        this.isBaseEntityVisible = modeledEntity.isBaseEntityVisible();
        this.modelRotationLock = modeledEntity.isModelRotationLock();
        modeledEntity.getModels().forEach((string, activeModel) -> this.models.put((String)string, this.getModelData((ActiveModel)activeModel)));
    }

    public void load(ModeledEntity modeledEntity) {
        Mountable mountable;
        ActiveModel activeModel;
        modeledEntity.getRangeManager().setRenderDistance(this.renderDistance);
        BodyRotationController bodyRotationController = modeledEntity.getBodyRotationController();
        bodyRotationController.setHeadClampUneven(this.isHeadClampUneven);
        bodyRotationController.setBodyClampUneven(this.isBodyClampUneven);
        bodyRotationController.setMaxHeadAngle(this.maxHeadAngle);
        bodyRotationController.setMaxBodyAngle(this.maxBodyAngle);
        bodyRotationController.setMinHeadAngle(this.minHeadAngle);
        bodyRotationController.setMinBodyAngle(this.minBodyAngle);
        bodyRotationController.setPlayerMode(this.playerMode);
        bodyRotationController.setStableAngle(this.stableAngle);
        bodyRotationController.setRotationDelay(this.rotationDelay);
        bodyRotationController.setRotationDuration(this.rotationDuration);
        if (this.stepHeight != null) {
            modeledEntity.setStepHeight(this.stepHeight);
        }
        if (this.hitbox != null) {
            modeledEntity.getBase().setHitbox(this.hitbox);
        }
        modeledEntity.setBaseEntityVisible(this.isBaseEntityVisible);
        modeledEntity.setModelRotationLock(this.modelRotationLock);
        this.models.forEach((string2, modelData) -> {
            ActiveModel activeModel = ModelEngineAPI.createActiveModel(string2);
            if (activeModel == null) {
                return;
            }
            activeModel.setCanHurt(modelData.canHurt);
            activeModel.setLockPitch(modelData.lockPitch);
            activeModel.setLockYaw(modelData.lockYaw);
            modelData.defaultStates.forEach((modelState, stateProperty) -> activeModel.getDefaultStateHandler().setProperty((ModelState)modelState, new DefaultStateHandler.Property(stateProperty.stateId, stateProperty.lerpIn, stateProperty.lerpOut, stateProperty.speed)));
            ModelBlueprint modelBlueprint = activeModel.getBlueprint();
            modelData.states.forEach((string, stateData) -> {
                BlueprintAnimation blueprintAnimation = modelBlueprint.getAnimations().get(string);
                if (blueprintAnimation == null) {
                    return;
                }
                activeModel.getAnimationHandler().playAnimation(new SimpleProperty(activeModel, blueprintAnimation, stateData.lerpIn, stateData.lerpOut, stateData.speed), true);
            });
            modeledEntity.addModel(activeModel, false);
        });
        MountManager mountManager = modeledEntity.getMountManager();
        mountManager.setCanSteer(this.canSteer);
        mountManager.setCanRide(this.canRide);
        if (this.mountModelId != null && this.mountDriverBone != null && (activeModel = modeledEntity.getModel(this.mountModelId)) != null && (mountable = (Mountable)activeModel.getMountHandler().getBones().get(this.mountDriverBone)) != null && mountable.isDriverBone()) {
            modeledEntity.getMountManager().setDriverBone(mountable);
        }
    }

    private ModelData getModelData(ActiveModel activeModel) {
        ModelData modelData = new ModelData();
        activeModel.getAnimationHandler().forEachProperty((string, iAnimationProperty) -> modelData.getStates().put((String)string, this.getStateData((IAnimationProperty)iAnimationProperty)));
        for (ModelState modelState : ModelState.values()) {
            DefaultStateHandler.Property property = activeModel.getDefaultStateHandler().getProperty(modelState);
            StateProperty stateProperty = new StateProperty();
            stateProperty.stateId = property.getAnimation();
            stateProperty.lerpIn = property.getLerpIn();
            stateProperty.lerpOut = property.getLerpOut();
            stateProperty.speed = property.getSpeed();
            modelData.getDefaultStates().put(modelState, stateProperty);
        }
        modelData.canHurt = activeModel.isCanHurt();
        modelData.lockPitch = activeModel.isLockPitch();
        modelData.lockYaw = activeModel.isLockYaw();
        return modelData;
    }

    private StateData getStateData(IAnimationProperty iAnimationProperty) {
        StateData stateData = new StateData();
        stateData.forceLoopMode = iAnimationProperty.getForceLoopMode();
        stateData.forceOverride = iAnimationProperty.isForceOverride();
        stateData.lerpIn = iAnimationProperty.getLerpIn();
        stateData.lerpOut = iAnimationProperty.getLerpOut();
        stateData.speed = iAnimationProperty.getSpeed();
        stateData.phase = iAnimationProperty.getPhase();
        stateData.time = switch (stateData.phase) {
            case IAnimationProperty.Phase.LERPIN -> iAnimationProperty.getLerpInTime();
            case IAnimationProperty.Phase.PLAY -> iAnimationProperty.getTime();
            case IAnimationProperty.Phase.LERPOUT -> iAnimationProperty.getLerpOutTime();
            default -> throw new IncompatibleClassChangeError();
        };
        return stateData;
    }

    public int getRenderDistance() {
        return this.renderDistance;
    }

    public boolean isHeadClampUneven() {
        return this.isHeadClampUneven;
    }

    public boolean isBodyClampUneven() {
        return this.isBodyClampUneven;
    }

    public float getMaxHeadAngle() {
        return this.maxHeadAngle;
    }

    public float getMaxBodyAngle() {
        return this.maxBodyAngle;
    }

    public float getMinHeadAngle() {
        return this.minHeadAngle;
    }

    public float getMinBodyAngle() {
        return this.minBodyAngle;
    }

    public boolean isPlayerMode() {
        return this.playerMode;
    }

    public float getStableAngle() {
        return this.stableAngle;
    }

    public int getRotationDelay() {
        return this.rotationDelay;
    }

    public int getRotationDuration() {
        return this.rotationDuration;
    }

    public boolean isCanSteer() {
        return this.canSteer;
    }

    public boolean isCanRide() {
        return this.canRide;
    }

    public String getMountModelId() {
        return this.mountModelId;
    }

    public String getMountDriverBone() {
        return this.mountDriverBone;
    }

    public boolean isBaseEntityVisible() {
        return this.isBaseEntityVisible;
    }

    public boolean isModelRotationLock() {
        return this.modelRotationLock;
    }

    public Double getStepHeight() {
        return this.stepHeight;
    }

    public Hitbox getHitbox() {
        return this.hitbox;
    }

    public Map<String, ModelData> getModels() {
        return this.models;
    }

    public void setRenderDistance(int n) {
        this.renderDistance = n;
    }

    public void setHeadClampUneven(boolean bl) {
        this.isHeadClampUneven = bl;
    }

    public void setBodyClampUneven(boolean bl) {
        this.isBodyClampUneven = bl;
    }

    public void setMaxHeadAngle(float f) {
        this.maxHeadAngle = f;
    }

    public void setMaxBodyAngle(float f) {
        this.maxBodyAngle = f;
    }

    public void setMinHeadAngle(float f) {
        this.minHeadAngle = f;
    }

    public void setMinBodyAngle(float f) {
        this.minBodyAngle = f;
    }

    public void setPlayerMode(boolean bl) {
        this.playerMode = bl;
    }

    public void setStableAngle(float f) {
        this.stableAngle = f;
    }

    public void setRotationDelay(int n) {
        this.rotationDelay = n;
    }

    public void setRotationDuration(int n) {
        this.rotationDuration = n;
    }

    public void setCanSteer(boolean bl) {
        this.canSteer = bl;
    }

    public void setCanRide(boolean bl) {
        this.canRide = bl;
    }

    public void setMountModelId(String string) {
        this.mountModelId = string;
    }

    public void setMountDriverBone(String string) {
        this.mountDriverBone = string;
    }

    public void setBaseEntityVisible(boolean bl) {
        this.isBaseEntityVisible = bl;
    }

    public void setModelRotationLock(boolean bl) {
        this.modelRotationLock = bl;
    }

    public void setStepHeight(Double d) {
        this.stepHeight = d;
    }

    public void setHitbox(Hitbox hitbox) {
        this.hitbox = hitbox;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof EntityData)) {
            return false;
        }
        EntityData entityData = (EntityData)object;
        if (!entityData.canEqual(this)) {
            return false;
        }
        if (this.getRenderDistance() != entityData.getRenderDistance()) {
            return false;
        }
        if (this.isHeadClampUneven() != entityData.isHeadClampUneven()) {
            return false;
        }
        if (this.isBodyClampUneven() != entityData.isBodyClampUneven()) {
            return false;
        }
        if (Float.compare(this.getMaxHeadAngle(), entityData.getMaxHeadAngle()) != 0) {
            return false;
        }
        if (Float.compare(this.getMaxBodyAngle(), entityData.getMaxBodyAngle()) != 0) {
            return false;
        }
        if (Float.compare(this.getMinHeadAngle(), entityData.getMinHeadAngle()) != 0) {
            return false;
        }
        if (Float.compare(this.getMinBodyAngle(), entityData.getMinBodyAngle()) != 0) {
            return false;
        }
        if (this.isPlayerMode() != entityData.isPlayerMode()) {
            return false;
        }
        if (Float.compare(this.getStableAngle(), entityData.getStableAngle()) != 0) {
            return false;
        }
        if (this.getRotationDelay() != entityData.getRotationDelay()) {
            return false;
        }
        if (this.getRotationDuration() != entityData.getRotationDuration()) {
            return false;
        }
        if (this.isCanSteer() != entityData.isCanSteer()) {
            return false;
        }
        if (this.isCanRide() != entityData.isCanRide()) {
            return false;
        }
        if (this.isBaseEntityVisible() != entityData.isBaseEntityVisible()) {
            return false;
        }
        if (this.isModelRotationLock() != entityData.isModelRotationLock()) {
            return false;
        }
        Double d = this.getStepHeight();
        Double d2 = entityData.getStepHeight();
        if (d == null ? d2 != null : !((Object)d).equals(d2)) {
            return false;
        }
        String string = this.getMountModelId();
        String string2 = entityData.getMountModelId();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getMountDriverBone();
        String string4 = entityData.getMountDriverBone();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        Hitbox hitbox = this.getHitbox();
        Hitbox hitbox2 = entityData.getHitbox();
        if (hitbox == null ? hitbox2 != null : !((Object)hitbox).equals(hitbox2)) {
            return false;
        }
        Map<String, ModelData> map = this.getModels();
        Map<String, ModelData> map2 = entityData.getModels();
        return !(map == null ? map2 != null : !((Object)map).equals(map2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof EntityData;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + this.getRenderDistance();
        n2 = n2 * 59 + (this.isHeadClampUneven() ? 79 : 97);
        n2 = n2 * 59 + (this.isBodyClampUneven() ? 79 : 97);
        n2 = n2 * 59 + Float.floatToIntBits(this.getMaxHeadAngle());
        n2 = n2 * 59 + Float.floatToIntBits(this.getMaxBodyAngle());
        n2 = n2 * 59 + Float.floatToIntBits(this.getMinHeadAngle());
        n2 = n2 * 59 + Float.floatToIntBits(this.getMinBodyAngle());
        n2 = n2 * 59 + (this.isPlayerMode() ? 79 : 97);
        n2 = n2 * 59 + Float.floatToIntBits(this.getStableAngle());
        n2 = n2 * 59 + this.getRotationDelay();
        n2 = n2 * 59 + this.getRotationDuration();
        n2 = n2 * 59 + (this.isCanSteer() ? 79 : 97);
        n2 = n2 * 59 + (this.isCanRide() ? 79 : 97);
        n2 = n2 * 59 + (this.isBaseEntityVisible() ? 79 : 97);
        n2 = n2 * 59 + (this.isModelRotationLock() ? 79 : 97);
        Double d = this.getStepHeight();
        n2 = n2 * 59 + (d == null ? 43 : ((Object)d).hashCode());
        String string = this.getMountModelId();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getMountDriverBone();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        Hitbox hitbox = this.getHitbox();
        n2 = n2 * 59 + (hitbox == null ? 43 : ((Object)hitbox).hashCode());
        Map<String, ModelData> map = this.getModels();
        n2 = n2 * 59 + (map == null ? 43 : ((Object)map).hashCode());
        return n2;
    }

    public String toString() {
        return "EntityData(renderDistance=" + this.getRenderDistance() + ", isHeadClampUneven=" + this.isHeadClampUneven() + ", isBodyClampUneven=" + this.isBodyClampUneven() + ", maxHeadAngle=" + this.getMaxHeadAngle() + ", maxBodyAngle=" + this.getMaxBodyAngle() + ", minHeadAngle=" + this.getMinHeadAngle() + ", minBodyAngle=" + this.getMinBodyAngle() + ", playerMode=" + this.isPlayerMode() + ", stableAngle=" + this.getStableAngle() + ", rotationDelay=" + this.getRotationDelay() + ", rotationDuration=" + this.getRotationDuration() + ", canSteer=" + this.isCanSteer() + ", canRide=" + this.isCanRide() + ", mountModelId=" + this.getMountModelId() + ", mountDriverBone=" + this.getMountDriverBone() + ", isBaseEntityVisible=" + this.isBaseEntityVisible() + ", modelRotationLock=" + this.isModelRotationLock() + ", stepHeight=" + this.getStepHeight() + ", hitbox=" + this.getHitbox() + ", models=" + this.getModels() + ")";
    }

    public static class ModelData {
        private final Map<String, StateData> states = Maps.newConcurrentMap();
        private final Map<ModelState, StateProperty> defaultStates = Maps.newConcurrentMap();
        private boolean canHurt;
        private boolean lockPitch;
        private boolean lockYaw;

        public Map<String, StateData> getStates() {
            return this.states;
        }

        public Map<ModelState, StateProperty> getDefaultStates() {
            return this.defaultStates;
        }

        public boolean isCanHurt() {
            return this.canHurt;
        }

        public boolean isLockPitch() {
            return this.lockPitch;
        }

        public boolean isLockYaw() {
            return this.lockYaw;
        }

        public void setCanHurt(boolean bl) {
            this.canHurt = bl;
        }

        public void setLockPitch(boolean bl) {
            this.lockPitch = bl;
        }

        public void setLockYaw(boolean bl) {
            this.lockYaw = bl;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ModelData)) {
                return false;
            }
            ModelData modelData = (ModelData)object;
            if (!modelData.canEqual(this)) {
                return false;
            }
            if (this.isCanHurt() != modelData.isCanHurt()) {
                return false;
            }
            if (this.isLockPitch() != modelData.isLockPitch()) {
                return false;
            }
            if (this.isLockYaw() != modelData.isLockYaw()) {
                return false;
            }
            Map<String, StateData> map = this.getStates();
            Map<String, StateData> map2 = modelData.getStates();
            if (map == null ? map2 != null : !((Object)map).equals(map2)) {
                return false;
            }
            Map<ModelState, StateProperty> map3 = this.getDefaultStates();
            Map<ModelState, StateProperty> map4 = modelData.getDefaultStates();
            return !(map3 == null ? map4 != null : !((Object)map3).equals(map4));
        }

        protected boolean canEqual(Object object) {
            return object instanceof ModelData;
        }

        public int hashCode() {
            int n = 59;
            int n2 = 1;
            n2 = n2 * 59 + (this.isCanHurt() ? 79 : 97);
            n2 = n2 * 59 + (this.isLockPitch() ? 79 : 97);
            n2 = n2 * 59 + (this.isLockYaw() ? 79 : 97);
            Map<String, StateData> map = this.getStates();
            n2 = n2 * 59 + (map == null ? 43 : ((Object)map).hashCode());
            Map<ModelState, StateProperty> map2 = this.getDefaultStates();
            n2 = n2 * 59 + (map2 == null ? 43 : ((Object)map2).hashCode());
            return n2;
        }

        public String toString() {
            return "EntityData.ModelData(states=" + this.getStates() + ", defaultStates=" + this.getDefaultStates() + ", canHurt=" + this.isCanHurt() + ", lockPitch=" + this.isLockPitch() + ", lockYaw=" + this.isLockYaw() + ")";
        }
    }

    public static class StateProperty {
        private String stateId;
        private double lerpIn;
        private double lerpOut;
        private double speed;

        public String getStateId() {
            return this.stateId;
        }

        public double getLerpIn() {
            return this.lerpIn;
        }

        public double getLerpOut() {
            return this.lerpOut;
        }

        public double getSpeed() {
            return this.speed;
        }

        public void setStateId(String string) {
            this.stateId = string;
        }

        public void setLerpIn(double d) {
            this.lerpIn = d;
        }

        public void setLerpOut(double d) {
            this.lerpOut = d;
        }

        public void setSpeed(double d) {
            this.speed = d;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof StateProperty)) {
                return false;
            }
            StateProperty stateProperty = (StateProperty)object;
            if (!stateProperty.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getLerpIn(), stateProperty.getLerpIn()) != 0) {
                return false;
            }
            if (Double.compare(this.getLerpOut(), stateProperty.getLerpOut()) != 0) {
                return false;
            }
            if (Double.compare(this.getSpeed(), stateProperty.getSpeed()) != 0) {
                return false;
            }
            String string = this.getStateId();
            String string2 = stateProperty.getStateId();
            return !(string == null ? string2 != null : !string.equals(string2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof StateProperty;
        }

        public int hashCode() {
            int n = 59;
            int n2 = 1;
            long l = Double.doubleToLongBits(this.getLerpIn());
            n2 = n2 * 59 + (int)(l >>> 32 ^ l);
            long l2 = Double.doubleToLongBits(this.getLerpOut());
            n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
            long l3 = Double.doubleToLongBits(this.getSpeed());
            n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
            String string = this.getStateId();
            n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
            return n2;
        }

        public String toString() {
            return "EntityData.StateProperty(stateId=" + this.getStateId() + ", lerpIn=" + this.getLerpIn() + ", lerpOut=" + this.getLerpOut() + ", speed=" + this.getSpeed() + ")";
        }
    }

    public static class StateData {
        private double lerpIn;
        private double lerpOut;
        private double time;
        private double speed;
        private IAnimationProperty.Phase phase;
        private LoopMode forceLoopMode;
        private boolean forceOverride;

        public double getLerpIn() {
            return this.lerpIn;
        }

        public double getLerpOut() {
            return this.lerpOut;
        }

        public double getTime() {
            return this.time;
        }

        public double getSpeed() {
            return this.speed;
        }

        public IAnimationProperty.Phase getPhase() {
            return this.phase;
        }

        public LoopMode getForceLoopMode() {
            return this.forceLoopMode;
        }

        public boolean isForceOverride() {
            return this.forceOverride;
        }

        public void setLerpIn(double d) {
            this.lerpIn = d;
        }

        public void setLerpOut(double d) {
            this.lerpOut = d;
        }

        public void setTime(double d) {
            this.time = d;
        }

        public void setSpeed(double d) {
            this.speed = d;
        }

        public void setPhase(IAnimationProperty.Phase phase) {
            this.phase = phase;
        }

        public void setForceLoopMode(LoopMode loopMode) {
            this.forceLoopMode = loopMode;
        }

        public void setForceOverride(boolean bl) {
            this.forceOverride = bl;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof StateData)) {
                return false;
            }
            StateData stateData = (StateData)object;
            if (!stateData.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getLerpIn(), stateData.getLerpIn()) != 0) {
                return false;
            }
            if (Double.compare(this.getLerpOut(), stateData.getLerpOut()) != 0) {
                return false;
            }
            if (Double.compare(this.getTime(), stateData.getTime()) != 0) {
                return false;
            }
            if (Double.compare(this.getSpeed(), stateData.getSpeed()) != 0) {
                return false;
            }
            if (this.isForceOverride() != stateData.isForceOverride()) {
                return false;
            }
            IAnimationProperty.Phase phase = this.getPhase();
            IAnimationProperty.Phase phase2 = stateData.getPhase();
            if (phase == null ? phase2 != null : !((Object)((Object)phase)).equals((Object)phase2)) {
                return false;
            }
            LoopMode loopMode = this.getForceLoopMode();
            LoopMode loopMode2 = stateData.getForceLoopMode();
            return !(loopMode == null ? loopMode2 != null : !((Object)((Object)loopMode)).equals((Object)loopMode2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof StateData;
        }

        public int hashCode() {
            int n = 59;
            int n2 = 1;
            long l = Double.doubleToLongBits(this.getLerpIn());
            n2 = n2 * 59 + (int)(l >>> 32 ^ l);
            long l2 = Double.doubleToLongBits(this.getLerpOut());
            n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
            long l3 = Double.doubleToLongBits(this.getTime());
            n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
            long l4 = Double.doubleToLongBits(this.getSpeed());
            n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
            n2 = n2 * 59 + (this.isForceOverride() ? 79 : 97);
            IAnimationProperty.Phase phase = this.getPhase();
            n2 = n2 * 59 + (phase == null ? 43 : ((Object)((Object)phase)).hashCode());
            LoopMode loopMode = this.getForceLoopMode();
            n2 = n2 * 59 + (loopMode == null ? 43 : ((Object)((Object)loopMode)).hashCode());
            return n2;
        }

        public String toString() {
            return "EntityData.StateData(lerpIn=" + this.getLerpIn() + ", lerpOut=" + this.getLerpOut() + ", time=" + this.getTime() + ", speed=" + this.getSpeed() + ", phase=" + this.getPhase() + ", forceLoopMode=" + this.getForceLoopMode() + ", forceOverride=" + this.isForceOverride() + ")";
        }
    }
}

