/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.citizens;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.animation.property.IAnimationProperty;
import com.ticxo.modelengine.api.command.AbstractCommand;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.citizens.ModelTrait;
import com.ticxo.modelengine.command.MECommand;
import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class CitizensCommand
extends AbstractCommand {
    public CitizensCommand(AbstractCommand abstractCommand) {
        super(abstractCommand);
        this.addSubCommands(new ModelCommand(this));
        this.addSubCommands(new StateCommand(this));
    }

    @Override
    public boolean onCommand(CommandSender commandSender, String[] stringArray) {
        return false;
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, String[] stringArray) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "modelengine.command.npc";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "npc";
    }

    private static void getNPCIdTabComplete(List<String> list) {
        CitizensAPI.getNPCRegistries().forEach(nPCRegistry -> nPCRegistry.sorted().forEach(nPC -> {
            if (nPC.isSpawned() && nPC.hasTrait(ModelTrait.class)) {
                list.add(nPCRegistry.getName() + ":" + nPC.getId() + ":[" + nPC.getName().replace(" ", "-") + "]");
            }
        }));
    }

    private static String tryGetOrDefault(String[] stringArray, int n, String string) {
        if (stringArray.length <= n) {
            return string;
        }
        return stringArray[n];
    }

    private static NPC getNPC(String string) {
        String[] stringArray = string.split(":");
        if (stringArray.length < 2) {
            throw new IllegalArgumentException("NPC ID must be formatted as <registry>:<NPC ID>");
        }
        NPCRegistry nPCRegistry = CitizensAPI.getNamedNPCRegistry((String)stringArray[0]);
        if (nPCRegistry == null) {
            throw new IllegalArgumentException("Unknown NPC registry: " + stringArray[0]);
        }
        NPC nPC = nPCRegistry.getById(Integer.parseInt(stringArray[1]));
        if (nPC == null) {
            throw new IllegalArgumentException("Unknown NPC ID: " + stringArray[1]);
        }
        return nPC;
    }

    private static class ModelCommand
    extends AbstractCommand {
        public ModelCommand(AbstractCommand abstractCommand) {
            super(abstractCommand);
        }

        @Override
        public boolean onCommand(CommandSender commandSender, String[] stringArray) {
            if (stringArray.length < 1) {
                return false;
            }
            NPC nPC = CitizensCommand.getNPC(stringArray[0]);
            ModelTrait modelTrait = (ModelTrait)nPC.getTraitNullable(ModelTrait.class);
            if (modelTrait == null) {
                return false;
            }
            if (!nPC.isSpawned()) {
                commandSender.sendMessage(ChatColor.RED + "Please spawn the NPC before editing.");
                return true;
            }
            ModeledEntity modeledEntity = modelTrait.getModeledEntity();
            if (modeledEntity == null) {
                commandSender.sendMessage(ChatColor.RED + "An error occurred while retrieving the model of this NPC.");
                return true;
            }
            if (stringArray.length < 2) {
                if (modeledEntity.getModels().isEmpty()) {
                    commandSender.sendMessage("This NPC has no models.");
                    return true;
                }
                StringBuilder stringBuilder = new StringBuilder("Models: ");
                for (String string : modeledEntity.getModels().keySet()) {
                    stringBuilder.append(string).append(", ");
                }
                stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
                commandSender.sendMessage(stringBuilder.toString());
                return true;
            }
            if (stringArray.length >= 3) {
                String string = stringArray[2];
                switch (stringArray[1]) {
                    case "add": {
                        boolean bl = Boolean.parseBoolean(CitizensCommand.tryGetOrDefault(stringArray, 3, "false"));
                        boolean bl2 = Boolean.parseBoolean(CitizensCommand.tryGetOrDefault(stringArray, 4, "true"));
                        ActiveModel activeModel = ModelEngineAPI.createActiveModel(string);
                        if (activeModel == null) {
                            return false;
                        }
                        modeledEntity.setBaseEntityVisible(bl);
                        modeledEntity.addModel(activeModel, bl2);
                        commandSender.sendMessage("Added model " + string + " to " + nPC.getName());
                        break;
                    }
                    case "remove": {
                        modeledEntity.removeModel(string).destroy();
                        if (modeledEntity.getModels().isEmpty()) {
                            modeledEntity.setBaseEntityVisible(true);
                        }
                        commandSender.sendMessage("Removed model " + string + " from " + nPC.getName());
                    }
                }
            }
            return true;
        }

        @Override
        public List<String> onTabComplete(CommandSender commandSender, String[] stringArray) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = stringArray[stringArray.length - 1];
            switch (stringArray.length) {
                case 1: {
                    CitizensCommand.getNPCIdTabComplete(arrayList);
                    break;
                }
                case 2: {
                    if ("add".startsWith(string)) {
                        arrayList.add("add");
                    }
                    if (!"remove".startsWith(string)) break;
                    arrayList.add("remove");
                    break;
                }
                case 3: {
                    switch (stringArray[1]) {
                        case "add": {
                            MECommand.getModelIdTabComplete(arrayList, string);
                            break;
                        }
                        case "remove": {
                            ModelTrait modelTrait = (ModelTrait)CitizensCommand.getNPC(stringArray[0]).getTraitNullable(ModelTrait.class);
                            if (modelTrait == null) break;
                            MECommand.getModelIdTabComplete(arrayList, string, modelTrait.getModeledEntity());
                        }
                    }
                    break;
                }
                case 4: {
                    if (!"add".equals(stringArray[1])) break;
                    arrayList.add("[showBaseEntity]");
                    if ("true".startsWith(string)) {
                        arrayList.add("true");
                    }
                    if (!"false".startsWith(string)) break;
                    arrayList.add("false");
                    break;
                }
                case 5: {
                    if (!"add".equals(stringArray[1])) break;
                    arrayList.add("[overrideHitbox]");
                    if ("true".startsWith(string)) {
                        arrayList.add("true");
                    }
                    if (!"false".startsWith(string)) break;
                    arrayList.add("false");
                }
            }
            return arrayList;
        }

        @Override
        public String getPermissionNode() {
            return "modelengine.command.npc.model";
        }

        @Override
        public boolean isConsoleFriendly() {
            return true;
        }

        @Override
        public String getName() {
            return "model";
        }
    }

    private static class StateCommand
    extends AbstractCommand {
        public StateCommand(AbstractCommand abstractCommand) {
            super(abstractCommand);
        }

        @Override
        public boolean onCommand(CommandSender commandSender, String[] stringArray) {
            if (stringArray.length < 1) {
                return false;
            }
            NPC nPC = CitizensCommand.getNPC(stringArray[0]);
            ModelTrait modelTrait = (ModelTrait)nPC.getTraitNullable(ModelTrait.class);
            if (modelTrait == null) {
                return false;
            }
            if (!nPC.isSpawned()) {
                commandSender.sendMessage(ChatColor.RED + "Please spawn the NPC before editing.");
                return true;
            }
            ModeledEntity modeledEntity = modelTrait.getModeledEntity();
            if (modeledEntity == null) {
                commandSender.sendMessage(ChatColor.RED + "An error occurred while retrieving the model of this NPC.");
                return true;
            }
            ActiveModel activeModel = modeledEntity.getModel(stringArray[1]);
            if (activeModel == null) {
                return false;
            }
            if (stringArray.length < 3) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(stringArray[1]).append(": ");
                for (IAnimationProperty iAnimationProperty : activeModel.getAnimationHandler().getAnimations()) {
                    stringBuilder.append(iAnimationProperty.getName()).append(", ");
                }
                stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
                commandSender.sendMessage(stringBuilder.toString());
                return true;
            }
            if (stringArray.length < 4) {
                return false;
            }
            String string = stringArray[3];
            switch (stringArray[2]) {
                case "add": {
                    if (!activeModel.getBlueprint().getAnimations().containsKey(string)) {
                        return false;
                    }
                    int n = Integer.parseInt(CitizensCommand.tryGetOrDefault(stringArray, 4, "0"));
                    int n2 = Integer.parseInt(CitizensCommand.tryGetOrDefault(stringArray, 5, "0"));
                    double d = Double.parseDouble(CitizensCommand.tryGetOrDefault(stringArray, 6, "1"));
                    activeModel.getAnimationHandler().playAnimation(string, (double)n / 20.0, (double)n2 / 20.0, d, true);
                    commandSender.sendMessage("Added state " + string + " to " + nPC.getName());
                    break;
                }
                case "remove": {
                    boolean bl = Boolean.parseBoolean(CitizensCommand.tryGetOrDefault(stringArray, 4, "false"));
                    if (bl) {
                        activeModel.getAnimationHandler().forceStopAnimation(string);
                    } else {
                        activeModel.getAnimationHandler().forceStopAnimation(string);
                    }
                    commandSender.sendMessage("Removed state " + string + " from " + nPC.getName());
                }
            }
            return false;
        }

        @Override
        public List<String> onTabComplete(CommandSender commandSender, String[] stringArray) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = stringArray[stringArray.length - 1];
            switch (stringArray.length) {
                case 1: {
                    CitizensCommand.getNPCIdTabComplete(arrayList);
                    break;
                }
                case 2: {
                    ModelTrait modelTrait = (ModelTrait)CitizensCommand.getNPC(stringArray[0]).getTraitNullable(ModelTrait.class);
                    if (modelTrait == null) break;
                    MECommand.getModelIdTabComplete(arrayList, string, modelTrait.getModeledEntity());
                    break;
                }
                case 3: {
                    if ("add".startsWith(string)) {
                        arrayList.add("add");
                    }
                    if (!"remove".startsWith(string)) break;
                    arrayList.add("remove");
                    break;
                }
                case 4: {
                    ModelTrait modelTrait = (ModelTrait)CitizensCommand.getNPC(stringArray[0]).getTraitNullable(ModelTrait.class);
                    if (modelTrait == null) {
                        return arrayList;
                    }
                    ModeledEntity modeledEntity = modelTrait.getModeledEntity();
                    ActiveModel activeModel = modeledEntity.getModel(stringArray[1]);
                    if (activeModel == null) {
                        return arrayList;
                    }
                    switch (stringArray[2]) {
                        case "add": {
                            MECommand.getStateTabComplete(arrayList, string, activeModel.getBlueprint());
                            break;
                        }
                        case "remove": {
                            MECommand.getStateTabComplete(arrayList, string, activeModel);
                        }
                    }
                    break;
                }
                case 5: {
                    switch (stringArray[2]) {
                        case "add": {
                            arrayList.add("[lerpin]");
                            break;
                        }
                        case "remove": {
                            arrayList.add("[ignoreLerp]");
                            if ("true".startsWith(string)) {
                                arrayList.add("true");
                            }
                            if (!"false".startsWith(string)) break;
                            arrayList.add("false");
                        }
                    }
                    break;
                }
                case 6: {
                    if (!"add".equals(stringArray[2])) break;
                    arrayList.add("[lerpout]");
                    break;
                }
                case 7: {
                    if (!"add".equals(stringArray[2])) break;
                    arrayList.add("[speed]");
                }
            }
            return arrayList;
        }

        @Override
        public String getPermissionNode() {
            return "modelengine.command.npc.state";
        }

        @Override
        public boolean isConsoleFriendly() {
            return true;
        }

        @Override
        public String getName() {
            return "state";
        }
    }
}

