/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.command.sub;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.command.AbstractCommand;
import com.ticxo.modelengine.api.events.ModelRegistrationEvent;
import com.ticxo.modelengine.api.utils.logger.LogColor;
import com.ticxo.modelengine.api.utils.logger.TLogger;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;

public class ReloadCommand
extends AbstractCommand {
    public ReloadCommand(AbstractCommand abstractCommand) {
        super(abstractCommand);
    }

    @Override
    public boolean onCommand(CommandSender commandSender, String[] stringArray) {
        if (stringArray.length == 0) {
            this.reloadConfig(commandSender);
            this.reloadModels(commandSender);
            return true;
        }
        switch (stringArray[0]) {
            case "models": {
                this.reloadModels(commandSender);
                break;
            }
            case "config": {
                this.reloadConfig(commandSender);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void reloadConfig(CommandSender commandSender) {
        ModelEngineAPI.getConfigManager().reload();
        ModelEngineAPI.getConfigManager().updateReferences();
        if (commandSender instanceof Entity) {
            commandSender.sendMessage(ChatColor.GREEN + "[ModelEngine] Config reloaded.");
        } else {
            TLogger.log(LogColor.BRIGHT_GREEN + "Config reloaded.");
        }
    }

    private void reloadModels(CommandSender commandSender) {
        ModelEngineAPI.api.getGenerator().importModelsAsync();
        ModelEngineAPI.api.getGenerator().queueTask(ModelRegistrationEvent.Phase.POST, () -> {
            String string = ModelEngineAPI.api.getModelRegistry().getAllBlueprintId().size() + " models loaded.";
            if (commandSender instanceof Entity) {
                commandSender.sendMessage(ChatColor.GREEN + "[ModelEngine] " + string);
            } else {
                TLogger.log();
                TLogger.log(LogColor.BRIGHT_GREEN + string);
            }
        });
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, String[] stringArray) {
        return List.of("models", "config");
    }

    @Override
    public String getPermissionNode() {
        return "modelengine.command.reload";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "reload";
    }
}

