/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.command.sub;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.command.AbstractCommand;
import com.ticxo.modelengine.api.model.ModeledEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;
import org.jetbrains.annotations.Nullable;

public class SelectCommand
extends AbstractCommand {
    public static final Map<CommandSender, ModeledEntity> SELECTED = Maps.newConcurrentMap();

    public SelectCommand(AbstractCommand abstractCommand) {
        super(abstractCommand);
    }

    @Override
    public boolean onCommand(CommandSender commandSender, String[] stringArray) {
        ModeledEntity modeledEntity = null;
        if (stringArray.length >= 1) {
            CommandSender commandSender2;
            String string = stringArray[0];
            if ("self".equalsIgnoreCase(string) && (commandSender2 = commandSender) instanceof Player) {
                Player player = (Player)commandSender2;
                modeledEntity = ModelEngineAPI.getModelTicker().getModeledEntity(player.getUniqueId());
            } else {
                modeledEntity = ModelEngineAPI.getModelTicker().getModeledEntity(UUID.fromString(string));
            }
        } else {
            CommandSender commandSender3 = commandSender;
            if (commandSender3 instanceof Player) {
                Player player = (Player)commandSender3;
                modeledEntity = SelectCommand.getTargetedModeledEntity(player);
            }
        }
        if (modeledEntity == null) {
            SELECTED.remove(commandSender);
        } else {
            SELECTED.put(commandSender, modeledEntity);
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (UUID uUID : ModelEngineAPI.getModelTicker().getAllModeledEntityUUID()) {
            arrayList.add(uUID.toString());
        }
        return arrayList;
    }

    @Override
    public String getPermissionNode() {
        return "modelengine.command.select";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String[] getAliases() {
        return new String[]{"sel"};
    }

    @Override
    public String getName() {
        return "select";
    }

    @Nullable
    private static ModeledEntity getTargetedModeledEntity(Player player) {
        Location location = player.getEyeLocation();
        RayTraceResult rayTraceResult = player.getWorld().rayTraceEntities(location, location.getDirection(), 32.0, entity -> ModelEngineAPI.isModeledEntity(entity.getUniqueId()));
        if (rayTraceResult == null) {
            return null;
        }
        Entity entity2 = rayTraceResult.getHitEntity();
        if (entity2 == null) {
            return null;
        }
        return ModelEngineAPI.getModeledEntity(entity2.getUniqueId());
    }
}

