/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.generator;

import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.error.IError;
import com.ticxo.modelengine.api.events.ModelRegistrationEvent;
import com.ticxo.modelengine.api.generator.BaseItemEnum;
import com.ticxo.modelengine.api.generator.ModelGenerator;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.generator.parser.ModelParser;
import com.ticxo.modelengine.api.model.mananger.ModelRegistry;
import com.ticxo.modelengine.api.utils.TFile;
import com.ticxo.modelengine.api.utils.config.ConfigProperty;
import com.ticxo.modelengine.api.utils.logger.LogColor;
import com.ticxo.modelengine.api.utils.logger.TLogger;
import com.ticxo.modelengine.generator.atlas.AtlasManager;
import com.ticxo.modelengine.generator.java.BaseItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ModelGeneratorImpl
implements ModelGenerator {
    private final Set<ModelParser> parsers = Sets.newConcurrentHashSet();
    private final File blueprintFolder;
    private final File packFolder;
    private final File baseItemFolder;
    private final File zippedResourcePack;
    private final ModelRegistry registry;
    private final AtlasManager atlasManager;
    private boolean initialized;
    private final Map<ModelRegistrationEvent.Phase, Set<Runnable>> tasks = Maps.newConcurrentMap();
    private final List<Runnable> assetTasks = new ArrayList<Runnable>();
    private File modelFolder;
    private File textureFolder;
    private String namespace;
    private BaseItemEnum baseItemType;
    private BaseItem baseItem;

    public ModelGeneratorImpl() {
        this.blueprintFolder = TFile.createDirectory(ModelEngineAPI.api.getDataFolder(), "blueprints");
        this.packFolder = TFile.createDirectory(ModelEngineAPI.api.getDataFolder(), "resource pack");
        this.baseItemFolder = TFile.createDirectory(this.packFolder, "assets", "minecraft", "models", "item");
        this.zippedResourcePack = TFile.createFile(ModelEngineAPI.api.getDataFolder(), "resource pack.zip");
        this.registry = ModelEngineAPI.api.getModelRegistry();
        this.atlasManager = new AtlasManager(this);
        ModelEngineAPI.getConfigManager().registerReferenceUpdate(this::updateConfigs);
    }

    public void updateConfigs() {
        this.changeNamespace(ConfigProperty.NAMESPACE.getString());
        this.changeBaseItem(ConfigProperty.ITEM_MODEL.getBaseItem());
    }

    @Override
    public void queueTask(ModelRegistrationEvent.Phase phase, Runnable runnable) {
        Set set = this.tasks.get((Object)phase);
        if (set == null) {
            set = Sets.newConcurrentHashSet();
            this.tasks.put(phase, set);
        }
        set.add(runnable);
    }

    private void executeQueuedTask(ModelRegistrationEvent.Phase phase) {
        Set<Runnable> set = this.tasks.get((Object)phase);
        if (set == null) {
            return;
        }
        set.forEach(Runnable::run);
        set.clear();
    }

    @Override
    public void registerModelParser(ModelParser modelParser) {
        this.parsers.add(modelParser);
    }

    @Override
    public void changeNamespace(String string) {
        this.namespace = string;
        this.modelFolder = TFile.createDirectory(this.packFolder, "assets", string, "models");
        this.textureFolder = TFile.createDirectory(this.packFolder, "assets", string, "textures", "entity");
    }

    @Override
    public void changeBaseItem(BaseItemEnum baseItemEnum) {
        this.baseItemType = baseItemEnum;
        String string = baseItemEnum.name().toLowerCase(Locale.ENGLISH);
        InputStream inputStream = ModelEngineAPI.api.getResource("pack/colorable/" + string + ".json");
        if (inputStream == null) {
            TLogger.warn("Unknown colorable item: " + string + ". Reverting to use leather_horse_armor.");
            inputStream = ModelEngineAPI.api.getResource("pack/colorable/leather_horse_armor.json");
        }
        if (inputStream == null) {
            TLogger.error("Unable to locate base files.");
            return;
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        this.baseItem = (BaseItem)ModelEngineAPI.gson.fromJson((Reader)inputStreamReader, BaseItem.class);
        this.baseItem.setName(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void importModels() {
        TLogger.log();
        TLogger.log(LogColor.BOLD + LogColor.CYAN.toString() + "[Importing models]");
        ModelEngineAPI.callEvent(new ModelRegistrationEvent(ModelRegistrationEvent.Phase.PRE));
        this.executeQueuedTask(ModelRegistrationEvent.Phase.PRE);
        this.registry.clearRegistry();
        if (!this.blueprintFolder.isDirectory()) {
            return;
        }
        File[] fileArray = this.blueprintFolder.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        List<File> list = Arrays.asList(fileArray);
        LinkedList<File> linkedList = new LinkedList<File>();
        list.sort((Comparator<File>)Ordering.natural());
        int n = -1;
        this.baseItem.resetData();
        while (true) {
            File[] fileArray2;
            for (File file : list) {
                if (!file.isFile()) {
                    if (!file.isDirectory()) continue;
                    linkedList.add(file);
                    continue;
                }
                boolean bl = false;
                TLogger.log();
                TLogger.log(LogColor.CYAN + "Importing " + file.getName() + ".");
                for (ModelParser modelParser : this.parsers) {
                    if (!modelParser.validateFile(file)) continue;
                    try {
                        ModelBlueprint modelBlueprint = modelParser.generate(file);
                        if (modelBlueprint == null) continue;
                        modelBlueprint.constructFlatBoneMap();
                        this.registry.registerBlueprint(modelBlueprint);
                        bl = true;
                        break;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        break;
                    }
                }
                if (bl) continue;
                IError.UNKNOWN_FORMAT.log();
            }
            do {
                if (linkedList.isEmpty()) {
                    ModelEngineAPI.callEvent(new ModelRegistrationEvent(ModelRegistrationEvent.Phase.POST));
                    this.executeQueuedTask(ModelRegistrationEvent.Phase.POST);
                    return;
                }
                fileArray2 = ((File)linkedList.poll()).listFiles();
                this.baseItem.offsetData(n += ConfigProperty.COMPARTMENT_SIZE.getInt());
            } while (fileArray2 == null || fileArray2.length == 0);
            list = Arrays.asList(fileArray2);
            list.sort((Comparator<File>)Ordering.natural());
        }
    }

    private void generateAssets() {
        TLogger.log();
        TLogger.log(LogColor.BOLD + LogColor.PURPLE.toString() + "[Generating assets]");
        for (Runnable object : this.assetTasks) {
            object.run();
        }
        this.assetTasks.clear();
        File file = TFile.createFile(this.baseItemFolder, this.baseItem.getName() + ".json");
        try {
            FileWriter iOException = new FileWriter(file);
            iOException.write(ModelEngineAPI.gson.toJson((Object)this.baseItem));
            iOException.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.atlasManager.generateFile();
        TFile.copyResource(TFile.createFile(this.packFolder, "pack.png"), "pack/pack.png");
        TFile.copyResource(TFile.createFile(this.packFolder, "pack.mcmeta"), "pack/pack.mcmeta");
        if (ConfigProperty.ZIP.getBoolean()) {
            this.zipResourcePack();
        }
        ModelEngineAPI.callEvent(new ModelRegistrationEvent(ModelRegistrationEvent.Phase.FINAL));
        this.executeQueuedTask(ModelRegistrationEvent.Phase.FINAL);
    }

    @Override
    public void importModelsAsync() {
        if (ConfigProperty.LATE_REGISTER.getBoolean()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)ModelEngineAPI.api, () -> {
                this.initialized = false;
                this.importModels();
                this.initialized = true;
                this.generateAssets();
            });
        } else {
            this.initialized = false;
            this.importModels();
            this.initialized = true;
            if (ConfigProperty.LATE_ASSETS.getBoolean()) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)ModelEngineAPI.api, this::generateAssets);
            } else {
                this.generateAssets();
            }
        }
    }

    @Override
    public void zipResourcePack() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.zippedResourcePack);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            File[] fileArray = this.packFolder.listFiles();
            if (fileArray == null) {
                return;
            }
            for (File file : fileArray) {
                this.zipFile(file, file.getName(), zipOutputStream);
            }
            zipOutputStream.close();
            fileOutputStream.close();
            TLogger.log();
            TLogger.log(LogColor.BRIGHT_GREEN + "Resource pack zipped.");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void zipFile(File file, String string, ZipOutputStream zipOutputStream) {
        int n;
        if (file.isHidden()) {
            return;
        }
        if (file.isDirectory()) {
            if (string.endsWith("/")) {
                zipOutputStream.putNextEntry(new ZipEntry(string));
            } else {
                zipOutputStream.putNextEntry(new ZipEntry(string + "/"));
            }
            zipOutputStream.closeEntry();
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    this.zipFile(file2, string + "/" + file2.getName(), zipOutputStream);
                }
            }
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        ZipEntry zipEntry = new ZipEntry(string);
        zipOutputStream.putNextEntry(zipEntry);
        byte[] byArray = new byte[1024];
        while ((n = fileInputStream.read(byArray)) >= 0) {
            zipOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
    }

    public Set<ModelParser> getParsers() {
        return this.parsers;
    }

    public File getBaseItemFolder() {
        return this.baseItemFolder;
    }

    public File getZippedResourcePack() {
        return this.zippedResourcePack;
    }

    public ModelRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public Map<ModelRegistrationEvent.Phase, Set<Runnable>> getTasks() {
        return this.tasks;
    }

    public File getModelFolder() {
        return this.modelFolder;
    }

    public File getTextureFolder() {
        return this.textureFolder;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public BaseItemEnum getBaseItemType() {
        return this.baseItemType;
    }

    public BaseItem getBaseItem() {
        return this.baseItem;
    }

    @Override
    public File getBlueprintFolder() {
        return this.blueprintFolder;
    }

    @Override
    public File getPackFolder() {
        return this.packFolder;
    }

    public AtlasManager getAtlasManager() {
        return this.atlasManager;
    }

    public List<Runnable> getAssetTasks() {
        return this.assetTasks;
    }
}

