/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.generator.parser.blockbench;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.animation.blueprint.BlueprintAnimation;
import com.ticxo.modelengine.api.animation.blueprint.LoopMode;
import com.ticxo.modelengine.api.animation.keyframe.IKeyframeData;
import com.ticxo.modelengine.api.animation.keyframe.KeyframeType;
import com.ticxo.modelengine.api.animation.keyframe.type.ParticleKeyframe;
import com.ticxo.modelengine.api.animation.keyframe.type.ScriptKeyframe;
import com.ticxo.modelengine.api.animation.keyframe.type.SoundKeyframe;
import com.ticxo.modelengine.api.animation.timeline.Timeline;
import com.ticxo.modelengine.api.error.ErrorBadTexture;
import com.ticxo.modelengine.api.error.ErrorNoFaceCube;
import com.ticxo.modelengine.api.error.IError;
import com.ticxo.modelengine.api.error.WarnBadNamespace;
import com.ticxo.modelengine.api.generator.Hitbox;
import com.ticxo.modelengine.api.generator.ModelGenerator;
import com.ticxo.modelengine.api.generator.model.BlueprintBone;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.utils.TFile;
import com.ticxo.modelengine.api.utils.logger.LogColor;
import com.ticxo.modelengine.api.utils.logger.TLogger;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.generator.java.JavaItemModel;
import com.ticxo.modelengine.generator.parser.blockbench.BlockbenchPackage;
import com.ticxo.modelengine.generator.parser.blockbench.component.BlockbenchElement;
import com.ticxo.modelengine.generator.parser.blockbench.component.BlockbenchFace;
import com.ticxo.modelengine.generator.parser.blockbench.component.BlockbenchTexture;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class BlockbenchDeserializer
implements JsonDeserializer<BlockbenchPackage> {
    private static final String[] faceDirections = new String[]{"north", "east", "south", "west", "up", "down"};
    private final ModelGenerator generator;
    private final Map<String, String> mcmetas = Maps.newConcurrentMap();
    private final Map<String, BlockbenchElement> elementsCache = Maps.newConcurrentMap();
    int[] resolution;

    public BlockbenchDeserializer(ModelGenerator modelGenerator) {
        this.generator = modelGenerator;
    }

    public BlockbenchPackage deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        BlockbenchPackage blockbenchPackage = new BlockbenchPackage(new ModelBlueprint());
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        boolean bl = jsonObject.getAsJsonObject("meta").get("box_uv").getAsBoolean();
        if (bl) {
            IError.BOX_UV.log();
        }
        this.readResolution(jsonObject);
        this.readElements(jsonObject);
        this.readMCMetas(jsonObject);
        this.readTextures(jsonObject, blockbenchPackage);
        this.readOutliner(jsonObject, blockbenchPackage);
        this.readAnimationPlaceholder(jsonObject, blockbenchPackage);
        this.readAnimations(jsonObject, blockbenchPackage);
        blockbenchPackage.cleanUpElements();
        this.mcmetas.clear();
        this.elementsCache.clear();
        if (blockbenchPackage.getBlueprint().getMainHitbox() == null) {
            IError.NO_HITBOX.log();
        } else if (blockbenchPackage.getBlueprint().getMainHitbox().getEyeHeight() <= 0.0) {
            IError.BAD_EYE_HEIGHT.log();
        }
        return blockbenchPackage;
    }

    private void readResolution(JsonObject jsonObject) {
        if (!jsonObject.has("resolution")) {
            return;
        }
        JsonObject jsonObject2 = jsonObject.getAsJsonObject("resolution");
        int n = jsonObject2.get("width").getAsInt();
        int n2 = jsonObject2.get("height").getAsInt();
        this.resolution = new int[]{n, n2};
    }

    private void readElements(JsonObject jsonObject) {
        if (!jsonObject.has("elements")) {
            return;
        }
        JsonArray jsonArray = jsonObject.getAsJsonArray("elements");
        for (JsonElement jsonElement : jsonArray) {
            BlockbenchElement blockbenchElement;
            String string;
            JsonObject jsonObject2 = jsonElement.getAsJsonObject();
            String string2 = string = jsonObject2.has("type") ? jsonObject2.get("type").getAsString() : null;
            if (string != null && !string.equals("cube")) continue;
            String string3 = jsonObject2.get("uuid").getAsString();
            String string4 = jsonObject2.get("name").getAsString();
            JsonArray jsonArray2 = jsonObject2.get("from").getAsJsonArray();
            JsonArray jsonArray3 = jsonObject2.get("to").getAsJsonArray();
            JsonArray jsonArray4 = jsonObject2.get("origin").getAsJsonArray();
            double d = jsonObject2.has("inflate") ? jsonObject2.get("inflate").getAsDouble() : 0.0;
            Vector vector = new Vector(jsonArray2.get(0).getAsDouble(), jsonArray2.get(1).getAsDouble(), jsonArray2.get(2).getAsDouble());
            Vector vector2 = new Vector(jsonArray3.get(0).getAsDouble(), jsonArray3.get(1).getAsDouble(), jsonArray3.get(2).getAsDouble());
            Vector vector3 = new Vector(jsonArray4.get(0).getAsDouble(), jsonArray4.get(1).getAsDouble(), jsonArray4.get(2).getAsDouble());
            EulerAngle eulerAngle = EulerAngle.ZERO;
            if (jsonObject2.has("rotation")) {
                blockbenchElement = jsonObject2.get("rotation").getAsJsonArray();
                eulerAngle = TMath.makeAngle(blockbenchElement.get(0).getAsDouble(), blockbenchElement.get(1).getAsDouble(), blockbenchElement.get(2).getAsDouble());
            }
            blockbenchElement = new BlockbenchElement();
            blockbenchElement.setName(string4);
            blockbenchElement.setFrom(vector);
            blockbenchElement.setTo(vector2);
            blockbenchElement.setRotation(eulerAngle);
            blockbenchElement.setOrigin(vector3);
            blockbenchElement.setInflate(d);
            JsonObject jsonObject3 = jsonObject2.getAsJsonObject("faces");
            for (String string5 : faceDirections) {
                double d2;
                double d3;
                double d4;
                JsonObject jsonObject4;
                JsonArray jsonArray5;
                double d5;
                if (!jsonObject3.has(string5) || this.isZeroUV(d5 = (jsonArray5 = (jsonObject4 = jsonObject3.getAsJsonObject(string5)).get("uv").getAsJsonArray()).get(0).getAsDouble(), d4 = jsonArray5.get(1).getAsDouble(), d3 = jsonArray5.get(2).getAsDouble(), d2 = jsonArray5.get(3).getAsDouble())) continue;
                Integer n = this.getUVRot(jsonObject4, "rotation", 0);
                Integer n2 = this.getUVRot(jsonObject4, "texture", null);
                BlockbenchFace blockbenchFace = new BlockbenchFace(this.resolution, d5, d4, d3, d2, n, n2);
                blockbenchElement.getFaces().put(string5, blockbenchFace);
            }
            this.elementsCache.put(string3, blockbenchElement);
        }
    }

    private boolean isZeroUV(double d, double d2, double d3, double d4) {
        return Math.abs(d3 - d) < 1.0E-5 && Math.abs(d4 - d2) < 1.0E-5;
    }

    private Integer getUVRot(JsonObject jsonObject, String string, Integer n) {
        if (!jsonObject.has(string)) {
            return n;
        }
        JsonElement jsonElement = jsonObject.get(string);
        if (jsonElement.isJsonNull()) {
            return n;
        }
        return jsonElement.getAsInt();
    }

    private void readTextures(JsonObject jsonObject, BlockbenchPackage blockbenchPackage) {
        if (!jsonObject.has("textures")) {
            return;
        }
        JsonArray jsonArray = jsonObject.getAsJsonArray("textures");
        for (JsonElement jsonElement : jsonArray) {
            JsonObject jsonObject2 = jsonElement.getAsJsonObject();
            String string = TFile.removeExtension(jsonObject2.get("name").getAsString()).toLowerCase(Locale.ENGLISH).trim().toLowerCase(Locale.ENGLISH);
            if (string.matches(".*[^a-z0-9_.-].*")) {
                new ErrorBadTexture(string).log();
            }
            String string2 = jsonObject2.get("folder").getAsString().toLowerCase(Locale.ENGLISH);
            String string3 = jsonObject2.get("namespace").getAsString().toLowerCase(Locale.ENGLISH);
            String string4 = jsonObject2.get("uuid").getAsString();
            String string5 = jsonObject2.get("source").getAsString();
            if (string3.isEmpty() || string3.equalsIgnoreCase(this.generator.getNamespace())) {
                string3 = this.generator.getNamespace();
                string2 = "entity";
            } else if (string3.matches(".*[^a-z0-9_.-].*")) {
                new WarnBadNamespace(string3).log();
                string3 = this.generator.getNamespace();
                string2 = "entity";
            }
            int n = jsonObject2.get("uv_width") != null ? jsonObject2.get("uv_width").getAsInt() : this.resolution[0];
            int n2 = jsonObject2.get("uv_height") != null ? jsonObject2.get("uv_height").getAsInt() : this.resolution[1];
            BlockbenchTexture blockbenchTexture = new BlockbenchTexture(n, n2, string, string2, string3, string5);
            blockbenchTexture.setMcmeta(this.mcmetas.get(string4));
            blockbenchPackage.getTexturesCache().add(blockbenchTexture);
        }
    }

    private void readMCMetas(JsonObject jsonObject) {
        if (!jsonObject.has("mcmetas")) {
            return;
        }
        JsonElement jsonElement = jsonObject.get("mcmetas");
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject2 = jsonElement.getAsJsonObject();
            for (Map.Entry entry : jsonObject2.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = ((JsonElement)entry.getValue()).toString();
                this.mcmetas.put(string, string2);
            }
        }
    }

    private void readOutliner(JsonObject jsonObject, BlockbenchPackage blockbenchPackage) {
        if (!jsonObject.has("outliner")) {
            return;
        }
        JsonArray jsonArray = jsonObject.getAsJsonArray("outliner");
        for (JsonElement jsonElement : jsonArray) {
            JsonObject jsonObject2;
            BlueprintBone blueprintBone;
            if (!jsonElement.isJsonObject() || (blueprintBone = this.readBone(jsonObject2 = jsonElement.getAsJsonObject(), blockbenchPackage)) == null) continue;
            blockbenchPackage.getBlueprint().getBones().put(blueprintBone.getName(), blueprintBone);
            blockbenchPackage.getBlueprint().getFinalBoneNames().put(blueprintBone.getUuid(), blueprintBone.getName());
        }
    }

    @Nullable
    private BlueprintBone readBone(JsonObject jsonObject, BlockbenchPackage blockbenchPackage) {
        JsonElement jsonElement;
        JsonArray jsonArray;
        Object object;
        String string = jsonObject.get("name").getAsString().toLowerCase(Locale.ENGLISH);
        JsonArray jsonArray2 = jsonObject.get("origin").getAsJsonArray();
        Vector vector = new Vector(jsonArray2.get(0).getAsDouble(), jsonArray2.get(1).getAsDouble(), jsonArray2.get(2).getAsDouble());
        Vector vector2 = new Vector(-vector.getX(), vector.getY(), -vector.getZ()).multiply(0.0625);
        EulerAngle eulerAngle = EulerAngle.ZERO;
        UUID uUID = UUID.fromString(jsonObject.get("uuid").getAsString());
        if (jsonObject.has("rotation")) {
            object = jsonObject.get("rotation").getAsJsonArray();
            eulerAngle = TMath.makeAngle(-object.get(0).getAsDouble(), -object.get(1).getAsDouble(), object.get(2).getAsDouble());
        }
        if (string.equalsIgnoreCase("hitbox") && (object = jsonObject.get("children").getAsJsonArray()).size() > 0 && !(jsonArray = object.get(0)).isJsonObject()) {
            String string2 = jsonArray.getAsString();
            blockbenchPackage.getBlueprint().setMainHitbox(this.buildHitbox(string2, vector2.getY()));
            return null;
        }
        object = new BlueprintBone();
        ((BlueprintBone)object).setName(string);
        ((BlueprintBone)object).setItemOrigin(vector);
        ((BlueprintBone)object).setGlobalOrigin(vector2);
        ((BlueprintBone)object).setLocalOrigin(vector2);
        ((BlueprintBone)object).setLocalRotation(eulerAngle);
        ((BlueprintBone)object).setUuid(uUID);
        if (string.startsWith("h_")) {
            string = string.substring(2);
            ((BlueprintBone)object).setOption("head");
            ((BlueprintBone)object).setName(string);
        }
        if (string.startsWith("g_")) {
            string = string.substring(2);
            ((BlueprintBone)object).setOption("ghost");
            ((BlueprintBone)object).setName(string);
        }
        if (string.equalsIgnoreCase("mount")) {
            ((BlueprintBone)object).setOption("mount");
            return object;
        }
        if (string.startsWith("b_") && (jsonArray = jsonObject.get("children").getAsJsonArray()).size() > 0 && !(jsonElement = jsonArray.get(0)).isJsonObject()) {
            String string3 = jsonElement.getAsString();
            blockbenchPackage.getBlueprint().getSubHitboxes().put(string, this.buildHitbox(string3, vector2.getY()));
            ((BlueprintBone)object).setGlobalOrigin(this.getCubeCenter(string3));
            ((BlueprintBone)object).setOption("sub_aabb");
            return object;
        }
        if (string.startsWith("ob_") && (jsonArray = jsonObject.get("children").getAsJsonArray()).size() > 0 && !(jsonElement = jsonArray.get(0)).isJsonObject()) {
            String string4 = jsonElement.getAsString();
            blockbenchPackage.getBlueprint().getSubHitboxes().put(string, this.buildHitbox(string4, vector2.getY()));
            ((BlueprintBone)object).setGlobalOrigin(this.getCubeCenter(string4));
            ((BlueprintBone)object).setOption("sub_obb");
            return object;
        }
        jsonArray = string.split("_");
        block18: for (int i = 0; i < ((JsonArray)jsonArray).length - 1; ++i) {
            JsonArray jsonArray3 = jsonArray[i];
            switch (jsonArray3) {
                case "tag": {
                    if (((BlueprintBone)object).isHasModel()) break block18;
                    string = string.substring(4);
                    ((BlueprintBone)object).setOption("tag");
                    continue block18;
                }
                case "p": {
                    if (((BlueprintBone)object).isHasModel()) break block18;
                    string = string.substring(2);
                    ((BlueprintBone)object).setOption("seat");
                    continue block18;
                }
                case "ir": {
                    if (((BlueprintBone)object).isHasModel()) break block18;
                    string = string.substring(3);
                    ((BlueprintBone)object).setString("item", "main_hand");
                    continue block18;
                }
                case "il": {
                    if (((BlueprintBone)object).isHasModel()) break block18;
                    string = string.substring(3);
                    ((BlueprintBone)object).setString("item", "off_hand");
                    continue block18;
                }
                case "ih": {
                    if (((BlueprintBone)object).isHasModel()) break block18;
                    string = string.substring(3);
                    ((BlueprintBone)object).setString("item", "head");
                    continue block18;
                }
                case "seg": {
                    string = string.substring(4);
                    ((BlueprintBone)object).setOption("segment");
                    continue block18;
                }
                case "l": {
                    if (((BlueprintBone)object).isHasModel()) break block18;
                    string = string.substring(2);
                    ((BlueprintBone)object).setOption("leash");
                    continue block18;
                }
            }
        }
        ((BlueprintBone)object).setName(string);
        JsonArray jsonArray4 = jsonObject.get("children").getAsJsonArray();
        for (JsonArray jsonArray5 : jsonArray4) {
            BlockbenchElement blockbenchElement;
            if (jsonArray5.isJsonObject()) {
                BlueprintBone blueprintBone = this.readBone(jsonArray5.getAsJsonObject(), blockbenchPackage);
                if (blueprintBone == null) continue;
                blockbenchPackage.getBlueprint().getFinalBoneNames().put(blueprintBone.getUuid(), blueprintBone.getName());
                blueprintBone.setLocalOrigin(blueprintBone.getGlobalOrigin().clone().subtract(((BlueprintBone)object).getGlobalOrigin()));
                ((BlueprintBone)object).getChildren().add(blueprintBone);
                continue;
            }
            String string5 = jsonArray5.getAsString();
            JavaItemModel javaItemModel = blockbenchPackage.getModelCache().get(string);
            if (javaItemModel == null) {
                javaItemModel = new JavaItemModel(string, blockbenchPackage.getTexturesCache(), (BlueprintBone)object);
                ((BlueprintBone)object).setHasModel(true);
                blockbenchPackage.getModelCache().put(string, javaItemModel);
            }
            if ((blockbenchElement = this.elementsCache.get(string5)) == null) continue;
            if (blockbenchElement.getFaces().isEmpty()) {
                new ErrorNoFaceCube(string, blockbenchElement.getName()).log();
                continue;
            }
            javaItemModel.addElement(blockbenchElement);
        }
        return object;
    }

    private void readAnimationPlaceholder(JsonObject jsonObject, BlockbenchPackage blockbenchPackage) {
        String[] stringArray;
        if (!jsonObject.has("animation_variable_placeholders")) {
            return;
        }
        for (String string : stringArray = jsonObject.get("animation_variable_placeholders").getAsString().split("\n")) {
            String[] stringArray2 = string.split("=", 2);
            blockbenchPackage.getBlueprint().getAnimationsPlaceholders().put(stringArray2[0], stringArray2.length == 2 ? stringArray2[1] : "");
        }
    }

    private void readAnimations(JsonObject jsonObject, BlockbenchPackage blockbenchPackage) {
        if (!jsonObject.has("animations")) {
            return;
        }
        JsonArray jsonArray = jsonObject.getAsJsonArray("animations");
        for (JsonElement jsonElement : jsonArray) {
            JsonObject jsonObject2 = jsonElement.getAsJsonObject();
            String string = jsonObject2.get("name").getAsString().toLowerCase(Locale.ENGLISH);
            BlueprintAnimation blueprintAnimation = new BlueprintAnimation(string);
            TLogger.log(2, LogColor.CYAN + "--Parsing animation " + string + ".");
            if (jsonObject2.has("loop")) {
                blueprintAnimation.setLoopMode(LoopMode.get(jsonObject2.get("loop").getAsString()));
            }
            if (jsonObject2.has("override")) {
                blueprintAnimation.setOverride(jsonObject2.get("override").getAsBoolean());
            }
            if (jsonObject2.has("length")) {
                blueprintAnimation.setLength(jsonObject2.get("length").getAsFloat());
            }
            if (jsonObject2.has("animators")) {
                JsonObject jsonObject3 = jsonObject2.get("animators").getAsJsonObject();
                for (Map.Entry entry : jsonObject3.entrySet()) {
                    String string2;
                    String string3;
                    Object object;
                    String string4 = (String)entry.getKey();
                    JsonObject jsonObject4 = ((JsonElement)entry.getValue()).getAsJsonObject();
                    if ("effects".equals(string4)) {
                        object = blueprintAnimation.getOrCreateTimeline("effects");
                        this.configureEffectsTimeline((Timeline)object, jsonObject4.get("keyframes"));
                        continue;
                    }
                    object = UUID.fromString(string4);
                    String string5 = string3 = jsonObject4.has("type") ? jsonObject4.get("type").getAsString() : null;
                    if (string3 != null && !"bone".equals(string3) || (string2 = blockbenchPackage.getBlueprint().getFinalBoneNames().get(object)) == null) continue;
                    TLogger.log(2, LogColor.CYAN + "----Parsing timeline " + string2 + ".");
                    Timeline timeline = blueprintAnimation.getOrCreateTimeline(string2);
                    this.configureTimeline(timeline, jsonObject4.get("keyframes"), blockbenchPackage);
                }
            }
            blockbenchPackage.getBlueprint().getAnimations().put(string, blueprintAnimation);
        }
    }

    private void configureTimeline(Timeline timeline, JsonElement jsonElement, BlockbenchPackage blockbenchPackage) {
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        for (JsonElement jsonElement2 : jsonArray) {
            JsonObject jsonObject = jsonElement2.getAsJsonObject();
            if (!jsonObject.has("channel") || !jsonObject.has("data_points") || !jsonObject.has("time")) continue;
            String string = jsonObject.get("channel").getAsString();
            JsonObject jsonObject2 = jsonObject.get("data_points").getAsJsonArray().get(0).getAsJsonObject();
            IKeyframeData iKeyframeData = ModelEngineAPI.getKeyframeReaderRegistry().tryParse(jsonObject2.get("x").getAsString());
            IKeyframeData iKeyframeData2 = ModelEngineAPI.getKeyframeReaderRegistry().tryParse(jsonObject2.get("y").getAsString());
            IKeyframeData iKeyframeData3 = ModelEngineAPI.getKeyframeReaderRegistry().tryParse(jsonObject2.get("z").getAsString());
            double d = jsonObject.get("time").getAsDouble();
            KeyframeType keyframeType = this.getType(jsonObject.get("interpolation").getAsString());
            switch (string) {
                case "rotation": {
                    timeline.addRotationFrame(d, iKeyframeData, iKeyframeData2, iKeyframeData3, keyframeType);
                    break;
                }
                case "position": {
                    timeline.addPositionFrame(d, iKeyframeData, iKeyframeData2, iKeyframeData3, keyframeType);
                    break;
                }
                case "scale": {
                    timeline.addScaleFrame(d, iKeyframeData, iKeyframeData2, iKeyframeData3, keyframeType);
                }
            }
        }
    }

    private void configureEffectsTimeline(Timeline timeline, JsonElement jsonElement) {
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        for (JsonElement jsonElement2 : jsonArray) {
            JsonObject jsonObject = jsonElement2.getAsJsonObject();
            if (!jsonObject.has("channel") || !jsonObject.has("data_points") || !jsonObject.has("time")) continue;
            String string = jsonObject.get("channel").getAsString();
            JsonArray jsonArray2 = jsonObject.get("data_points").getAsJsonArray();
            double d = jsonObject.get("time").getAsDouble();
            switch (string) {
                case "particle": {
                    JsonObject jsonObject2 = new ArrayList();
                    for (Object object2 : jsonArray2) {
                        JsonObject jsonObject3 = object2.getAsJsonObject();
                        String string2 = jsonObject3.get("effect").getAsString();
                        String string3 = jsonObject3.get("locator").getAsString();
                        jsonObject2.add(new ParticleKeyframe.Particles(string2, string3));
                    }
                    timeline.addParticleFrame(d, (List<ParticleKeyframe.Particles>)jsonObject2);
                    break;
                }
                case "sound": {
                    JsonObject jsonObject2 = new ArrayList();
                    for (Object object2 : jsonArray2) {
                        String string4 = object2.getAsJsonObject().get("effect").getAsString();
                        jsonObject2.add(new SoundKeyframe.Sounds(string4));
                    }
                    timeline.addSoundFrame(d, (List<SoundKeyframe.Sounds>)jsonObject2);
                    break;
                }
                case "timeline": {
                    Object object2;
                    JsonObject jsonObject2 = jsonArray2.get(0).getAsJsonObject();
                    String[] stringArray = jsonObject2.get("script").getAsString().split("\n");
                    object2 = new ArrayList();
                    for (String string5 : stringArray) {
                        String[] stringArray2 = string5.split(":", 2);
                        if (stringArray2.length == 1) {
                            object2.add(new ScriptKeyframe.Script(null, stringArray2[0]));
                            continue;
                        }
                        object2.add(new ScriptKeyframe.Script(stringArray2[0], stringArray2[1]));
                    }
                    timeline.addScriptFrame(d, (List<ScriptKeyframe.Script>)object2);
                }
            }
        }
    }

    private KeyframeType getType(String string) {
        return switch (string.toLowerCase(Locale.ENGLISH)) {
            case "catmullrom" -> KeyframeType.SMOOTH;
            case "step" -> KeyframeType.STEP;
            default -> KeyframeType.LINEAR;
        };
    }

    private Hitbox buildHitbox(String string, double d) {
        BlockbenchElement blockbenchElement = this.elementsCache.get(string);
        double d2 = (blockbenchElement.getTo().getX() - blockbenchElement.getFrom().getX()) / 16.0;
        double d3 = (blockbenchElement.getTo().getY() - blockbenchElement.getFrom().getY()) / 16.0;
        double d4 = (blockbenchElement.getTo().getZ() - blockbenchElement.getFrom().getZ()) / 16.0;
        return new Hitbox(d2, d3, d4, d);
    }

    private Vector getCubeCenter(String string) {
        BlockbenchElement blockbenchElement = this.elementsCache.get(string);
        double d = (blockbenchElement.getTo().getX() + blockbenchElement.getFrom().getX()) / 32.0;
        double d2 = (blockbenchElement.getTo().getY() + blockbenchElement.getFrom().getY()) / 32.0;
        double d3 = (blockbenchElement.getTo().getZ() + blockbenchElement.getFrom().getZ()) / 32.0;
        return new Vector(-d, d2, -d3);
    }

    private String getPlaceholderValue(String string, BlockbenchPackage blockbenchPackage) {
        return blockbenchPackage.getBlueprint().getAnimationsPlaceholders().getOrDefault(string, string);
    }
}

