/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.generator.parser.blockbench;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.generator.parser.ModelParser;
import com.ticxo.modelengine.api.utils.TFile;
import com.ticxo.modelengine.api.utils.config.ConfigProperty;
import com.ticxo.modelengine.api.utils.logger.LogColor;
import com.ticxo.modelengine.api.utils.logger.TLogger;
import com.ticxo.modelengine.generator.ModelGeneratorImpl;
import com.ticxo.modelengine.generator.parser.blockbench.BlockbenchDeserializer;
import com.ticxo.modelengine.generator.parser.blockbench.BlockbenchPackage;
import com.ticxo.modelengine.generator.parser.blockbench.component.BlockbenchTexture;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Locale;
import javax.imageio.ImageIO;

public class BlockbenchParser
implements ModelParser {
    private final ModelGeneratorImpl generator;
    private final Gson gson;

    public BlockbenchParser(ModelGeneratorImpl modelGeneratorImpl) {
        this.generator = modelGeneratorImpl;
        this.gson = new GsonBuilder().registerTypeAdapter(BlockbenchPackage.class, (Object)new BlockbenchDeserializer(modelGeneratorImpl)).create();
    }

    @Override
    public boolean validateFile(File file) {
        return TFile.isExtension(file.getName(), "bbmodel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelBlueprint generate(File file) {
        BlockbenchPackage blockbenchPackage;
        String string = TFile.removeExtension(file.getName()).toLowerCase(Locale.ENGLISH);
        try (FileReader fileReader = new FileReader(file);){
            blockbenchPackage = (BlockbenchPackage)this.gson.fromJson((Reader)fileReader, BlockbenchPackage.class);
        }
        blockbenchPackage.getBlueprint().setModelId(string);
        String string2 = ConfigProperty.NAMESPACE.getString();
        for (String string3 : blockbenchPackage.getModelCache().keySet()) {
            this.generator.getBaseItem().addModel(string2 + ":" + string + "/" + string3);
            blockbenchPackage.getBlueprint().getItemIds().put(string3, this.generator.getBaseItem().getData());
        }
        this.generator.getAssetTasks().add(() -> {
            TLogger.log();
            TLogger.log(LogColor.PURPLE + "Generating " + string + ".");
            try {
                Object object;
                File file;
                Object object2;
                for (String object3 : blockbenchPackage.getModelCache().keySet()) {
                    object2 = blockbenchPackage.getModelCache().get(object3);
                    file = TFile.createFile(this.generator.getModelFolder(), string, object3 + ".json");
                    object = new FileWriter(file);
                    ((Writer)object).write(this.gson.toJson(object2));
                    ((OutputStreamWriter)object).close();
                    TLogger.log(2, LogColor.PURPLE + "--" + object3 + ".json");
                }
                for (BlockbenchTexture blockbenchTexture : blockbenchPackage.getTexturesCache()) {
                    if (blockbenchTexture.getNamespace().equals("minecraft")) {
                        if (blockbenchTexture.getFolder().startsWith("block") || blockbenchTexture.getFolder().startsWith("item")) continue;
                        this.generator.getAtlasManager().addSingle(blockbenchTexture.getNamespace(), blockbenchTexture.getFolder() + "/" + blockbenchTexture.getName());
                        continue;
                    }
                    object2 = blockbenchTexture.getNamespace().equals(string2) ? this.generator.getTextureFolder() : TFile.createDirectory(this.generator.getPackFolder(), "assets", blockbenchTexture.getNamespace(), "textures", blockbenchTexture.getFolder());
                    file = TFile.createFile((File)object2, blockbenchTexture.getName() + ".png");
                    object = TFile.toImage(blockbenchTexture.getSource());
                    ImageIO.write((RenderedImage)object, "png", file);
                    TLogger.log(2, LogColor.PURPLE + "--" + blockbenchTexture.getName() + ".png");
                    String string3 = blockbenchTexture.getMcmeta();
                    if (string3 != null) {
                        File file2 = TFile.createFile(this.generator.getTextureFolder(), blockbenchTexture.getName() + ".png.mcmeta");
                        FileWriter fileWriter = new FileWriter(file2);
                        fileWriter.write(string3);
                        fileWriter.close();
                        TLogger.log(2, LogColor.PURPLE + "--" + blockbenchTexture.getName() + ".png.mcmeta");
                    }
                    this.generator.getAtlasManager().addSingle(blockbenchTexture.getNamespace(), blockbenchTexture.getFolder() + "/" + blockbenchTexture.getName());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        });
        return blockbenchPackage.getBlueprint();
    }
}

