/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.model.bone;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.Hitbox;
import com.ticxo.modelengine.api.generator.model.BlueprintBone;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.bone.SubHitbox;
import com.ticxo.modelengine.api.nms.entity.fake.SubHitboxEntity;
import com.ticxo.modelengine.api.nms.world.IDamageSource;
import com.ticxo.modelengine.model.bone.BasicBone;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.NotNull;

public class SubHitboxBone
extends BasicBone
implements SubHitbox {
    private final SubHitboxEntity subHitboxEntity;
    private final Hitbox hitbox;
    private final boolean isOBB;
    private double damageMultiplier = 1.0;
    private final Map<UUID, Entity> boundEntities = Maps.newConcurrentMap();

    public SubHitboxBone(@NotNull ActiveModel activeModel, @NotNull BlueprintBone blueprintBone, @NotNull Hitbox hitbox, boolean bl) {
        super(activeModel, blueprintBone);
        this.hitbox = hitbox;
        this.isOBB = bl;
        this.subHitboxEntity = ModelEngineAPI.getEntityHandler().createSubHitboxEntity(this);
        this.subHitboxEntity.setBone(this);
        activeModel.getSubHitboxHandler().registerSpecialBone(this);
    }

    @Override
    public void spawn() {
        super.spawn();
        this.subHitboxEntity.initialize();
        this.subHitboxEntity.spawn();
    }

    @Override
    public void destroy() {
        this.subHitboxEntity.removeSelf();
        this.activeModel.getSubHitboxHandler().unregisterSpecialBone(this.boneId);
        super.destroy();
    }

    @Override
    public void onHurt(IDamageSource iDamageSource, float f) {
        for (Entity entity : this.boundEntities.values()) {
            ModelEngineAPI.getEntityHandler().hurt(entity, iDamageSource, f);
        }
    }

    @Override
    public void onInteract(Player player, EquipmentSlot equipmentSlot) {
        for (Entity entity : this.boundEntities.values()) {
            PlayerInteractAtEntityEvent playerInteractAtEntityEvent = new PlayerInteractAtEntityEvent(player, entity, this.position, equipmentSlot);
            ModelEngineAPI.api.getPluginManager().callEvent((Event)playerInteractAtEntityEvent);
            if (playerInteractAtEntityEvent.isCancelled()) continue;
            ModelEngineAPI.getEntityHandler().interact(entity, player, equipmentSlot);
        }
    }

    @Override
    public void bindEntity(Entity entity) {
        this.boundEntities.put(entity.getUniqueId(), entity);
        ModelEngineAPI.getEntityHandler().hideBoundSubHitboxEntity(this.activeModel.getModeledEntity(), entity);
    }

    @Override
    public void unbindEntity(Entity entity) {
        this.boundEntities.remove(entity.getUniqueId());
    }

    @Override
    public void onRemove() {
        for (Entity entity : this.boundEntities.values()) {
            entity.remove();
        }
        this.boundEntities.clear();
    }

    @Override
    public SubHitboxEntity getSubHitboxEntity() {
        return this.subHitboxEntity;
    }

    @Override
    public Hitbox getHitbox() {
        return this.hitbox;
    }

    @Override
    public boolean isOBB() {
        return this.isOBB;
    }

    @Override
    public double getDamageMultiplier() {
        return this.damageMultiplier;
    }

    @Override
    public void setDamageMultiplier(double d) {
        this.damageMultiplier = d;
    }

    @Override
    public Map<UUID, Entity> getBoundEntities() {
        return this.boundEntities;
    }
}

