/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.conditions;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.mount.MountManager;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import java.util.Set;
import org.bukkit.entity.Entity;

public class ConditionModelHasPassenger
implements IEntityCondition {
    private final PlaceholderString modelId;
    private final PlaceholderString pbone;
    private final String mode;

    public ConditionModelHasPassenger(MythicLineConfig mythicLineConfig) {
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.pbone = mythicLineConfig.getPlaceholderString(new String[]{"p", "pbone", "seat"}, null, new String[0]);
        this.mode = mythicLineConfig.getString(new String[]{"m", "mode"}, "AND", new String[0]);
    }

    public boolean check(AbstractEntity abstractEntity) {
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(abstractEntity.getUniqueId());
        if (modeledEntity == null) {
            return false;
        }
        MountManager mountManager = modeledEntity.getMountManager();
        if (this.pbone == null) {
            return mountManager.hasPassengers();
        }
        String[] stringArray = this.pbone.get(abstractEntity).split(",");
        String string = MythicUtils.getOrNull(this.modelId, abstractEntity);
        if (string == null) {
            if ("OR".equals(this.mode)) {
                for (String string2 : modeledEntity.getModels().keySet()) {
                    for (String string3 : stringArray) {
                        Set<Entity> set = mountManager.getPassengersOnSeat(string2, string3);
                        if (set.isEmpty()) continue;
                        return true;
                    }
                }
                return false;
            }
            for (String string4 : modeledEntity.getModels().keySet()) {
                for (String string5 : stringArray) {
                    Set<Entity> set = mountManager.getPassengersOnSeat(string4, string5);
                    if (!set.isEmpty()) continue;
                    return false;
                }
            }
        } else {
            if ("OR".equals(this.mode)) {
                for (String string6 : stringArray) {
                    Set<Entity> set = mountManager.getPassengersOnSeat(string, string6);
                    if (set.isEmpty()) continue;
                    return true;
                }
                return false;
            }
            for (String string7 : stringArray) {
                Set<Entity> set = mountManager.getPassengersOnSeat(string, string7);
                if (!set.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }
}

