/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.google.common.collect.Lists;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.nms.entity.fake.BoneRenderer;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.tasks.Task;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.Arrays;
import java.util.List;

public class MechanicCycleParts
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString partId;
    private final PlaceholderString nModelId;
    private final List<String> cycledParts = Lists.newArrayList();
    private final int startingFrame = 0;
    private final int interval;
    private final int duration;

    public MechanicCycleParts(MythicLineConfig mythicLineConfig) {
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.partId = mythicLineConfig.getPlaceholderString(new String[]{"p", "pid", "part", "partid"}, null, new String[0]);
        this.nModelId = mythicLineConfig.getPlaceholderString(new String[]{"nm", "nmid", "newmodel", "newmodelid"}, null, new String[0]);
        String string = mythicLineConfig.getString(new String[]{"np", "npid", "newpart", "newpartid", "newparts", "cycledparts"}, "", new String[0]);
        this.cycledParts.addAll(Arrays.asList(string.split(",")));
        this.interval = mythicLineConfig.getInteger(new String[]{"interval", "i"}, 1);
        this.duration = mythicLineConfig.getInteger(new String[]{"duration", "d"}, this.cycledParts.size());
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(abstractEntity.getUniqueId());
        if (modeledEntity == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        ActiveModel activeModel = MythicUtils.getActiveModelOrNull(modeledEntity, string);
        if (activeModel == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string2 = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)skillMetadata, abstractEntity);
        if (string2 == null) {
            return SkillResult.INVALID_CONFIG;
        }
        BoneRenderer boneRenderer = (BoneRenderer)activeModel.getRendererHandler().getFakeEntity().get(string2);
        if (boneRenderer == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string3 = MythicUtils.getOrNull(this.nModelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        ModelBlueprint modelBlueprint = MythicUtils.getBlueprintOrNull(string3);
        if (modelBlueprint == null) {
            return SkillResult.INVALID_CONFIG;
        }
        new Animator(skillMetadata, abstractEntity, activeModel, string2, modelBlueprint);
        return SkillResult.SUCCESS;
    }

    private class Animator
    implements Runnable,
    Terminable {
        private final SkillMetadata data;
        private final AbstractEntity target;
        private final ActiveModel model;
        private final String partId;
        private final ModelBlueprint modelBlueprint;
        private final Task task;
        private int frame = 0;

        public Animator(SkillMetadata skillMetadata, AbstractEntity abstractEntity, ActiveModel activeModel, String string, ModelBlueprint modelBlueprint) {
            this.data = skillMetadata;
            this.target = abstractEntity;
            this.model = activeModel;
            this.partId = string;
            this.modelBlueprint = modelBlueprint;
            this.task = Schedulers.sync().runRepeating((Runnable)this, 0L, (long)MechanicCycleParts.this.interval);
        }

        @Override
        public void run() {
            if (this.target.isDead()) {
                this.terminate();
                return;
            }
            if (this.task.getTimesRan() > MechanicCycleParts.this.duration) {
                this.terminate();
                return;
            }
            BoneRenderer boneRenderer = (BoneRenderer)this.model.getRendererHandler().getFakeEntity().get(this.partId);
            if (boneRenderer == null) {
                this.terminate();
                return;
            }
            String string = MechanicCycleParts.this.cycledParts.get(this.frame);
            Integer n = this.modelBlueprint.getItemIds().get(string);
            if (n == null) {
                this.terminate();
                return;
            }
            boneRenderer.setData(n);
            if (++this.frame > MechanicCycleParts.this.cycledParts.size()) {
                this.frame = 0;
            }
        }

        public void close() {
            this.task.terminate();
        }
    }
}

