/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.animation.AnimationHandler;
import com.ticxo.modelengine.api.animation.state.DefaultStateHandler;
import com.ticxo.modelengine.api.animation.state.ModelState;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;

public class MechanicDefaultState
implements ITargetedEntitySkill {
    private final MythicLineConfig config;
    private final PlaceholderString modelId;
    private final PlaceholderString type;
    private ModelState stateType;

    public MechanicDefaultState(MythicLineConfig mythicLineConfig) {
        this.config = mythicLineConfig;
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.type = mythicLineConfig.getPlaceholderString(new String[]{"t", "type"}, null, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(abstractEntity.getUniqueId());
        if (modeledEntity == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string = MythicUtils.getOrNull(this.type, (PlaceholderMeta)skillMetadata, abstractEntity);
        if (string == null) {
            return SkillResult.INVALID_CONFIG;
        }
        this.stateType = ModelState.get(string);
        String string2 = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        MythicUtils.executeOptModelId(modeledEntity, string2, activeModel -> this.configureModel((ActiveModel)activeModel, skillMetadata, abstractEntity));
        return SkillResult.SUCCESS;
    }

    private void configureModel(ActiveModel activeModel, SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        DefaultStateHandler defaultStateHandler = activeModel.getDefaultStateHandler();
        DefaultStateHandler.Property property = defaultStateHandler.getProperty(this.stateType);
        PlaceholderString placeholderString = this.config.getPlaceholderString(new String[]{"s", "state"}, property.getAnimation(), new String[0]);
        PlaceholderInt placeholderInt = this.config.getPlaceholderInteger(new String[]{"li", "lerpin"}, (int)(property.getLerpIn() * 20.0), new String[0]);
        PlaceholderInt placeholderInt2 = this.config.getPlaceholderInteger(new String[]{"lo", "lerpout"}, (int)(property.getLerpOut() * 20.0), new String[0]);
        PlaceholderDouble placeholderDouble = this.config.getPlaceholderDouble(new String[]{"sp", "speed"}, property.getSpeed(), new String[0]);
        String string = placeholderString.get((PlaceholderMeta)skillMetadata, abstractEntity);
        if (!activeModel.getBlueprint().getAnimations().containsKey(string)) {
            return;
        }
        defaultStateHandler.setProperty(this.stateType, new DefaultStateHandler.Property(string, (double)placeholderInt.get((PlaceholderMeta)skillMetadata, abstractEntity) / 20.0, (double)placeholderInt2.get((PlaceholderMeta)skillMetadata, abstractEntity) / 20.0, placeholderDouble.get((PlaceholderMeta)skillMetadata, abstractEntity)));
        AnimationHandler animationHandler = activeModel.getAnimationHandler();
        if (animationHandler.isPlayingAnimation(property.getAnimation())) {
            animationHandler.stopAnimation(property.getAnimation());
            activeModel.playDefaultAnimation(this.stateType);
        }
    }
}

